/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AffordableFilter;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public strictfp class BuildFromDesignButton
extends UniScreen.Button {
    public ShipType type;

    public BuildFromDesignButton(ShipType type) {
        this.type = type;
    }

    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof DefencesIntent;
    }

    @Override
    public boolean enabled(UniScreen us) {
        return us.city == null || !us.city.isTown || this.type == ShipType.BUILDING;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Build_" + this.type.name(), new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        this.buildFromTemplate(us, this.type);
    }

    @Override
    public String hotkey(UniScreen us) {
        switch (this.type) {
            case AIRSHIP: {
                return "I";
            }
            case BUILDING: {
                return "B";
            }
            case LANDSHIP: {
                return "N";
            }
        }
        return null;
    }

    private void buildFromTemplate(UniScreen us, ShipType st) {
        Empire empire = us.wm.owner(us.city);
        ShipHelperWidget shw = ShipHelperWidget.get(st, empire.arms, empire.bonuses(), null, empire.money);
        ConstructionBackend cbe = ShipEditorUtils.shipsList(st, shw);
        FileScreen fs = new FileScreen(cbe, new OpenMission(us.g, us, st, empire, cbe), shw, new PriceInlineInfo(shw, null), this.type.name());
        fs.enabledFilter = new AffordableFilter(empire.money, shw, null);
        fs.backgroundTask = ((DefencesIntent)us.intent).ss;
        us.g.s = fs;
    }

    private strictfp static class OpenMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;
        private final ShipType type;
        private final Empire empire;
        private final ConstructionBackend backend;

        public OpenMission(AirshipGame g, UniScreen us, ShipType type, Empire empire, ConstructionBackend backend) {
            this.g = g;
            this.us = us;
            this.type = type;
            this.empire = empire;
            this.backend = backend;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.OPEN;
        }

        @Override
        public String text() {
            return Lang._t("Open_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Open", new Object[0]);
        }

        @Override
        public String initialInput() {
            return "";
        }

        @Override
        public void fileSelected(String path) {
            this.g.s = this.us;
            try {
                Airship ship = new Airship(new JSONObject(FileUtils.readFileToString((File)this.backend.getFile(FileScreen.splitPath(path)), (String)"UTF-8")));
                ship.constructionBonuses = this.empire.bonuses();
                ship.currentBonuses = this.empire.bonuses();
                ship.repair();
                ship.updateOriginalDesign();
                this.us.tool = new PlaceShipTool(ship, false, null, 1, true);
            }
            catch (Loadable.NotFoundException e) {
                this.g.showError(e.getMessage());
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_ship_or_building", new Object[0]), e, path, false);
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }
}

