/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.PhysicsRect;
import java.util.ArrayList;
import java.util.Iterator;

public strictfp abstract class Body
extends PhysicsRect {
    public transient double newX;
    public transient double oldX;
    private double xSpeed;
    public transient double postCollideXSpeed;
    private transient double xForce;
    public transient double groupXSpeed;
    public transient double newY;
    public transient double oldY;
    private double ySpeed;
    public transient double postCollideYSpeed;
    private transient double yForce;
    public transient double groupYSpeed;
    public transient double lastExertedXForce;
    public transient double lastExertedYForce;
    public transient double exertedXForce;
    public transient double exertedYForce;
    public transient ArrayList<Body> colliderGroup;
    public transient ArrayList<Particle> stuckParticles = new ArrayList();

    public void particlesTick(int ms, Combat c) {
        double dripSpeed = c.timeOfDay.effect.rain ? 5.0E-4 : 2.0E-4;
        Iterator<Particle> it = this.stuckParticles.iterator();
        while (it.hasNext()) {
            Particle p = it.next();
            p.life -= ms;
            if (p.life <= 0) {
                it.remove();
                return;
            }
            if (p.type.dissolveWhenStuck) continue;
            p.y += dripSpeed * (double)ms;
            if (!(p.y > this.getBBHeight())) continue;
            p.dx = 0.0;
            p.dy = 0.02;
            p.x += this.getX();
            p.y += this.getY();
            p.life /= 64;
            p.lifespan = p.type.maxLifespan;
            c.particles.add(p);
            it.remove();
        }
    }

    public abstract boolean canParticleStick(double var1, double var3);

    public void removeUnstuckParticles() {
        Iterator<Particle> it = this.stuckParticles.iterator();
        while (it.hasNext()) {
            Particle p = it.next();
            if (this.canParticleStick(this.getX() + p.x, this.getY() + p.y)) continue;
            it.remove();
        }
    }

    public abstract int getCollisionMass();

    public abstract int getMass();

    public abstract boolean isImmobile();

    public abstract boolean removeMe();

    public abstract double elasticity();

    public abstract double horizontalAirFriction();

    public abstract double verticalAirFriction();

    public abstract boolean collidesWith(PhysicsRect var1);

    public abstract void doCollision(Body var1, double var2, Combat var4, boolean var5);

    public abstract boolean isAtSpeed();

    public final double getxSpeed() {
        return this.xSpeed;
    }

    public final void setxSpeed(double xSpeed) {
        if (Double.isNaN(xSpeed)) {
            throw new IllegalArgumentException("xSpeed is NaN");
        }
        if (Double.isInfinite(xSpeed)) {
            throw new IllegalArgumentException("xSpeed is infinite");
        }
        this.xSpeed = xSpeed;
    }

    public final double getySpeed() {
        return this.ySpeed;
    }

    public final void setySpeed(double ySpeed) {
        if (Double.isNaN(ySpeed)) {
            throw new IllegalArgumentException("ySpeed is NaN");
        }
        if (Double.isInfinite(ySpeed)) {
            throw new IllegalArgumentException("ySpeed is infinite");
        }
        this.ySpeed = ySpeed;
    }

    public double getxForce() {
        return this.xForce;
    }

    public void setxForce(double xForce) {
        if (Double.isNaN(xForce)) {
            throw new IllegalArgumentException("xForce is NaN");
        }
        if (Double.isInfinite(xForce)) {
            throw new IllegalArgumentException("xForce is infinite");
        }
        this.xForce = xForce;
    }

    public double getyForce() {
        return this.yForce;
    }

    public void setyForce(double yForce) {
        if (Double.isNaN(yForce)) {
            throw new IllegalArgumentException("yForce is NaN");
        }
        if (Double.isInfinite(yForce)) {
            throw new IllegalArgumentException("yForce is infinite");
        }
        this.yForce = yForce;
    }
}

