/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Bird;
import com.zarkonnen.airships.Loadable;
import java.util.ArrayList;
import org.json.JSONObject;

public strictfp class BirdType
extends Loadable {
    public final Bird.Behavior behavior;
    public final double maxSpeed;
    public final Appearance left;
    public final Appearance right;
    public final Appearance down;
    public final Bird.Spawner spawner;

    public BirdType(JSONObject o) {
        super(o.getString("name"));
        this.maxSpeed = o.getInt("maxSpeed");
        this.left = new Appearance(o.getJSONObject("left"));
        this.right = new Appearance(o.getJSONObject("right"));
        this.down = new Appearance(o.getJSONObject("down"));
        this.behavior = o.getString("behavior").equals("circle") ? new Bird.Circle(o.optInt("circleW", 100), o.optInt("circleH", 10), o.optInt("upDownH", 200), o.optInt("circlePeriod", 5100), o.optInt("upDownPeriod", 62300)) : (o.getString("behavior").equals("flyAcross") ? new Bird.FlyAcross() : new Bird.Boid());
        this.spawner = o.getString("spawner").equals("v") ? new Bird.VSpawner(o.getInt("vMinY"), o.getInt("vMaxY"), o.getInt("vXSpawn")) : (o.optBoolean("flockTargetH", false) ? new Bird.FlockSpawner(o.getInt("flockMin"), o.getInt("flockMax"), o.getInt("flockDist"), o.getInt("flockTargetH")) : new Bird.FlockSpawner(o.getInt("flockMin"), o.getInt("flockMax"), o.getInt("flockDist")));
    }

    public void spawn(ArrayList<Bird> birds, double minX, double minY, double maxX, double maxY) {
        this.spawner.spawn(birds, this, minX, minY, maxX, maxY);
    }

    public static BirdType ofName(String name) {
        return Loadable.ofName(BirdType.class, name);
    }
}

