/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.BonusableValue;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class BeamSpec {
    public int fadeInTime;
    public int steadyTime;
    public int fadeOutTime;
    public int moveDistance;
    public boolean hitTroops;
    public boolean pierceTroops;
    public ArrayList<SubBeam> subBeams = new ArrayList();
    public Clr emitBloomClr;
    public int emitBloomRadius;
    public ParticleType emitParticle;
    public double emitParticleProbability;
    public ParticleType hitParticle;
    public double hitParticleProbability;
    public Clr lightClr;
    public int lightRadius;

    public BeamSpec(JSONObject o) {
        this.fadeInTime = o.optInt("fadeInTime", 0);
        this.steadyTime = Math.max(1, o.getInt("steadyTime"));
        this.fadeOutTime = o.optInt("fadeOutTime", 0);
        this.moveDistance = o.optInt("moveDistance", 0);
        this.hitTroops = o.optBoolean("hitTroops", true);
        this.pierceTroops = o.optBoolean("pierceTroops", false);
        if (o.has("emitBloomClr")) {
            this.emitBloomClr = new Clr(o.getJSONObject("emitBloomClr").getInt("r"), o.getJSONObject("emitBloomClr").getInt("g"), o.getJSONObject("emitBloomClr").getInt("b"));
            this.emitBloomRadius = o.getInt("emitBloomRadius");
        }
        if (o.has("emitParticle")) {
            this.emitParticle = ParticleType.ofName(o.getString("emitParticle"));
            this.emitParticleProbability = o.getDouble("emitParticleProbability");
        }
        if (o.has("hitParticle")) {
            this.hitParticle = ParticleType.ofName(o.getString("hitParticle"));
            this.hitParticleProbability = o.optDouble("hitParticleProbability", 1.0);
        }
        JSONArray a = o.getJSONArray("subBeams");
        for (int i = 0; i < a.length(); ++i) {
            this.subBeams.add(new SubBeam(a.getJSONObject(i)));
        }
        if (o.has("lightClr")) {
            this.lightClr = new Clr(o.getJSONObject("lightClr").getInt("r"), o.getJSONObject("lightClr").getInt("g"), o.getJSONObject("lightClr").getInt("b"));
            this.lightRadius = o.getInt("lightRadius");
        }
    }

    public strictfp static class FromJSON
    implements BonusableValue.FromJSON<BeamSpec> {
        @Override
        public BeamSpec construct(JSONObject o, BonusSet b) {
            return new BeamSpec(o);
        }
    }

    public strictfp static class SubBeam {
        public Clr clr;
        public double width;
        public double flickerAmount;
        public double prevFlickerProportion;
        public double firstBeamFlickerProportion;
        public Img texture;
        public double textureSpeed;

        public SubBeam(JSONObject o) {
            this.clr = new Clr(o.getJSONObject("clr").getInt("r"), o.getJSONObject("clr").getInt("g"), o.getJSONObject("clr").getInt("b"), o.getJSONObject("clr").optInt("a", 255));
            this.width = o.getDouble("width");
            this.flickerAmount = o.optDouble("flickerAmount", 0.0);
            this.prevFlickerProportion = o.optDouble("prevFlickerProportion", 0.0);
            this.firstBeamFlickerProportion = o.optDouble("firstBeamFlickerProportion", 0.0);
            JSONObject bt = o.getJSONObject("texture");
            this.texture = new Img(bt.getString("src"), bt.getInt("x"), bt.getInt("y"), bt.getInt("w"), bt.getInt("h"), bt.optBoolean("flipped", false));
            this.textureSpeed = o.optDouble("textureSpeed", 1.0);
        }
    }
}

