/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.BeamSpec;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.newdawn.slick.opengl.TextureImpl;

public strictfp class BeamLayer
implements UniScreen.VisualLayer {
    private final ArrayList<String> additionalSSBs = new ArrayList();

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.combat == null) {
            return;
        }
        int[] maxSubBeams = new int[]{1};
        for (int i = 0; i < maxSubBeams[0]; ++i) {
            this.additionalSSBs.clear();
            this.draw(d, us, cropX, cropY, cropW, cropH, i, SpritesheetBundle.ofName("spritesheet"), this.additionalSSBs, maxSubBeams);
            for (int j = 0; j < this.additionalSSBs.size(); ++j) {
                this.draw(d, us, cropX, cropY, cropW, cropH, i, SpritesheetBundle.ofName(this.additionalSSBs.get(j)), null, maxSubBeams);
            }
        }
    }

    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH, int sbi, SpritesheetBundle ssb, ArrayList<String> additionalSSBs, int[] maxSubBeams) {
        try {
            GL11.glEnable((int)3553);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)ssb.getTex("").getTextureID());
            GL11.glBegin((int)7);
            for (int si = 0; si < us.combat.sides.size(); ++si) {
                Combat.Side side = us.combat.sides.get(si);
                for (int ai = 0; ai < side.ships.size(); ++ai) {
                    Airship ship = side.ships.get(ai);
                    for (int mi = 0; mi < ship.modules.size(); ++mi) {
                        double shiftPx;
                        Module m = ship.modules.get(mi);
                        if (!m.firingBeam) continue;
                        BeamSpec bs = m.type.beamSpec(ship.currentBonuses);
                        maxSubBeams[0] = Math.max(maxSubBeams[0], bs.subBeams.size());
                        if (sbi >= bs.subBeams.size()) continue;
                        BeamSpec.SubBeam sb = bs.subBeams.get(sbi);
                        if (!sb.texture.src.equals(ssb.name)) {
                            if (additionalSSBs == null || additionalSSBs.contains(sb.texture.src)) continue;
                            additionalSSBs.add(sb.texture.src);
                            continue;
                        }
                        double beamTimeProportion = (double)m.beamAge * 1.0 / (double)(bs.fadeInTime + bs.steadyTime + bs.fadeOutTime);
                        double endX = (double)m.beamStartPositionX * (1.0 - beamTimeProportion) + (double)m.beamEndPositionX * beamTimeProportion;
                        double endY = (double)m.beamStartPositionY * (1.0 - beamTimeProportion) + (double)m.beamEndPositionY * beamTimeProportion;
                        Pt muz = m.currentMuzzle();
                        double mx = muz.x;
                        double my = muz.y;
                        double baseIntensity = 1.0;
                        if (m.beamAge < bs.fadeInTime) {
                            baseIntensity = (double)m.beamAge * 1.0 / (double)bs.fadeInTime;
                        } else if (m.beamAge > bs.fadeInTime + bs.steadyTime && bs.fadeOutTime > 0) {
                            baseIntensity = 1.0 - (double)(m.beamAge - bs.fadeInTime - bs.steadyTime) * 1.0 / (double)bs.fadeOutTime;
                        }
                        double flicker = m.subBeamFlickers[sbi];
                        double intensity = baseIntensity * (1.0 + flicker);
                        double r = sb.width * intensity;
                        double a = Math.atan2(endY - my, endX - mx);
                        GL11.glColor4f((float)((float)sb.clr.r / 255.0f), (float)((float)sb.clr.g / 255.0f), (float)((float)sb.clr.b / 255.0f), (float)((float)sb.clr.a / 255.0f));
                        double beamDist = Math.sqrt((endX - mx) * (endX - mx) + (endY - mx) * (endY - my));
                        if (beamDist < 1.0) continue;
                        double numSegments = beamDist / (double)sb.texture.srcWidth;
                        for (shiftPx = (double)m.beamAge * sb.textureSpeed; shiftPx < 0.0; shiftPx += (double)sb.texture.srcWidth) {
                        }
                        double shiftAlong = (shiftPx %= (double)sb.texture.srcWidth) / beamDist;
                        int segI = -1;
                        while ((double)segI < numSegments) {
                            float startAlong = (float)Math.max(0.0, (double)segI / numSegments + shiftAlong);
                            float segStartX = (float)(mx * (double)(1.0f - startAlong) + endX * (double)startAlong);
                            float segStartY = (float)(my * (double)(1.0f - startAlong) + endY * (double)startAlong);
                            float endAlong = (float)Math.min(1.0, (double)(segI + 1) / numSegments + shiftAlong);
                            float segEndX = (float)(mx * (double)(1.0f - endAlong) + endX * (double)endAlong);
                            float segEndY = (float)(my * (double)(1.0f - endAlong) + endY * (double)endAlong);
                            float texStart = (float)(segI == -1 ? 1.0 - shiftPx / (double)sb.texture.srcWidth : 0.0);
                            float texEnd = (float)((double)(endAlong - startAlong) < 1.0 / numSegments - 0.001 ? 1.0 - shiftPx / (double)sb.texture.srcWidth : 1.0);
                            if (!(startAlong >= endAlong)) {
                                GL11.glTexCoord2d((double)(((float)sb.texture.srcX + (float)sb.texture.srcWidth * texStart) / 1024.0f), (double)((float)sb.texture.srcY / 1024.0f));
                                GL11.glVertex2d((double)((double)segStartX + r * Math.cos(a + 1.5707963267948966)), (double)((double)segStartY + r * Math.sin(a + 1.5707963267948966)));
                                GL11.glTexCoord2d((double)(((float)sb.texture.srcX + (float)sb.texture.srcWidth * texEnd) / 1024.0f), (double)((float)sb.texture.srcY / 1024.0f));
                                GL11.glVertex2d((double)((double)segEndX + r * Math.cos(a + 1.5707963267948966)), (double)((double)segEndY + r * Math.sin(a + 1.5707963267948966)));
                                GL11.glTexCoord2d((double)(((float)sb.texture.srcX + (float)sb.texture.srcWidth * texEnd) / 1024.0f), (double)((float)(sb.texture.srcY + sb.texture.srcHeight) / 1024.0f));
                                GL11.glVertex2d((double)((double)segEndX + r * Math.cos(a - 1.5707963267948966)), (double)((double)segEndY + r * Math.sin(a - 1.5707963267948966)));
                                GL11.glTexCoord2d((double)(((float)sb.texture.srcX + (float)sb.texture.srcWidth * texStart) / 1024.0f), (double)((float)(sb.texture.srcY + sb.texture.srcHeight) / 1024.0f));
                                GL11.glVertex2d((double)((double)segStartX + r * Math.cos(a - 1.5707963267948966)), (double)((double)segStartY + r * Math.sin(a - 1.5707963267948966)));
                            }
                            ++segI;
                        }
                    }
                }
            }
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            TextureImpl.bindNone();
            GL11.glDisable((int)3553);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

