/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.SpritesheetBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public strictfp class ArmourPlate {
    public PaintType paint;
    public ArmourType type;
    public int hp;
    public boolean window;
    public transient Airship ship;
    public transient int blastDmgAbsorb = -1;
    public transient int penDmgAbsorb = -1;
    public static Appearance noApp = null;

    public static void updateAppearances() {
        noApp = new Appearance(SpritesheetBundle.ofName("spritesheet"), 63, 63);
    }

    public int getBlastDmgAbsorb() {
        if (this.blastDmgAbsorb == -1) {
            this.blastDmgAbsorb = this.type.getBlastDmgAbsorb(this.ship.constructionBonuses);
        }
        return this.blastDmgAbsorb;
    }

    public int getPenDmgAbsorb() {
        if (this.penDmgAbsorb == -1) {
            this.penDmgAbsorb = this.type.getPenDmgAbsorb(this.ship.constructionBonuses);
        }
        return this.penDmgAbsorb;
    }

    public int getMaxHP() {
        int max = this.type.getHP(this.ship.constructionBonuses);
        if (this.window) {
            max /= 2;
        }
        return StrictMath.max(0, max);
    }

    public ArmourPlate(boolean window, Airship ship) {
        this.ship = ship;
        this.type = ArmourType.ofName("LT_WOOD");
        this.hp = this.getMaxHP();
        this.window = window;
    }

    public void setType(ArmourType type) {
        this.type = type;
        this.hp = this.getMaxHP();
    }

    public ArmourPlate(JSONObject o, Airship ship) {
        this.ship = ship;
        this.type = ArmourType.ofName(o.getString("type"));
        this.hp = o.getInt("hp");
        this.window = o.getBoolean("window");
        this.paint = o.has("paint") ? PaintType.valueOf(o.getString("paint")) : null;
    }

    public void repair() {
        this.hp = this.getMaxHP();
        this.blastDmgAbsorb = -1;
        this.penDmgAbsorb = -1;
    }

    public Appearance getApp() {
        int maxHP = this.getMaxHP();
        if (maxHP == 0) {
            return noApp;
        }
        if (this.window && this.hp > maxHP / 4 && this.type.windowApp != null) {
            return this.type.windowApp.get(this.ship.currentBonuses);
        }
        if (this.type.damagedApps.get(this.ship.currentBonuses).isEmpty()) {
            return noApp;
        }
        return this.type.damagedApps.get(this.ship.currentBonuses).get(StrictMath.max(0, 4 - this.hp * 4 / maxHP));
    }

    public List<ModuleType.FragmentImg> getFragments(int prevHP, int newHP) {
        int maxHP = this.getMaxHP();
        if (maxHP == 0) {
            return Collections.emptyList();
        }
        int prevAppI = StrictMath.max(0, 4 - prevHP * 4 / maxHP);
        int newAppI = StrictMath.max(0, 4 - newHP * 4 / maxHP);
        ArrayList<ModuleType.FragmentImg> l = this.type.fragments.get(this.ship.currentBonuses)[prevAppI][newAppI];
        return l == null ? Collections.emptyList() : l;
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject().put("type", this.type.name).put("hp", this.hp).put("window", this.window);
        if (this.paint != null) {
            o.put("paint", this.paint.name);
        }
        return o;
    }

    public boolean opaque() {
        return !this.window && this.hp > this.getMaxHP() * 3 / 4;
    }
}

