/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.BonusableValue;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.catengine.util.Pt;
import java.io.Serializable;
import org.json.JSONObject;

public strictfp final class Arc
implements Serializable,
JSONAble {
    public final Direction from;
    public final double sizeRadians;
    public final transient Direction to;
    public final transient double cmpVecX;
    public final transient double cmpVecY;
    public final transient double cmpCos;

    public double getSizeDegrees() {
        return this.sizeRadians * 180.0 / Math.PI;
    }

    private Arc(Direction from, double sizeRadians) {
        if (from == null) {
            throw new IllegalArgumentException("From-direction for an Arc needs to be non-null.");
        }
        if (sizeRadians < 0.0) {
            throw new IllegalArgumentException("Size for an arc needs to be >= 0.");
        }
        this.from = from;
        this.sizeRadians = sizeRadians;
        this.to = from.plus(Direction.ofRadians(sizeRadians));
        Pt cmpVec = from.plus(Direction.ofRadians(sizeRadians / 2.0)).by(1.0);
        this.cmpVecX = cmpVec.x;
        this.cmpVecY = cmpVec.y;
        this.cmpCos = StrictMath.cos(sizeRadians / 2.0);
    }

    public static Arc centeredRadians(double sizeRadians) {
        return Arc.counterclockwiseRadians(-sizeRadians / 2.0, sizeRadians);
    }

    public static Arc centeredRadians(double arcCenter, double sizeRadians) {
        return Arc.counterclockwiseRadians(arcCenter - sizeRadians / 2.0, sizeRadians);
    }

    public static Arc centeredDegrees(double sizeDegrees) {
        return Arc.counterclockwiseDegrees(-sizeDegrees / 2.0, sizeDegrees);
    }

    public static Arc centeredDegrees(double arcCenter, double sizeDegrees) {
        return Arc.counterclockwiseDegrees(arcCenter - sizeDegrees / 2.0, sizeDegrees);
    }

    public static Arc downCenteredDegrees(double sizeDegrees) {
        return Arc.counterclockwiseDegrees(Direction.DOWN.getDegrees() - sizeDegrees / 2.0, sizeDegrees);
    }

    public static Arc upCenteredDegrees(double sizeDegrees) {
        return Arc.counterclockwiseDegrees(Direction.UP.getDegrees() - sizeDegrees / 2.0, sizeDegrees);
    }

    public static Arc backCenteredDegrees(double sizeDegrees) {
        return Arc.counterclockwiseDegrees(Direction.LEFT.getDegrees() - sizeDegrees / 2.0, sizeDegrees);
    }

    public static Arc counterclockwiseRadians(double from, double sizeRadians) {
        return new Arc(Direction.ofRadians(from), sizeRadians);
    }

    public static Arc counterclockwiseDegrees(double from, double sizeDegrees) {
        return new Arc(Direction.ofDegrees(from), sizeDegrees * Math.PI / 180.0);
    }

    public static Arc fromJSON(JSONObject o) {
        return new Arc(Direction.ofRadians(o.getDouble("from")), o.getDouble("sizeRadians"));
    }

    public static Arc fromDescriptiveJSON(JSONObject o) {
        if (o.has("arcCenter")) {
            return Arc.centeredDegrees(o.getInt("arcCenter"), o.getInt("degrees"));
        }
        if (o.optString("direction", "forwards").equals("up")) {
            return Arc.upCenteredDegrees(o.getInt("degrees"));
        }
        if (o.optString("direction", "forwards").equals("down")) {
            return Arc.downCenteredDegrees(o.getInt("degrees"));
        }
        if (o.optString("direction", "forwards").equals("backwards")) {
            return Arc.backCenteredDegrees(o.getInt("degrees"));
        }
        return Arc.centeredDegrees(o.getInt("degrees"));
    }

    public Arc plus(Direction d) {
        return new Arc(this.from.plus(d), this.sizeRadians);
    }

    public Arc minus(Direction d) {
        return new Arc(this.from.minus(d), this.sizeRadians);
    }

    public Arc flipHorizontal() {
        return new Arc(this.to.flipHorizontal(), this.sizeRadians);
    }

    public Arc getInnerTwoThirds() {
        if (this.sizeRadians >= Math.PI * 2) {
            return this;
        }
        return Arc.centeredRadians(this.from.radians + this.sizeRadians / 2.0, this.sizeRadians * 2.0 / 3.0);
    }

    public Direction getMiddle() {
        return Direction.ofRadians(this.from.radians + this.sizeRadians / 2.0);
    }

    public boolean contains(Direction d) {
        return d.minusInRadians(this.from) <= this.sizeRadians;
    }

    public boolean contains(double radians) {
        return Direction.normalizeRadians(radians - this.from.radians) <= this.sizeRadians;
    }

    public boolean containsVector(double dx, double dy) {
        double uDy;
        double vecL = StrictMath.sqrt(dx * dx + dy * dy);
        double uDx = dx / vecL;
        double dotProduct = uDx * this.cmpVecX + (uDy = dy / vecL) * this.cmpVecY;
        return dotProduct >= this.cmpCos;
    }

    @Override
    public JSONObject toJSON() {
        return new JSONObject().put("from", this.from.radians).put("sizeRadians", this.sizeRadians);
    }

    public strictfp static class InnerTwoThirds
    implements BonusableValue.Derive<Arc, Arc> {
        @Override
        public Arc derive(Arc from) {
            return from.getInnerTwoThirds();
        }
    }

    public strictfp static class FromJSON
    implements BonusableValue.FromJSON<Arc> {
        @Override
        public Arc construct(JSONObject o, BonusSet b) {
            return Arc.fromDescriptiveJSON(o);
        }
    }
}

