/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.BonusableValue;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.RotatingColoringShader;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.TileMask;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public strictfp class Appearance {
    private static ShaderProgram sp;
    private static ShaderProgram maskedSP;
    public static ShaderProgram lsp;
    private static ShaderProgram blsp;
    private static ShaderProgram blueprintShader;
    public static ShaderProgram redSolidShader;
    public static ShaderProgram outlineShader;
    private static ShaderProgram subsp;
    private static ShaderProgram sublsp;
    public static boolean shaderLoadFailed;
    public static boolean useSimpleGraphics;
    public static boolean useLighting;
    public static boolean canUseLighting;
    private static boolean IS_MAC;
    public final SpritesheetBundle spritesheetBundle;
    public ArrayList<Frame> frames = new ArrayList();
    public ArrayList<Frame> flippedFrames;
    public int interval = 300;
    private int w = 0;
    private int h = 0;
    private boolean isFlipped = false;
    public HashMap<TileMask, ArrayList<ArrayList<Img>>> rectsForFrames = null;
    public HashMap<TileMask, ArrayList<ArrayList<Img>>> rectsForFlippedFrames = null;
    public static String currentPostfix;
    private static int switchNum;
    public int mySwitchNum = 0;
    private static boolean inited;
    public static boolean shaderLocked;
    private static boolean lockedWithLight;
    public static boolean subShaderLocked;
    public static boolean bevelledLocked;

    public long checksum() {
        int cs = this.spritesheetBundle.name.hashCode();
        for (Img img : this.frames) {
            cs += img.src.hashCode() * 7 + img.srcX * 37 + img.srcY * 193 + img.srcWidth * 401 + img.srcHeight * 1299;
            cs *= 19;
        }
        return cs += this.interval;
    }

    public void draw(Draw d, double x, double y, int ms, boolean flipped) {
        this.draw(d, x, y, 0.0, 0.0, ms, null, flipped);
    }

    public void draw(Draw d, double x, double y, int ms, boolean flipped, Image[] light, float strength, Color ambient, float ambientSaturation) {
        this.draw(d, x, y, 0.0, 0.0, ms, null, flipped, light, strength, ambient, ambientSaturation);
    }

    public void draw(Draw d, double x, double y, int ms, Clr tint, boolean flipped) {
        this.draw(d, x, y, 0.0, 0.0, ms, tint, flipped);
    }

    public void draw(Draw d, double x, double y, int ms, Clr tint, boolean flipped, Image[] light, float strength, Color ambient, float ambientSaturation) {
        this.draw(d, x, y, 0.0, 0.0, ms, tint, flipped, light, strength, ambient, ambientSaturation);
    }

    public void draw(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped) {
        this.draw(d, x, y, w, h, ms, tint, flipped, null, 0.0f, Color.white, 1.0f);
    }

    public static void switchSpritesheet(String postfix) {
        if (postfix.equals(currentPostfix)) {
            return;
        }
        currentPostfix = postfix;
        ++switchNum;
        for (SpritesheetBundle ssb : Loadable.all(SpritesheetBundle.class)) {
            ssb.loadPostfix(currentPostfix);
        }
    }

    public static void reloadSpritesheets() {
        if (currentPostfix == null) {
            return;
        }
        ++switchNum;
        for (SpritesheetBundle ssb : Loadable.all(SpritesheetBundle.class)) {
            ssb.loadPostfix(currentPostfix);
            ssb.initBumps();
        }
    }

    public static void init() {
        if (Loadable.map.containsKey(SpritesheetBundle.class) && !inited) {
            Appearance.switchSpritesheet("");
            for (SpritesheetBundle ssb : Loadable.all(SpritesheetBundle.class)) {
                ssb.initBumps();
            }
            inited = true;
        }
    }

    public void updateSpritesheet() {
        if (this.mySwitchNum < switchNum) {
            this.rectsForFrames = null;
            this.rectsForFlippedFrames = null;
        }
        if (this.mySwitchNum < switchNum && this.spritesheetBundle.bump != null) {
            Image image = this.spritesheetBundle.getSheet(currentPostfix);
            if (image == null) {
                System.err.println("Unable to switch to spritesheet " + this.spritesheetBundle.name + currentPostfix + ".");
                this.mySwitchNum = switchNum;
                return;
            }
            if (this.flippedFrames == null) {
                this.flippedFrames = new ArrayList(this.frames.size());
                for (Frame frame : this.frames) {
                    this.flippedFrames.add(frame.flip());
                }
            }
            for (Img img : this.frames) {
                img.machineImgCache = image.getSubImage(img.srcX, img.srcY, img.srcWidth, img.srcHeight);
                img.machineWCache = img.srcWidth;
                img.machineHCache = img.srcHeight;
            }
            for (Img img : this.flippedFrames) {
                img.machineImgCache = image.getSubImage(img.srcX, img.srcY, img.srcWidth, img.srcHeight).getFlippedCopy(true, false);
                img.machineWCache = img.srcWidth;
                img.machineHCache = img.srcHeight;
            }
            this.mySwitchNum = switchNum;
        }
    }

    public void drawFallback(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped) {
        Frame f2;
        if ((flipped ^= this.isFlipped) && this.flippedFrames == null) {
            this.flippedFrames = new ArrayList(this.frames.size());
            for (Frame f2 : this.frames) {
                this.flippedFrames.add(f2.flip());
            }
        }
        ArrayList<Frame> fs = flipped ? this.flippedFrames : this.frames;
        f2 = fs.get(ms / this.interval % fs.size());
        if (f2.machineImgCache != null) {
            ((Image)f2.machineImgCache).setFilter(9728);
        }
        if (w == 0.0 && h == 0.0) {
            w = f2.srcWidth;
            h = f2.srcHeight;
        }
        d.blit((Img)f2, tint, x + (double)(f2.shiftX * (flipped ? -1 : 1)), y + (double)f2.shiftY, w, h);
    }

    public void maskedDrawFallback(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped, TileMask tileMask) {
        HashMap<TileMask, ArrayList<ArrayList<Img>>> rff;
        if ((flipped ^= this.isFlipped) && this.flippedFrames == null) {
            this.flippedFrames = new ArrayList(this.frames.size());
            for (Frame f : this.frames) {
                this.flippedFrames.add(f.flip());
            }
        }
        ArrayList<Frame> fs = flipped ? this.flippedFrames : this.frames;
        int frameIndex = ms / this.interval % fs.size();
        Frame f = fs.get(frameIndex);
        Image image = this.spritesheetBundle.getSheet(currentPostfix);
        if (image == null) {
            image = this.spritesheetBundle.getSheet(null);
        }
        if (image == null) {
            return;
        }
        if (this.rectsForFrames == null) {
            this.rectsForFrames = new HashMap();
            this.rectsForFlippedFrames = new HashMap();
        }
        HashMap<TileMask, ArrayList<ArrayList<Img>>> hashMap = rff = flipped ? this.rectsForFlippedFrames : this.rectsForFrames;
        if (!rff.containsKey(tileMask)) {
            ArrayList frameRects = new ArrayList();
            for (int fi = 0; fi < fs.size(); ++fi) {
                Frame currentF = fs.get(fi);
                ArrayList<Img> imgs = new ArrayList<Img>();
                int rsz = tileMask.rects.size();
                for (int ri = 0; ri < rsz; ++ri) {
                    TileMask.Rect r = tileMask.rects.get(ri);
                    Img img = new Img(currentF.src, currentF.srcX + r.x, currentF.srcY + r.y, r.w, r.h, currentF.flipped);
                    img.machineImgCache = image.getSubImage(img.srcX, img.srcY, img.srcWidth, img.srcHeight);
                    img.machineWCache = img.srcWidth;
                    img.machineHCache = img.srcHeight;
                    imgs.add(img);
                }
                frameRects.add(imgs);
            }
            rff.put(tileMask, frameRects);
        }
        ArrayList<Img> imgs = rff.get(tileMask).get(frameIndex);
        int isz = imgs.size();
        for (int ii = 0; ii < isz; ++ii) {
            Img img = imgs.get(ii);
            if (img.machineImgCache != null) {
                ((Image)img.machineImgCache).setFilter(9728);
            }
            d.blit(img, tint, x + (double)(f.shiftX * (flipped ? -1 : 1)) + (double)img.srcX - (double)f.srcX, y + (double)f.shiftY + (double)img.srcY - (double)f.srcY);
        }
    }

    public void drawAsRedSolid(Draw d, double x, double y, int ms, boolean flipped) {
        this.drawAsRedSolid(d, x, y, 0.0, 0.0, ms, flipped);
    }

    public void drawAsRedSolid(Draw d, double x, double y, double w, double h, int ms, boolean flipped) {
        this.updateSpritesheet();
        if (shaderLoadFailed || useSimpleGraphics || !useLighting || !canUseLighting) {
            this.drawFallback(d, x, y, w, h, ms, Clr.RED, flipped);
            return;
        }
        if (redSolidShader == null) {
            try {
                redSolidShader = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/passthrough.vert"), (String)AGame.getStaticGameDirectoryPath("data/redoutline.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        redSolidShader.bind();
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex(currentPostfix).getTextureID());
        redSolidShader.setUniform1i("tex", 0);
        Frame f = this.frames.get(ms / this.interval % this.frames.size());
        x += (double)(f.shiftX * (flipped ? -1 : 1));
        y += (double)f.shiftY;
        if (w == 0.0 && h == 0.0) {
            w = f.srcWidth;
            h = f.srcHeight;
        }
        GL11.glBegin((int)7);
        if (flipped ^ this.isFlipped ^ f.flipped) {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        GL11.glEnd();
        redSolidShader.unbind();
        TextureImpl.bindNone();
    }

    public void drawAsOutline(Draw d, double x, double y, double w, double h, int ms, boolean flipped, Clr c) {
        this.updateSpritesheet();
        if (shaderLoadFailed || useSimpleGraphics || !useLighting || !canUseLighting) {
            this.drawFallback(d, x, y, w, h, ms, Clr.RED, flipped);
            return;
        }
        if (outlineShader == null) {
            try {
                outlineShader = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/passthrough2.vert"), (String)AGame.getStaticGameDirectoryPath("data/outline.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        outlineShader.bind();
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex(currentPostfix).getTextureID());
        outlineShader.setUniform1i("tex", 0);
        Frame f = this.frames.get(ms / this.interval % this.frames.size());
        x += (double)(f.shiftX * (flipped ? -1 : 1));
        y += (double)f.shiftY;
        if (w == 0.0 && h == 0.0) {
            w = f.srcWidth;
            h = f.srcHeight;
        }
        GL11.glBegin((int)7);
        GL11.glColor4f((float)((float)c.r / 255.0f), (float)((float)c.g / 255.0f), (float)((float)c.b / 255.0f), (float)((float)c.a / 255.0f));
        if (flipped ^ this.isFlipped ^ f.flipped) {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        GL11.glEnd();
        outlineShader.unbind();
        TextureImpl.bindNone();
    }

    public void drawAsBlueprint(Draw d, double x, double y, int ms, boolean flipped, float intensity) {
        this.drawAsBlueprint(d, x, y, 0.0, 0.0, ms, flipped, intensity);
    }

    public static void drawAsBlueprint(Img img, Draw d, double x, double y, double w, double h, boolean flipped, float intensity) {
        if (img instanceof Frame) {
            x += (double)(((Frame)img).shiftX * (flipped ? -1 : 1));
            x += (double)((Frame)img).shiftY;
        }
        if (shaderLoadFailed || useSimpleGraphics) {
            d.blit(img, x, y, w, h);
            return;
        }
        if (blueprintShader == null) {
            try {
                blueprintShader = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/passthrough.vert"), (String)AGame.getStaticGameDirectoryPath("data/blueprint.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        if (!Loadable.hasOfName(SpritesheetBundle.class, img.src)) {
            return;
        }
        blueprintShader.bind();
        blueprintShader.setUniform1f("intensity", intensity);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)SpritesheetBundle.ofName(img.src).getTex(currentPostfix).getTextureID());
        blueprintShader.setUniform1i("tex", 0);
        GL11.glBegin((int)7);
        if (flipped) {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        GL11.glEnd();
        blueprintShader.unbind();
        TextureImpl.bindNone();
    }

    public void drawAsBlueprint(Draw d, double x, double y, double w, double h, int ms, boolean flipped, float intensity) {
        this.updateSpritesheet();
        if (shaderLoadFailed || useSimpleGraphics || !useLighting || !canUseLighting) {
            this.drawFallback(d, x, y, w, h, ms, null, flipped);
            return;
        }
        if (blueprintShader == null) {
            try {
                blueprintShader = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/passthrough.vert"), (String)AGame.getStaticGameDirectoryPath("data/blueprint.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        blueprintShader.bind();
        blueprintShader.setUniform1f("intensity", intensity);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex(currentPostfix).getTextureID());
        blueprintShader.setUniform1i("tex", 0);
        Frame f = this.frames.get(ms / this.interval % this.frames.size());
        x += (double)(f.shiftX * (flipped ? -1 : 1));
        y += (double)f.shiftY;
        if (w == 0.0 && h == 0.0) {
            w = f.srcWidth;
            h = f.srcHeight;
        }
        GL11.glBegin((int)7);
        if (flipped ^ this.isFlipped ^ f.flipped) {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        GL11.glEnd();
        blueprintShader.unbind();
        TextureImpl.bindNone();
    }

    public static void lockShader(SpritesheetBundle ssb, Draw d, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        if (ssb.bumpTex == null) {
            light = null;
        }
        if (ssb.getTex(currentPostfix) == null) {
            return;
        }
        if (shaderLoadFailed || useSimpleGraphics) {
            return;
        }
        boolean bl = lockedWithLight = light != null;
        if (light != null) {
            if (lsp == null) {
                try {
                    lsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/litfrag.vert"), (String)AGame.getStaticGameDirectoryPath("data/litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            lsp.bind();
            GL13.glActiveTexture((int)33985);
            GL11.glBindTexture((int)3553, (int)ssb.bumpTex.getTextureID());
            lsp.setUniform1i("bump", 1);
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
            lsp.setUniform1i("lightFromLeft", 2);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
            lsp.setUniform1i("lightFromTop", 3);
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
            lsp.setUniform1i("lightFromRight", 4);
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
            lsp.setUniform1i("lightFromBottom", 5);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)ssb.getTex(currentPostfix).getTextureID());
            lsp.setUniform1i("tex", 0);
            lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
            lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
            lsp.setUniform4f("ambient", ambient);
            lsp.setUniform1f("ambientSaturation", ambientSaturation);
            lsp.enableVertexAttribute("flipped");
            lsp.enableVertexAttribute("tint");
            lsp.enableVertexAttribute("strength");
        } else {
            if (sp == null) {
                try {
                    sp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/passthrough.vert"), (String)AGame.getStaticGameDirectoryPath("data/frag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            sp.bind();
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)ssb.getTex(currentPostfix).getTextureID());
            sp.setUniform1i("tex", 0);
            sp.enableVertexAttribute("tint");
        }
        GL11.glBegin((int)7);
        shaderLocked = true;
    }

    public static void unlockShader(boolean light) {
        if (shaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (lockedWithLight) {
                lsp.unbind();
            } else {
                sp.unbind();
            }
            TextureImpl.bindNone();
            shaderLocked = false;
        }
    }

    public void draw(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        if (subShaderLocked || bevelledLocked || RotatingShader.shaderLocked || RotatingColoringShader.shaderLocked) {
            AirshipGame.instance.reportError("Appearance.draw mis-lock Appearance.shaderLocked=" + shaderLocked + " Appearance.subShaderLocked=" + subShaderLocked + " Appearance.bevelledLocked=" + bevelledLocked + " RotatingShader.shaderLocked=" + RotatingShader.shaderLocked + " RotatingColoringShader.shaderLocked=" + RotatingColoringShader.shaderLocked, null, null, false, true);
        }
        this.updateSpritesheet();
        if (this.spritesheetBundle.bumpTex == null) {
            light = null;
        }
        if (shaderLoadFailed || useSimpleGraphics || this.spritesheetBundle.getTex(currentPostfix) == null) {
            this.drawFallback(d, x, y, w, h, ms, tint, flipped);
            return;
        }
        if (light != null) {
            if (lsp == null) {
                try {
                    lsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/litfrag.vert"), (String)AGame.getStaticGameDirectoryPath("data/litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!shaderLocked) {
                lsp.bind();
                GL13.glActiveTexture((int)33985);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.bumpTex.getTextureID());
                lsp.setUniform1i("bump", 1);
                GL13.glActiveTexture((int)33986);
                GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
                lsp.setUniform1i("lightFromLeft", 2);
                GL13.glActiveTexture((int)33987);
                GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
                lsp.setUniform1i("lightFromTop", 3);
                GL13.glActiveTexture((int)33988);
                GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
                lsp.setUniform1i("lightFromRight", 4);
                GL13.glActiveTexture((int)33989);
                GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
                lsp.setUniform1i("lightFromBottom", 5);
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex(currentPostfix).getTextureID());
                lsp.setUniform1i("tex", 0);
                lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
                lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
                lsp.setUniform4f("ambient", ambient);
                lsp.setUniform1f("ambientSaturation", ambientSaturation);
                lsp.enableVertexAttribute("flipped");
                lsp.enableVertexAttribute("tint");
                lsp.enableVertexAttribute("strength");
            }
        } else {
            if (sp == null) {
                try {
                    sp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/passthrough.vert"), (String)AGame.getStaticGameDirectoryPath("data/frag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!shaderLocked) {
                sp.bind();
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex(currentPostfix).getTextureID());
                sp.setUniform1i("tex", 0);
                sp.enableVertexAttribute("tint");
            }
        }
        Frame f = this.frames.get(ms / this.interval % this.frames.size());
        x += (double)(f.shiftX * (flipped ? -1 : 1));
        y += (double)f.shiftY;
        if (w == 0.0 && h == 0.0) {
            w = f.srcWidth;
            h = f.srcHeight;
        }
        if (!shaderLocked) {
            GL11.glBegin((int)7);
        }
        if (light != null) {
            GL20.glVertexAttrib1f((int)lsp.getAttributeID("flipped"), (float)(flipped ^ this.isFlipped ^ f.flipped ? 1.0f : 0.0f));
            if (tint == null) {
                GL20.glVertexAttrib4f((int)lsp.getAttributeID("tint"), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL20.glVertexAttrib4f((int)lsp.getAttributeID("tint"), (float)((float)tint.r / 255.0f), (float)((float)tint.g / 255.0f), (float)((float)tint.b / 255.0f), (float)1.0f);
            }
            GL20.glVertexAttrib1f((int)lsp.getAttributeID("strength"), (float)lightStrength);
        } else if (tint == null) {
            GL20.glVertexAttrib4f((int)sp.getAttributeID("tint"), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GL20.glVertexAttrib4f((int)sp.getAttributeID("tint"), (float)((float)tint.r / 255.0f), (float)((float)tint.g / 255.0f), (float)((float)tint.b / 255.0f), (float)1.0f);
        }
        if (flipped ^ this.isFlipped ^ f.flipped) {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        if (!shaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (light != null) {
                lsp.unbind();
            } else {
                sp.unbind();
            }
            TextureImpl.bindNone();
        }
    }

    public static void lockSubShader(SpritesheetBundle ssb, Draw d, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        if (ssb.bumpTex == null) {
            light = null;
        }
        if (ssb.getTex(currentPostfix) == null) {
            return;
        }
        if (ssb.getTex("") == null) {
            return;
        }
        if (shaderLoadFailed || useSimpleGraphics) {
            return;
        }
        boolean bl = lockedWithLight = light != null;
        if (light != null) {
            if (sublsp == null) {
                try {
                    sublsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/sub_litfrag.vert"), (String)AGame.getStaticGameDirectoryPath("data/sub_litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            sublsp.bind();
            GL13.glActiveTexture((int)33985);
            GL11.glBindTexture((int)3553, (int)ssb.bumpTex.getTextureID());
            sublsp.setUniform1i("bump", 1);
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
            sublsp.setUniform1i("lightFromLeft", 2);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
            sublsp.setUniform1i("lightFromTop", 3);
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
            sublsp.setUniform1i("lightFromRight", 4);
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
            sublsp.setUniform1i("lightFromBottom", 5);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)ssb.getTex(currentPostfix).getTextureID());
            sublsp.setUniform1i("tex", 0);
            sublsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
            sublsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
            sublsp.setUniform4f("ambient", ambient);
            sublsp.setUniform1f("ambientSaturation", ambientSaturation);
            sublsp.enableVertexAttribute("flipped");
            sublsp.enableVertexAttribute("tint");
            sublsp.enableVertexAttribute("srcA");
            sublsp.enableVertexAttribute("trgA");
        } else {
            if (subsp == null) {
                try {
                    subsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/sub_frag.vert"), (String)AGame.getStaticGameDirectoryPath("data/sub_frag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            subsp.bind();
            GL13.glActiveTexture((int)33985);
            GL11.glBindTexture((int)3553, (int)ssb.getTex("").getTextureID());
            subsp.setUniform1i("refTex", 1);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)ssb.getTex(currentPostfix).getTextureID());
            subsp.setUniform1i("tex", 0);
            subsp.enableVertexAttribute("tint");
            subsp.enableVertexAttribute("srcA");
            subsp.enableVertexAttribute("trgA");
        }
        GL11.glBegin((int)7);
        subShaderLocked = true;
    }

    public static void unlockSubShader(boolean light) {
        if (subShaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (lockedWithLight) {
                sublsp.unbind();
            } else {
                subsp.unbind();
            }
            TextureImpl.bindNone();
            subShaderLocked = false;
        }
    }

    public void drawSub(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr src, Clr trg, float trgShiny) {
        if (shaderLocked || bevelledLocked || RotatingShader.shaderLocked || RotatingColoringShader.shaderLocked) {
            AirshipGame.instance.reportError("Appearance.drawSub mis-lock Appearance.shaderLocked=" + shaderLocked + " Appearance.subShaderLocked=" + subShaderLocked + " Appearance.bevelledLocked=" + bevelledLocked + " RotatingShader.shaderLocked=" + RotatingShader.shaderLocked + " RotatingColoringShader.shaderLocked=" + RotatingColoringShader.shaderLocked, null, null, false, true);
        }
        this.updateSpritesheet();
        if (this.spritesheetBundle.bumpTex == null) {
            light = null;
        }
        if (shaderLoadFailed || useSimpleGraphics || this.spritesheetBundle.getTex(currentPostfix) == null) {
            this.drawFallback(d, x, y, w, h, ms, tint, flipped);
            return;
        }
        if (light != null) {
            if (sublsp == null) {
                try {
                    sublsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/sub_litfrag.vert"), (String)AGame.getStaticGameDirectoryPath("data/sub_litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!subShaderLocked) {
                sublsp.bind();
                GL13.glActiveTexture((int)33985);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.bumpTex.getTextureID());
                sublsp.setUniform1i("bump", 1);
                GL13.glActiveTexture((int)33986);
                GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
                sublsp.setUniform1i("lightFromLeft", 2);
                GL13.glActiveTexture((int)33987);
                GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
                sublsp.setUniform1i("lightFromTop", 3);
                GL13.glActiveTexture((int)33988);
                GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
                sublsp.setUniform1i("lightFromRight", 4);
                GL13.glActiveTexture((int)33989);
                GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
                sublsp.setUniform1i("lightFromBottom", 5);
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex(currentPostfix).getTextureID());
                lsp.setUniform1i("tex", 0);
                sublsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
                sublsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
                sublsp.setUniform4f("ambient", ambient);
                sublsp.setUniform1f("ambientSaturation", ambientSaturation);
                sublsp.enableVertexAttribute("flipped");
                sublsp.enableVertexAttribute("tint");
                sublsp.enableVertexAttribute("strength");
                sublsp.enableVertexAttribute("srcA");
                sublsp.enableVertexAttribute("trgA");
            }
        } else {
            if (subsp == null) {
                try {
                    subsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/sub_frag.vert"), (String)AGame.getStaticGameDirectoryPath("data/sub_frag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!subShaderLocked) {
                subsp.bind();
                GL13.glActiveTexture((int)33985);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex("").getTextureID());
                subsp.setUniform1i("refTex", 1);
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex(currentPostfix).getTextureID());
                subsp.setUniform1i("tex", 0);
                subsp.enableVertexAttribute("tint");
                subsp.enableVertexAttribute("srcA");
                subsp.enableVertexAttribute("trgA");
            }
        }
        Frame f = this.frames.get(ms / this.interval % this.frames.size());
        x += (double)(f.shiftX * (flipped ? -1 : 1));
        y += (double)f.shiftY;
        if (w == 0.0 && h == 0.0) {
            w = f.srcWidth;
            h = f.srcHeight;
        }
        if (!subShaderLocked) {
            GL11.glBegin((int)7);
        }
        if (light != null) {
            GL20.glVertexAttrib1f((int)sublsp.getAttributeID("flipped"), (float)(flipped ^ this.isFlipped ^ f.flipped ? 1.0f : 0.0f));
            if (tint == null) {
                GL20.glVertexAttrib4f((int)sublsp.getAttributeID("tint"), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL20.glVertexAttrib4f((int)sublsp.getAttributeID("tint"), (float)((float)tint.r / 255.0f), (float)((float)tint.g / 255.0f), (float)((float)tint.b / 255.0f), (float)1.0f);
            }
            GL20.glVertexAttrib1f((int)sublsp.getAttributeID("strength"), (float)lightStrength);
            if (src == null) {
                GL20.glVertexAttrib3f((int)sublsp.getAttributeID("srcA"), (float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL20.glVertexAttrib4f((int)sublsp.getAttributeID("trgA"), (float)1.0f, (float)0.0f, (float)1.0f, (float)0.36f);
            } else {
                GL20.glVertexAttrib3f((int)sublsp.getAttributeID("srcA"), (float)((float)src.r / 255.0f), (float)((float)src.g / 255.0f), (float)((float)src.b / 255.0f));
                GL20.glVertexAttrib4f((int)sublsp.getAttributeID("trgA"), (float)((float)trg.r / 255.0f), (float)((float)trg.g / 255.0f), (float)((float)trg.b / 255.0f), (float)trgShiny);
            }
        } else {
            if (tint == null) {
                GL20.glVertexAttrib4f((int)subsp.getAttributeID("tint"), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL20.glVertexAttrib4f((int)subsp.getAttributeID("tint"), (float)((float)tint.r / 255.0f), (float)((float)tint.g / 255.0f), (float)((float)tint.b / 255.0f), (float)1.0f);
            }
            if (src == null) {
                GL20.glVertexAttrib3f((int)subsp.getAttributeID("srcA"), (float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL20.glVertexAttrib4f((int)subsp.getAttributeID("trgA"), (float)1.0f, (float)0.0f, (float)1.0f, (float)0.36f);
            } else {
                GL20.glVertexAttrib3f((int)subsp.getAttributeID("srcA"), (float)((float)src.r / 255.0f), (float)((float)src.g / 255.0f), (float)((float)src.b / 255.0f));
                GL20.glVertexAttrib4f((int)subsp.getAttributeID("trgA"), (float)((float)trg.r / 255.0f), (float)((float)trg.g / 255.0f), (float)((float)trg.b / 255.0f), (float)trgShiny);
            }
        }
        if (flipped ^ this.isFlipped ^ f.flipped) {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        if (!subShaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (light != null) {
                sublsp.unbind();
            } else {
                subsp.unbind();
            }
            TextureImpl.bindNone();
        }
    }

    public static void lockBevelledShader(SpritesheetBundle ssb, SpritesheetBundle maskSSB, Draw d, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        if (ssb.bumpTex == null || maskSSB.bumpTex == null) {
            light = null;
        }
        if (ssb.getTex(currentPostfix) == null) {
            return;
        }
        if (shaderLoadFailed || useSimpleGraphics) {
            return;
        }
        if (light != null) {
            if (blsp == null) {
                try {
                    blsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/bevelled_masked_litfrag.vert"), (String)AGame.getStaticGameDirectoryPath("data/bevelled_masked_litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            blsp.bind();
            GL13.glActiveTexture((int)33985);
            GL11.glBindTexture((int)3553, (int)ssb.bumpTex.getTextureID());
            blsp.setUniform1i("bump", 1);
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
            blsp.setUniform1i("lightFromLeft", 2);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
            blsp.setUniform1i("lightFromTop", 3);
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
            blsp.setUniform1i("lightFromRight", 4);
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
            blsp.setUniform1i("lightFromBottom", 5);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)ssb.getTex(currentPostfix).getTextureID());
            blsp.setUniform1i("tex", 0);
            GL13.glActiveTexture((int)33990);
            GL11.glBindTexture((int)3553, (int)maskSSB.getTex(currentPostfix).getTextureID());
            blsp.setUniform1i("mask", 6);
            GL13.glActiveTexture((int)33991);
            GL11.glBindTexture((int)3553, (int)maskSSB.bumpTex.getTextureID());
            blsp.setUniform1i("maskBump", 7);
            blsp.setUniform1f("strength", lightStrength);
            blsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
            blsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
            blsp.setUniform4f("ambient", ambient);
            blsp.setUniform1f("ambientSaturation", ambientSaturation);
            blsp.enableVertexAttribute("globalTexCoord");
            blsp.enableVertexAttribute("flipped_concave");
            blsp.enableVertexAttribute("bevel");
            blsp.enableVertexAttribute("t");
            blsp.enableVertexAttribute("m");
            if (!IS_MAC) {
                blsp.enableVertexAttribute("b");
            }
            blsp.enableVertexAttribute("tint");
            blsp.enableVertexAttribute("paint");
            blsp.enableVertexAttribute("maskOffsetAndEnabled");
        } else {
            if (maskedSP == null) {
                try {
                    maskedSP = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/masked.vert"), (String)AGame.getStaticGameDirectoryPath("data/masked.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            maskedSP.bind();
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)ssb.getTex(currentPostfix).getTextureID());
            maskedSP.setUniform1i("tex", 0);
            GL13.glActiveTexture((int)33990);
            GL11.glBindTexture((int)3553, (int)maskSSB.getTex(currentPostfix).getTextureID());
            maskedSP.setUniform1i("mask", 6);
            maskedSP.enableVertexAttribute("maskOffsetAndEnabled");
            maskedSP.enableVertexAttribute("globalTexCoord");
            maskedSP.enableVertexAttribute("paint");
            maskedSP.enableVertexAttribute("tint");
        }
        GL11.glBegin((int)7);
        bevelledLocked = true;
    }

    public static void unlockBevelledShader(boolean light) {
        if (bevelledLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (light) {
                blsp.unbind();
            } else {
                maskedSP.unbind();
            }
            TextureImpl.bindNone();
            bevelledLocked = false;
        }
    }

    public void drawBevelled(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped, Image[] light, float lightStrength, Color ambient, float ambientSaturation, int top, int bottom, int left, int right, boolean concave, int[][] patch9, Clr paint, float paintShiny, boolean mask, int maskX, int maskY, TileMask tileMask, SpritesheetBundle maskSSB) {
        ShaderProgram p;
        if (shaderLocked || subShaderLocked || RotatingShader.shaderLocked || RotatingColoringShader.shaderLocked) {
            AirshipGame.instance.reportError("Appearance.drawBevelled mis-lock Appearance.shaderLocked=" + shaderLocked + " Appearance.subShaderLocked=" + subShaderLocked + " Appearance.bevelledLocked=" + bevelledLocked + " RotatingShader.shaderLocked=" + RotatingShader.shaderLocked + " RotatingColoringShader.shaderLocked=" + RotatingColoringShader.shaderLocked, null, null, false, true);
        }
        this.updateSpritesheet();
        if (this.spritesheetBundle.bumpTex == null) {
            light = null;
        }
        if (maskSSB.bumpTex == null) {
            light = null;
        }
        if (shaderLoadFailed || useSimpleGraphics || this.spritesheetBundle.getTex(currentPostfix) == null) {
            if (tileMask != null && tileMask != TileMask.FULL) {
                this.maskedDrawFallback(d, x, y, w, h, ms, tint, flipped, tileMask);
            } else {
                this.drawFallback(d, x, y, w, h, ms, tint, flipped);
            }
            return;
        }
        if (light != null) {
            if (blsp == null) {
                try {
                    blsp = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/bevelled_masked_litfrag.vert"), (String)AGame.getStaticGameDirectoryPath("data/bevelled_masked_litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!bevelledLocked) {
                blsp.bind();
                GL13.glActiveTexture((int)33985);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.bumpTex.getTextureID());
                blsp.setUniform1i("bump", 1);
                GL13.glActiveTexture((int)33986);
                GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
                blsp.setUniform1i("lightFromLeft", 2);
                GL13.glActiveTexture((int)33987);
                GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
                blsp.setUniform1i("lightFromTop", 3);
                GL13.glActiveTexture((int)33988);
                GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
                blsp.setUniform1i("lightFromRight", 4);
                GL13.glActiveTexture((int)33989);
                GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
                blsp.setUniform1i("lightFromBottom", 5);
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex(currentPostfix).getTextureID());
                blsp.setUniform1i("tex", 0);
                GL13.glActiveTexture((int)33990);
                GL11.glBindTexture((int)3553, (int)maskSSB.getTex(currentPostfix).getTextureID());
                blsp.setUniform1i("mask", 6);
                GL13.glActiveTexture((int)33991);
                GL11.glBindTexture((int)3553, (int)maskSSB.bumpTex.getTextureID());
                blsp.setUniform1i("maskBump", 7);
                blsp.setUniform1f("strength", lightStrength);
                blsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
                blsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
                blsp.setUniform4f("ambient", ambient);
                blsp.setUniform1f("ambientSaturation", ambientSaturation);
                blsp.enableVertexAttribute("globalTexCoord");
                blsp.enableVertexAttribute("bevel");
                blsp.enableVertexAttribute("t");
                blsp.enableVertexAttribute("m");
                if (!IS_MAC) {
                    blsp.enableVertexAttribute("b");
                }
                blsp.enableVertexAttribute("tint");
                blsp.enableVertexAttribute("paint");
                blsp.enableVertexAttribute("flipped_concave");
                blsp.enableVertexAttribute("maskOffsetAndEnabled");
            }
        } else {
            if (maskedSP == null) {
                try {
                    maskedSP = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/masked.vert"), (String)AGame.getStaticGameDirectoryPath("data/masked.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!bevelledLocked) {
                maskedSP.bind();
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)this.spritesheetBundle.getTex(currentPostfix).getTextureID());
                maskedSP.setUniform1i("tex", 0);
                GL13.glActiveTexture((int)33990);
                GL11.glBindTexture((int)3553, (int)maskSSB.getTex(currentPostfix).getTextureID());
                maskedSP.setUniform1i("mask", 6);
                maskedSP.enableVertexAttribute("maskOffsetAndEnabled");
                maskedSP.enableVertexAttribute("globalTexCoord");
                maskedSP.enableVertexAttribute("paint");
                maskedSP.enableVertexAttribute("tint");
            }
        }
        Frame f = this.frames.get(ms / this.interval % this.frames.size());
        x += (double)(f.shiftX * (flipped ? -1 : 1));
        y += (double)f.shiftY;
        if (w == 0.0 && h == 0.0) {
            w = f.srcWidth;
            h = f.srcHeight;
        }
        if (light != null) {
            GL20.glVertexAttrib2f((int)blsp.getAttributeID("flipped_concave"), (float)(flipped ? -1.0f : 1.0f), (float)(flipped ^ concave ? 1.0f : 0.0f));
            GL20.glVertexAttrib4f((int)blsp.getAttributeID("bevel"), (float)top, (float)bottom, (float)left, (float)right);
            GL20.glVertexAttrib3f((int)blsp.getAttributeID("t"), (float)patch9[0][0], (float)patch9[0][1], (float)patch9[0][2]);
            GL20.glVertexAttrib3f((int)blsp.getAttributeID("m"), (float)patch9[1][0], (float)patch9[1][1], (float)patch9[1][2]);
            GL20.glVertexAttrib3f((int)blsp.getAttributeID("b"), (float)patch9[2][0], (float)patch9[2][1], (float)patch9[2][2]);
            if (tint == null) {
                GL20.glVertexAttrib4f((int)blsp.getAttributeID("tint"), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL20.glVertexAttrib4f((int)blsp.getAttributeID("tint"), (float)((float)tint.r / 255.0f), (float)((float)tint.g / 255.0f), (float)((float)tint.b / 255.0f), (float)1.0f);
            }
            if (paint == null) {
                GL20.glVertexAttrib4f((int)blsp.getAttributeID("paint"), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            } else {
                GL20.glVertexAttrib4f((int)blsp.getAttributeID("paint"), (float)((float)paint.r / 255.0f), (float)((float)paint.g / 255.0f), (float)((float)paint.b / 255.0f), (float)((float)paint.a / 255.0f));
            }
            GL20.glVertexAttrib4f((int)blsp.getAttributeID("maskOffsetAndEnabled"), (float)(maskX - f.srcX), (float)(maskY - f.srcY), (float)(mask ? 1.0f : -1.0f), (float)paintShiny);
        } else {
            if (tint == null) {
                GL20.glVertexAttrib4f((int)maskedSP.getAttributeID("tint"), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL20.glVertexAttrib4f((int)maskedSP.getAttributeID("tint"), (float)((float)tint.r / 255.0f), (float)((float)tint.g / 255.0f), (float)((float)tint.b / 255.0f), (float)1.0f);
            }
            GL20.glVertexAttrib4f((int)maskedSP.getAttributeID("maskOffsetAndEnabled"), (float)(maskX - f.srcX), (float)(maskY - f.srcY), (float)(mask ? 1.0f : -1.0f), (float)paintShiny);
            if (paint == null) {
                GL20.glVertexAttrib4f((int)maskedSP.getAttributeID("paint"), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            } else {
                GL20.glVertexAttrib4f((int)maskedSP.getAttributeID("paint"), (float)((float)paint.r / 255.0f), (float)((float)paint.g / 255.0f), (float)((float)paint.b / 255.0f), (float)((float)paint.a / 255.0f));
            }
        }
        if (!bevelledLocked) {
            GL11.glBegin((int)7);
        }
        ShaderProgram shaderProgram = p = light == null ? maskedSP : blsp;
        if (flipped ^ this.isFlipped ^ f.flipped) {
            GL20.glVertexAttrib2f((int)p.getAttributeID("globalTexCoord"), (float)f.srcX, (float)f.srcY);
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL20.glVertexAttrib2f((int)p.getAttributeID("globalTexCoord"), (float)f.srcX, (float)(f.srcY + f.srcHeight));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL20.glVertexAttrib2f((int)p.getAttributeID("globalTexCoord"), (float)(f.srcX + f.srcWidth), (float)(f.srcY + f.srcHeight));
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL20.glVertexAttrib2f((int)p.getAttributeID("globalTexCoord"), (float)(f.srcX + f.srcWidth), (float)f.srcY);
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL20.glVertexAttrib2f((int)p.getAttributeID("globalTexCoord"), (float)f.srcX, (float)f.srcY);
            GL11.glTexCoord2d((double)f.srcX, (double)f.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL20.glVertexAttrib2f((int)p.getAttributeID("globalTexCoord"), (float)f.srcX, (float)(f.srcY + f.srcHeight));
            GL11.glTexCoord2d((double)f.srcX, (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL20.glVertexAttrib2f((int)p.getAttributeID("globalTexCoord"), (float)(f.srcX + f.srcWidth), (float)(f.srcY + f.srcHeight));
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)(f.srcY + f.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL20.glVertexAttrib2f((int)p.getAttributeID("globalTexCoord"), (float)(f.srcX + f.srcWidth), (float)f.srcY);
            GL11.glTexCoord2d((double)(f.srcX + f.srcWidth), (double)f.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        if (!bevelledLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (light != null) {
                blsp.unbind();
            } else {
                maskedSP.unbind();
            }
            TextureImpl.bindNone();
        }
    }

    public Appearance frame(int x, int y) {
        return this.frame(x, y, 1, 1);
    }

    public Appearance frame(int x, int y, int w, int h) {
        if (x + w > 64 || y + h > 64) {
            throw new RuntimeException("Frame at location x=" + x + " y=" + y + " w=" + w + " h=" + h + " is outside the spritesheet! Note that appearance coordinates are on a 16x16 pixel grid and spritesheets are 1024x1024 pixels, a grid of 64x64 tiles.");
        }
        Frame f = new Frame(this.spritesheetBundle.name, x * 16, y * 16, w * 16, h * 16, false, 0, 0);
        this.frames.add(f);
        this.w = StrictMath.max(this.w, w);
        this.h = StrictMath.max(this.h, h);
        return this;
    }

    public Appearance frame(int x, int y, int w, int h, boolean flipped) {
        return this.frame(x, y, w, h, flipped, 0, 0);
    }

    public Appearance frame(int x, int y, int w, int h, boolean flipped, int shiftX, int shiftY) {
        if (x + w > 64 || y + h > 64) {
            throw new RuntimeException("Frame at location x=" + x + " y=" + y + " w=" + w + " h=" + h + " is outside the spritesheet! Note that appearance coordinates are on a 16x16 pixel grid and spritesheets are 1024x1024 pixels, a grid of 64x64 tiles.");
        }
        Frame f = new Frame(this.spritesheetBundle.name, x * 16, y * 16, w * 16, h * 16, flipped, shiftX, shiftY);
        this.frames.add(f);
        this.w = StrictMath.max(this.w, w);
        this.h = StrictMath.max(this.h, h);
        return this;
    }

    public Appearance flip() {
        Appearance a2 = new Appearance(this.spritesheetBundle);
        a2.frames = this.frames;
        a2.isFlipped = !this.isFlipped;
        a2.interval = this.interval;
        a2.w = this.w;
        a2.h = this.h;
        return a2;
    }

    public Appearance interval(int interval) {
        this.interval = interval;
        if (this.interval <= 0) {
            this.interval = 300;
        }
        return this;
    }

    public static Appearance app(SpritesheetBundle spritesheetBundle) {
        return new Appearance(spritesheetBundle);
    }

    public static Appearance app(SpritesheetBundle spritesheetBundle, int x, int y) {
        return new Appearance(spritesheetBundle, x, y);
    }

    public static Appearance app(SpritesheetBundle spritesheetBundle, int x, int y, int w, int h) {
        return new Appearance(spritesheetBundle, x, y, w, h);
    }

    public Appearance(SpritesheetBundle spritesheetBundle) {
        this.spritesheetBundle = spritesheetBundle;
    }

    public Appearance(SpritesheetBundle spritesheetBundle, int x, int y, int w, int h) {
        this.spritesheetBundle = spritesheetBundle;
        this.frame(x, y, w, h);
    }

    public Appearance(SpritesheetBundle spritesheetBundle, int x, int y) {
        this.spritesheetBundle = spritesheetBundle;
        this.frame(x, y);
    }

    public Appearance(JSONObject o) {
        this.spritesheetBundle = SpritesheetBundle.ofName(o.getString("src"));
        if (this.spritesheetBundle == null) {
            throw new RuntimeException("No spritesheet bundle of name \"" + o.getString("src") + "\"");
        }
        if (o.has("x")) {
            this.frame(o.getInt("x"), o.getInt("y"), o.optInt("w", 1), o.optInt("h", 1), o.optBoolean("flipped", false), o.optInt("shiftX", 0), o.optInt("shiftY", 0));
        } else {
            JSONArray framesA = o.getJSONArray("frames");
            for (int i = 0; i < framesA.length(); ++i) {
                JSONObject f = framesA.getJSONObject(i);
                this.frame(f.getInt("x"), f.getInt("y"), f.optInt("w", 1), f.optInt("h", 1), f.optBoolean("flipped", false), f.optInt("shiftX", 0), f.optInt("shiftY", 0));
            }
        }
        this.interval = o.optInt("interval", 300);
        if (this.interval <= 0) {
            this.interval = 300;
        }
    }

    public int width() {
        return this.w;
    }

    public int height() {
        return this.h;
    }

    public Appearance upToX(int x) {
        Appearance s = new Appearance(this.spritesheetBundle);
        for (Img img : this.frames) {
            s.frames.add(new Frame(this.spritesheetBundle.name, img.srcX, img.srcY, x * 16, img.srcHeight, false, 0, 0));
        }
        s.interval = this.interval;
        s.isFlipped = this.isFlipped;
        return s;
    }

    public Appearance fromX(int x) {
        Appearance s = new Appearance(this.spritesheetBundle);
        for (Img img : this.frames) {
            s.frames.add(new Frame(this.spritesheetBundle.name, img.srcX + x * 16, img.srcY, img.srcWidth - x * 16, img.srcHeight, false, 0, 0));
        }
        s.interval = this.interval;
        s.isFlipped = this.isFlipped;
        return s;
    }

    public Appearance leftSide() {
        Appearance s = new Appearance(this.spritesheetBundle);
        for (Img img : this.frames) {
            s.frames.add(new Frame(this.spritesheetBundle.name, img.srcX, img.srcY, img.srcWidth / 2, img.srcHeight, false, 0, 0));
        }
        s.interval = this.interval;
        s.isFlipped = this.isFlipped;
        return s;
    }

    public Appearance rightSide() {
        Appearance s = new Appearance(this.spritesheetBundle);
        for (Img img : this.frames) {
            s.frames.add(new Frame(this.spritesheetBundle.name, img.srcX + img.srcWidth / 2, img.srcY, img.srcWidth / 2, img.srcHeight, false, 0, 0));
        }
        s.interval = this.interval;
        return s;
    }

    public int getInterval() {
        return this.interval;
    }

    static {
        shaderLoadFailed = false;
        useSimpleGraphics = false;
        useLighting = true;
        canUseLighting = true;
        IS_MAC = System.getProperty("os.name").contains("Mac");
        currentPostfix = null;
        switchNum = 0;
    }

    public strictfp static class FromJSON
    implements BonusableValue.FromJSON<Appearance> {
        @Override
        public Appearance construct(JSONObject o, BonusSet b) {
            return new Appearance(o);
        }
    }

    public strictfp static class Frame
    extends Img {
        public final int shiftX;
        public final int shiftY;

        public Frame(String src, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipped, int shiftX, int shiftY) {
            super(src, srcX, srcY, srcWidth, srcHeight, flipped);
            this.shiftX = shiftX;
            this.shiftY = shiftY;
        }

        public Frame flip() {
            return new Frame(this.src, this.srcX, this.srcY, this.srcWidth, this.srcHeight, !this.flipped, -this.shiftX, this.shiftY);
        }
    }
}

