/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AnimationBundle;
import com.zarkonnen.airships.AnimationType;
import com.zarkonnen.airships.CrewFrameAnimation;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.Side;
import com.zarkonnen.catengine.Img;
import java.util.ArrayList;
import java.util.EnumMap;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class AnimationAppearance
extends Loadable {
    public final AnimationBundle bundle;
    public final EnumMap<Side, Img[]> images = new EnumMap(Side.class);
    public final EnumMap<Side, ArrayList<BodyPartEmitter>[]> emitters = new EnumMap(Side.class);
    public final EnumMap<Side, ArrayList<BodyPartEmitter>[]> deadEmitters = new EnumMap(Side.class);
    public final EnumMap<AnimationType, CrewFrameAnimation> frameAnimations;
    public final int frameAnimationBoundingBoxWidth;
    public final int frameAnimationBoundingBoxHeight;

    public AnimationAppearance(JSONObject o) {
        super(o.getString("name"));
        if (o.has("frameAnimations")) {
            this.bundle = null;
            this.frameAnimations = new EnumMap(AnimationType.class);
            JSONObject fas = o.getJSONObject("frameAnimations");
            for (AnimationType at : AnimationType.values()) {
                if (!fas.has(at.name())) continue;
                this.frameAnimations.put(at, new CrewFrameAnimation(fas.getJSONObject(at.name())));
            }
            this.frameAnimationBoundingBoxWidth = o.getInt("frameAnimationBoundingBoxWidth");
            this.frameAnimationBoundingBoxHeight = o.getInt("frameAnimationBoundingBoxHeight");
        } else {
            this.bundle = AnimationBundle.ofName(o.getString("bundle"));
            this.frameAnimations = null;
            this.frameAnimationBoundingBoxWidth = 0;
            this.frameAnimationBoundingBoxHeight = 0;
            String spritesheet = o.getString("spritesheet");
            for (Side side : Side.values()) {
                this.images.put(side, new Img[this.bundle.bodyPlan.partNames.get((Object)side).size()]);
                this.emitters.put(side, new ArrayList[this.bundle.bodyPlan.partNames.get((Object)side).size()]);
                this.deadEmitters.put(side, new ArrayList[this.bundle.bodyPlan.partNames.get((Object)side).size()]);
            }
            JSONArray a = o.getJSONArray("images");
            for (int i = 0; i < a.length(); ++i) {
                JSONObject em;
                int ei;
                JSONArray ems;
                ArrayList<BodyPartEmitter> l;
                Side side;
                JSONObject io = a.getJSONObject(i);
                side = Side.valueOf(io.getString("side"));
                this.images.get((Object)((Object)side))[this.bundle.bodyPlan.getIndex((Side)side, (String)io.getString((String)"part"))] = new Img(spritesheet, io.getInt("x"), io.getInt("y"), io.getInt("w"), io.getInt("h"), io.optBoolean("flipped", false));
                if (io.has("emitters")) {
                    l = new ArrayList<BodyPartEmitter>();
                    this.emitters.get((Object)((Object)side))[this.bundle.bodyPlan.getIndex((Side)side, (String)io.getString((String)"part"))] = l;
                    ems = io.getJSONArray("emitters");
                    for (ei = 0; ei < ems.length(); ++ei) {
                        em = ems.getJSONObject(ei);
                        l.add(new BodyPartEmitter(ParticleType.ofName(em.getString("type")), em.getDouble("freq"), em.getDouble("x"), em.getDouble("y"), em.optDouble("scale", 1.0)));
                    }
                }
                if (!io.has("deadEmitters")) continue;
                l = new ArrayList();
                this.deadEmitters.get((Object)((Object)side))[this.bundle.bodyPlan.getIndex((Side)side, (String)io.getString((String)"part"))] = l;
                ems = io.getJSONArray("deadEmitters");
                for (ei = 0; ei < ems.length(); ++ei) {
                    em = ems.getJSONObject(ei);
                    l.add(new BodyPartEmitter(ParticleType.ofName(em.getString("type")), em.getDouble("freq"), em.getDouble("x"), em.getDouble("y"), em.optDouble("scale", 1.0)));
                }
            }
        }
    }

    public static AnimationAppearance ofName(String name) {
        return Loadable.ofName(AnimationAppearance.class, name);
    }

    public strictfp static class BodyPartEmitter {
        public final ParticleType type;
        public final double freq;
        public final double x;
        public final double y;
        public final double scale;

        public BodyPartEmitter(ParticleType type, double freq, double x, double y, double scale) {
            this.type = type;
            this.freq = freq;
            this.x = x;
            this.y = y;
            this.scale = scale;
        }
    }
}

