/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.EditorOverlayType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import java.util.HashMap;

public strictfp class AmmoDistOverlay
implements EditorOverlayType {
    public Airship ship;
    private final HashMap<Module, Integer> values = new HashMap();
    public int nModules = 0;

    @Override
    public String name() {
        return Lang._t("Ammo_distance", new Object[0]);
    }

    @Override
    public String explanation() {
        return Lang._t("Ammo_distance_explanation", new Object[0]);
    }

    @Override
    public void update(Airship ship, boolean forced) {
        if (forced || ship != this.ship || ship != null && this.ship != null && ship.modules.size() != this.nModules) {
            this.nModules = ship.modules.size();
            this.ship = ship;
            this.values.clear();
            if (this.ship == null) {
                return;
            }
            for (Module tm : ship.modules) {
                if (tm.type.getAmmo(ship.currentBonuses) > 0) {
                    this.values.put(tm, -2);
                    continue;
                }
                if (tm.type.getReload(ship.currentBonuses) == 0) continue;
                int leastDist = Integer.MAX_VALUE;
                for (int dy = 0; dy < tm.type.getH(); ++dy) {
                    for (int dx = 0; dx < tm.type.getW(); ++dx) {
                        Tile t2 = ship.tileAt(tm.x + dx, tm.y + dy);
                        for (Module m : ship.modules) {
                            ArrayList<Tile> path;
                            if (m.type.getAmmo(ship.currentBonuses) <= 0 || (path = ship.getPath(t2, m)) == null) continue;
                            int dist = 0;
                            for (Tile pt : path) {
                                dist += pt.module.type.getMoveDelay(ship.currentBonuses);
                            }
                            leastDist = StrictMath.min(dist, leastDist);
                        }
                    }
                }
                this.values.put(tm, leastDist == Integer.MAX_VALUE ? -1 : leastDist);
            }
        }
    }

    private int value(Tile t) {
        if (this.ship == null) {
            return Integer.MAX_VALUE;
        }
        return this.values.containsKey(t.module) ? this.values.get(t.module) : -1;
    }

    @Override
    public Clr overlayColor(Tile t) {
        int v = this.value(t);
        return v == Integer.MAX_VALUE ? new Clr(255, 0, 0, 200) : (v == -1 ? new Clr(0, 0, 0, 200) : (v == -2 ? new Clr(50, 255, 50, 200) : new Clr(StrictMath.max(0, StrictMath.min(v / 50 - 100, 255)), 255 - StrictMath.min(255, v / 30), 0, 150)));
    }

    @Override
    public String tooltip(Tile t) {
        if (t.module.x == t.x && t.module.y == t.y) {
            int v = this.value(t);
            return v == Integer.MAX_VALUE || v < 0 ? null : (v < 1000 ? "<1" : "" + v / 1000);
        }
        return null;
    }

    @Override
    public void draw(MyDraw d, Tile t, Airship ship, int tx, int ty, double zoom, int pass) {
    }
}

