/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;

public strictfp class AIDebugLayer
implements UniScreen.VisualLayer {
    boolean debug = AGame.isDebug();
    int shipIndex = 10000;
    double multiplier = 128.0;
    boolean active = false;

    private Airship ship(UniScreen us) {
        if (us.combat.sides.get((int)1).ships.isEmpty()) {
            return null;
        }
        ArrayList<Airship> ships = new ArrayList<Airship>();
        ships.addAll(us.combat.sides.get((int)0).ships);
        ships.addAll(us.combat.sides.get((int)1).ships);
        Airship ship = ships.isEmpty() ? null : (Airship)ships.get(this.shipIndex % ships.size());
        return ship == null || ship.ai == null ? null : ship;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        Airship ship;
        if (!this.debug || us.combat == null) {
            return;
        }
        if (in.keyPressed("0")) {
            boolean bl = this.active = !this.active;
        }
        if (!this.active) {
            return;
        }
        if (in.keyPressed("1")) {
            --this.shipIndex;
            in.play("ready", 1.0, 1.0, 0.0, 0.0);
        }
        if (in.keyPressed("2")) {
            ++this.shipIndex;
            in.play("ready", 1.0, 1.0, 0.0, 0.0);
        }
        if (in.keyPressed("3") && (ship = this.ship(us)) != null) {
            ship.ai.calculate();
            in.play("ready", 1.0, 1.0, 0.0, 0.0);
        }
        if (in.keyPressed("4")) {
            TacticalAI.fixed = !TacticalAI.fixed;
            ship = this.ship(us);
            if (ship != null) {
                ship.ai.calculate();
                in.play("ready", 1.0, 1.0, 0.0, 0.0);
            }
        }
        if (in.keyPressed("5")) {
            this.multiplier /= 2.0;
            in.play("ready", 1.0, 1.0, 0.0, 0.0);
        }
        if (in.keyPressed("6")) {
            this.multiplier *= 2.0;
            in.play("ready", 1.0, 1.0, 0.0, 0.0);
        }
        if (in.keyPressed("7")) {
            TacticalAI.lfs = !TacticalAI.lfs;
            ship = this.ship(us);
            if (ship != null) {
                ship.ai.calculate();
                in.play("ready", 1.0, 1.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (!this.debug || us.combat == null) {
            return;
        }
        if (!this.active) {
            return;
        }
        Airship ship = this.ship(us);
        if (ship == null) {
            return;
        }
        for (int gy = 0; gy < ship.ai.grid.length; ++gy) {
            for (int gx = 0; gx < ship.ai.grid[gy].length; ++gx) {
                for (int fl = 0; fl < 2; ++fl) {
                    double v = ship.ai.grid[gy][gx][fl];
                    if (v < 0.0) continue;
                    Clr c = v < 0.0 ? Clr.RED : new Clr((int)(v * this.multiplier), (int)(v * this.multiplier), (int)(v * this.multiplier));
                    int x = -3200 + gx * 20 + fl * 20 / 4;
                    int y = (int)ship.ai.getWorldYFromGridY(gx, gy, fl == 1);
                    d.rect(c, x, y, 5.0, 7.0);
                }
                if (!ship.ai.ramZones[gy][gx]) continue;
                int x = -3200 + gx * 20;
                int y = (int)ship.ai.getWorldYFromGridY(gx, gy, false);
                d.rect(Clr.CYAN, x, y, 10.0, 15.0);
            }
        }
        try {
            Pt p;
            TacticalAI.MoveTo mt = ship.ai.choose();
            if (mt != null) {
                d.rect(Clr.GREEN, -3200 + mt.gridX * 20 - 20, (int)ship.ai.getWorldYFromGridY(mt.gridX, mt.gridY, mt.flipped) - 20, 40.0, 40.0);
            }
            if ((p = ship.moveTo) != null) {
                d.rect(Clr.ORANGE, p.x - 15.0, p.y - 15.0, 30.0, 30.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

