/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.io.InputStream;
import java.net.URL;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioImpl2;
import org.newdawn.slick.openal.SoundStore2;
import org.newdawn.slick.util.Log;

public class Sound2 {
    private Audio sound;

    public Sound2(Sound2 original) {
        this.sound = new AudioImpl2(SoundStore2.get(), ((AudioImpl2)original.sound).getBufferID());
    }

    public Sound2(InputStream in, String ref) throws SlickException {
        block6: {
            SoundStore2.get().init();
            try {
                if (ref.toLowerCase().endsWith(".ogg")) {
                    this.sound = SoundStore2.get().getOgg(in);
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".wav")) {
                    this.sound = SoundStore2.get().getWAV(in);
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".aif")) {
                    this.sound = SoundStore2.get().getAIF(in);
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".xm") || ref.toLowerCase().endsWith(".mod")) {
                    this.sound = SoundStore2.get().getMOD(in);
                    break block6;
                }
                throw new SlickException("Only .xm, .mod, .aif, .wav and .ogg are currently supported.");
            }
            catch (Exception e) {
                Log.error((Throwable)e);
                throw new SlickException("Failed to load sound: " + ref);
            }
        }
    }

    public Sound2(URL url) throws SlickException {
        block6: {
            SoundStore2.get().init();
            String ref = url.getFile();
            try {
                if (ref.toLowerCase().endsWith(".ogg")) {
                    this.sound = SoundStore2.get().getOgg(url.openStream());
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".wav")) {
                    this.sound = SoundStore2.get().getWAV(url.openStream());
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".aif")) {
                    this.sound = SoundStore2.get().getAIF(url.openStream());
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".xm") || ref.toLowerCase().endsWith(".mod")) {
                    this.sound = SoundStore2.get().getMOD(url.openStream());
                    break block6;
                }
                throw new SlickException("Only .xm, .mod, .aif, .wav and .ogg are currently supported.");
            }
            catch (Exception e) {
                Log.error((Throwable)e);
                throw new SlickException("Failed to load sound: " + ref);
            }
        }
    }

    public Sound2(String ref) throws SlickException {
        block6: {
            SoundStore2.get().init();
            try {
                if (ref.toLowerCase().endsWith(".ogg")) {
                    this.sound = SoundStore2.get().getOgg(ref);
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".wav")) {
                    this.sound = SoundStore2.get().getWAV(ref);
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".aif")) {
                    this.sound = SoundStore2.get().getAIF(ref);
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".xm") || ref.toLowerCase().endsWith(".mod")) {
                    this.sound = SoundStore2.get().getMOD(ref);
                    break block6;
                }
                throw new SlickException("Only .xm, .mod, .aif, .wav and .ogg are currently supported.");
            }
            catch (Exception e) {
                Log.error((Throwable)e);
                throw new SlickException("Failed to load sound: " + ref);
            }
        }
    }

    public void play() {
        this.play(1.0f, 1.0f);
    }

    public void play(float pitch, float volume) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore2.get().getSoundVolume(), false);
    }

    public void playAt(float x, float y, float z) {
        this.playAt(1.0f, 1.0f, x, y, z);
    }

    public void playAt(float pitch, float volume, float x, float y, float z) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore2.get().getSoundVolume(), false, x, y, z);
    }

    public void loopAt(float pitch, float volume, float x, float y, float z) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore2.get().getSoundVolume(), true, x, y, z);
    }

    public void loop() {
        this.loop(1.0f, 1.0f);
    }

    public void loop(float pitch, float volume) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore2.get().getSoundVolume(), true);
    }

    public boolean playing() {
        return this.sound.isPlaying();
    }

    public void stop() {
        this.sound.stop();
    }

    public void setVolume(float volume) {
        ((AudioImpl2)this.sound).setVolume(volume);
    }

    public void setPitch(float pitch) {
        ((AudioImpl2)this.sound).setPitch(pitch);
    }

    public void setLocation(float x, float y, float z) {
        ((AudioImpl2)this.sound).setLocation(x, y, z);
    }
}

