/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.catengine;

import com.zarkonnen.catengine.Condition;
import com.zarkonnen.catengine.Engine;
import com.zarkonnen.catengine.ExceptionHandler;
import com.zarkonnen.catengine.Frame;
import com.zarkonnen.catengine.Game;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.Loop;
import com.zarkonnen.catengine.MusicCallback;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.KeyListener;
import org.newdawn.slick.MouseListener;
import org.newdawn.slick.Music2;
import org.newdawn.slick.MusicListener2;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound2;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.opengl.renderer.SGL;

public class SlickEngine
extends BasicGame
implements Engine,
KeyListener,
ExceptionHandler,
MouseListener {
    protected static SGL GL = Renderer.get();
    boolean doExit = false;
    int fps;
    Music2 currentMusic;
    String loadBase;
    String soundLoadBase;
    MyAppGameContainer agc;
    Game g;
    boolean fullscreen;
    boolean fullscreenWindow;
    boolean cursorVisible = true;
    String lastKeyPressed;
    final HashMap<String, SoftReference<Image>> images = new HashMap();
    final HashMap<String, Music2> musics = new HashMap();
    final HashMap<String, Sound2> sounds = new HashMap();
    final Object soundLoadMutex = new Object();
    ExceptionHandler eh = this;
    int mouseWheelMovement = 0;
    char lastChar = '\u0000';
    final ArrayList<File> additionalLoadBases = new ArrayList();
    final ArrayList<File> additionalSoundLoadBases = new ArrayList();
    float soundZ = 0.5f;
    boolean isMac = System.getProperty("os.name").contains("Mac");
    StringBuilder typedText = new StringBuilder();
    byte[] emergencyMemoryStash = null;
    Pt lastClick;
    int clickButton;
    public ReportHandler reportHandler = new ReportHandler(){

        @Override
        public void report(String s, Throwable t) {
            System.err.println(s);
            t.printStackTrace();
        }
    };

    public SlickEngine(String title, String loadBase, String soundLoadBase, Integer fps) {
        super(title);
        this.loadBase = loadBase;
        this.soundLoadBase = soundLoadBase;
        this.fps = fps;
    }

    public void mouseWheelMoved(int i) {
        this.mouseWheelMovement += i;
    }

    @Override
    public void handle(Exception e, boolean fatal) {
        e.printStackTrace();
    }

    @Override
    public void setExceptionHandler(ExceptionHandler eh) {
        this.eh = eh;
    }

    public void init(GameContainer gc) throws SlickException {
        gc.setTargetFrameRate(this.fps);
        gc.setVSync(true);
        gc.setShowFPS(false);
    }

    public void update(GameContainer gc, int delta) throws SlickException {
        if (this.emergencyMemoryStash == null) {
            this.emergencyMemoryStash = new byte[0x800000];
        }
        Music2.poll(delta);
        this.g.input(new MyInput(gc, delta));
        gc.getInput().clearKeyPressedRecord();
        gc.getInput().setMouseClickTolerance(10);
        this.mouseWheelMovement = 0;
        this.lastClick = null;
        this.clickButton = 0;
        this.typedText.delete(0, this.typedText.length());
    }

    public void render(GameContainer gc, Graphics grphcs) throws SlickException {
        this.g.render(new MyFrame(gc, grphcs));
    }

    @Override
    public void setup(Game g) {
        this.g = g;
        try {
            this.agc = new MyAppGameContainer((org.newdawn.slick.Game)this);
            this.agc.setDisplayMode(800, 600, false);
        }
        catch (Exception e) {
            this.eh.handle(e, true);
        }
    }

    public void setRunInBackground(boolean runInBackground) {
        this.agc.setUpdateOnlyWhenVisible(runInBackground);
        this.agc.setAlwaysRender(runInBackground);
    }

    @Override
    public void runUntil(Condition u) {
        try {
            this.agc.runUntil(u);
        }
        catch (SlickException e) {
            this.eh.handle((Exception)((Object)e), true);
            this.agc.destroy();
            System.exit(1);
        }
    }

    @Override
    public void destroy() {
        this.agc.destroy();
    }

    private void getImage(Img img) {
        Image image = null;
        if (this.images.containsKey(img.key)) {
            image = this.images.get(img.key).get();
        }
        if (image == null && img.flipped && this.images.containsKey(img.src) && (image = this.images.get(img.src).get()) != null) {
            image = image.getFlippedCopy(true, false);
            this.images.put(img.key, new SoftReference<Image>(image));
        }
        if (image == null) {
            image = this.loadImage(img.src);
            this.images.put(img.src, new SoftReference<Image>(image));
            if (img.flipped) {
                image = image == null ? null : image.getFlippedCopy(true, false);
                this.images.put(img.key, new SoftReference<Image>(image));
            }
        }
        if (image == null) {
            return;
        }
        if (img.srcWidth != 0 && img.srcHeight != 0) {
            image = image.getSubImage(img.flipped ? image.getWidth() - img.srcX - img.srcWidth : img.srcX, img.srcY, img.srcWidth, img.srcHeight);
        }
        image.setCenterOfRotation((float)image.getWidth() / 2.0f, (float)image.getHeight() / 2.0f);
        img.machineImgCache = image;
        img.machineWCache = image.getWidth();
        img.machineHCache = image.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadImage(String name) {
        Image image;
        if (!name.contains(".")) {
            name = name + ".png";
        }
        InputStream is = null;
        for (File alb : this.additionalLoadBases) {
            File f = new File(alb, name);
            if (!f.exists()) continue;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                Image image2 = new Image((InputStream)fis, f.getAbsolutePath(), false);
                return image2;
            }
            catch (OutOfMemoryError oom) {
                this.emergencyMemoryStash = null;
                this.reportHandler.report("OOM while loading " + name + " from " + f.getName(), oom);
            }
            catch (Exception exception) {}
            continue;
            finally {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            Image i$;
            is = SlickEngine.class.getResourceAsStream(this.loadBase + name);
            if (is != null) {
                i$ = new Image(is, name, false);
                return i$;
            }
            i$ = null;
            return i$;
        }
        catch (OutOfMemoryError oom) {
            this.emergencyMemoryStash = null;
            this.reportHandler.report("OOM while internally loading " + name + " from " + this.loadBase + name, oom);
            image = null;
            return image;
        }
        catch (Exception e) {
            this.eh.handle(e, false);
            image = null;
            return image;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public void keyPressed(int i, char c) {
        this.lastKeyPressed = org.newdawn.slick.Input.getKeyName((int)i);
        this.lastChar = c;
        if (c != '\u0000') {
            this.typedText.append(c);
        }
    }

    public void keyReleased(int i, char c) {
        char releaseChar;
        String k = org.newdawn.slick.Input.getKeyName((int)i);
        if (k.equals(this.lastKeyPressed)) {
            this.lastKeyPressed = null;
        }
        if ((releaseChar = Keyboard.getEventCharacter()) != '\u0000' && releaseChar != this.lastChar) {
            this.typedText.append(releaseChar);
        }
        if (c == this.lastChar) {
            this.lastChar = '\u0000';
        }
    }

    public void mouseClicked(int button, int x, int y, int clickCount) {
        super.mouseClicked(button, x, y, clickCount);
        this.lastClick = new Pt(x, y);
        this.clickButton = button + 1;
    }

    private class MyFrame
    implements Frame {
        boolean colorNotWhite;
        final int gcW;
        final int gcH;
        final GameContainer gc;
        final Graphics g;
        final ScreenMode sm;

        private MyFrame(GameContainer gc, Graphics grphcs) {
            this.gc = gc;
            this.g = grphcs;
            this.gcW = gc.getWidth();
            this.gcH = gc.getHeight();
            this.sm = new ScreenMode(gc.getWidth(), gc.getHeight(), SlickEngine.this.fullscreen, SlickEngine.this.fullscreenWindow);
        }

        @Override
        public Object nativeRenderer() {
            return this.g;
        }

        @Override
        public int fps() {
            return this.gc.getFPS();
        }

        @Override
        public ScreenMode mode() {
            return this.sm;
        }

        @Override
        public void rect(Clr tint, double x, double y, double width, double height, double angle) {
            if (tint.machineColorCache == null) {
                tint.machineColorCache = new Color(tint.r, tint.g, tint.b, tint.a);
            }
            Color c = (Color)tint.machineColorCache;
            Graphics.setCurrent((Graphics)this.g);
            TextureImpl.bindNone();
            c.bind();
            float x1 = (float)x;
            float y1 = (float)y;
            float w = (float)width;
            float h = (float)height;
            if (angle == 0.0) {
                GL.glBegin(7);
                GL.glVertex2f(x1, y1);
                GL.glVertex2f(x1 + w, y1);
                GL.glVertex2f(x1 + w, y1 + h);
                GL.glVertex2f(x1, y1 + h);
                GL.glEnd();
            } else {
                this.g.rotate((float)(x + width / 2.0), (float)(y + height / 2.0), (float)(angle * 180.0 / Math.PI));
                GL.glBegin(7);
                GL.glVertex2f(x1, y1);
                GL.glVertex2f(x1 + w, y1);
                GL.glVertex2f(x1 + w, y1 + h);
                GL.glVertex2f(x1, y1 + h);
                GL.glEnd();
                this.g.rotate((float)(x + width / 2.0), (float)(y + height / 2.0), -((float)(angle * 180.0 / Math.PI)));
            }
        }

        @Override
        public void blit(Img img, Clr tint, double alpha, double x, double y, double width, double height, double angle) {
            Image image;
            if (img == null) {
                return;
            }
            if (img.machineImgCache == null) {
                SlickEngine.this.getImage(img);
            }
            if ((image = (Image)img.machineImgCache) == null) {
                return;
            }
            width = width == 0.0 ? (double)img.machineWCache : width;
            height = height == 0.0 ? (double)img.machineHCache : height;
            image.setRotation((float)(angle * 180.0 / Math.PI));
            if (tint == null) {
                image.setAlpha((float)alpha);
                image.draw((float)x, (float)y, (float)width, (float)height);
            } else {
                if (tint.machineColorCache == null) {
                    tint.machineColorCache = new Color(tint.r, tint.g, tint.b);
                }
                Color c = (Color)tint.machineColorCache;
                if (tint.a == 255) {
                    image.setAlpha((float)alpha);
                    image.draw((float)x, (float)y, (float)width, (float)height, c);
                } else if (alpha == 1.0) {
                    image.setAlpha(1.0f);
                    image.draw((float)x, (float)y, (float)width, (float)height);
                    image.setAlpha((float)tint.a / 255.0f);
                    image.draw((float)x, (float)y, (float)width, (float)height, c);
                } else {
                    image.setAlpha((float)(alpha * (double)(255 - tint.a) / 255.0));
                    image.draw((float)x, (float)y, (float)width, (float)height);
                    image.setAlpha((float)(alpha * (double)tint.a / 255.0));
                    image.draw((float)x, (float)y, (float)width, (float)height, c);
                }
            }
        }

        @Override
        public void shift(double dx, double dy) {
            this.g.translate((float)dx, (float)dy);
        }

        @Override
        public void scale(double xScale, double yScale) {
            this.g.scale((float)xScale, (float)yScale);
        }

        @Override
        public void rotate(double angle) {
            this.g.rotate(0.0f, 0.0f, (float)angle);
        }

        @Override
        public void resetTransforms() {
            this.g.resetTransform();
        }

        @Override
        public double getWidth(Img img) {
            if (img == null) {
                return 0.0;
            }
            if (img.srcWidth != 0) {
                return img.srcWidth;
            }
            if (img.machineImgCache == null) {
                SlickEngine.this.getImage(img);
            }
            return img.machineWCache;
        }

        @Override
        public double getHeight(Img img) {
            if (img == null) {
                return 0.0;
            }
            if (img.srcHeight != 0) {
                return img.srcHeight;
            }
            if (img.machineImgCache == null) {
                SlickEngine.this.getImage(img);
            }
            return img.machineHCache;
        }

        @Override
        public Pt cursor() {
            return new Pt(this.gc.getInput().getMouseX(), this.gc.getInput().getMouseY());
        }
    }

    public class MyInput
    implements Input {
        GameContainer gc;
        int delta;
        Pt cursor;

        public MyInput(GameContainer gc, int delta) {
            this.gc = gc;
            this.delta = delta;
            this.cursor = new Pt(gc.getInput().getMouseX(), gc.getInput().getMouseY());
        }

        public void addLoadBase(File f) {
            SlickEngine.this.additionalLoadBases.add(0, f);
            SlickEngine.this.images.clear();
        }

        public void clearLoadBases() {
            SlickEngine.this.additionalLoadBases.clear();
            SlickEngine.this.images.clear();
        }

        public void addSoundLoadBase(File f) {
            SlickEngine.this.additionalSoundLoadBases.add(0, f);
            SlickEngine.this.sounds.clear();
        }

        public void clearSoundLoadBases() {
            SlickEngine.this.additionalSoundLoadBases.clear();
            SlickEngine.this.sounds.clear();
        }

        @Override
        public boolean keyDown(String key) {
            try {
                return this.gc.getInput().isKeyDown(org.newdawn.slick.Input.class.getField("KEY_" + key).getInt(null));
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public boolean keyPressed(String key) {
            try {
                return this.gc.getInput().isKeyPressed(org.newdawn.slick.Input.class.getField("KEY_" + key).getInt(null));
            }
            catch (Exception e) {
                return false;
            }
        }

        public char getTypedChar() {
            return 'x';
        }

        @Override
        public Pt cursor() {
            return this.cursor;
        }

        @Override
        public Pt mouseDown() {
            for (int i = 3; i >= 0; --i) {
                if (!this.gc.getInput().isMouseButtonDown(i)) continue;
                return this.cursor();
            }
            return null;
        }

        @Override
        public int mouseDownButton() {
            for (int i = 3; i >= 0; --i) {
                if (!this.gc.getInput().isMouseButtonDown(i)) continue;
                return i + 1;
            }
            return 0;
        }

        @Override
        public Pt clicked() {
            if (SlickEngine.this.isMac) {
                return SlickEngine.this.lastClick != null && this.cursor != null ? this.cursor : null;
            }
            return SlickEngine.this.lastClick;
        }

        @Override
        public int clickButton() {
            return SlickEngine.this.clickButton;
        }

        @Override
        public ScreenMode mode() {
            return new ScreenMode(this.gc.getWidth(), this.gc.getHeight(), SlickEngine.this.fullscreen, SlickEngine.this.fullscreenWindow);
        }

        @Override
        public int msDelta() {
            return this.delta;
        }

        @Override
        public Input setMode(ScreenMode mode) {
            try {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", mode.fullscreenWindow ? "true" : "false");
                this.gc.setMouseGrabbed(false);
                SlickEngine.this.agc.setDisplayMode(mode.width, mode.height, mode.fullscreen);
                SlickEngine.this.fullscreen = mode.fullscreen;
                SlickEngine.this.fullscreenWindow = mode.fullscreenWindow;
                this.setCursorVisible(SlickEngine.this.cursorVisible);
                System.setProperty("org.lwjgl.opengl.Window.undecorated", mode.fullscreenWindow ? "true" : "false");
            }
            catch (Exception e) {
                SlickEngine.this.eh.handle(e, false);
            }
            return this;
        }

        @Override
        public ArrayList<ScreenMode> modes() {
            ArrayList<ScreenMode> sm = new ArrayList<ScreenMode>();
            try {
                for (DisplayMode dm : Display.getAvailableDisplayModes()) {
                    sm.add(new ScreenMode(dm.getWidth(), dm.getHeight(), dm.isFullscreenCapable()));
                }
            }
            catch (Exception e) {
                SlickEngine.this.eh.handle(e, false);
                sm.add(new ScreenMode(800, 600, false));
            }
            return sm;
        }

        @Override
        public void quit() {
            this.gc.exit();
        }

        @Override
        public boolean isCursorVisible() {
            return SlickEngine.this.cursorVisible;
        }

        @Override
        public Input setCursorVisible(boolean visible) {
            SlickEngine.this.cursorVisible = visible;
            this.gc.setMouseGrabbed(!visible);
            return this;
        }

        @Override
        public void preload(List<Img> l) {
            for (Img img : l) {
                SlickEngine.this.getImage(img);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preloadSounds(List<String> l) {
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                for (String snd : l) {
                    this.getSound(snd);
                }
            }
        }

        public void setSoundZ(float sz) {
            SlickEngine.this.soundZ = sz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void play(String sound, double pitch, double volume, double x, double y) {
            if (volume < 0.01) {
                return;
            }
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                Sound2 s = this.getSound(sound);
                if (s != null) {
                    s.playAt((float)pitch, (float)volume, (float)x, (float)y, SlickEngine.this.soundZ);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Loop loop(String sound, double pitch, double volume, double x, double y) {
            Sound2 s;
            if (volume < 0.01) {
                return null;
            }
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                s = this.getSound(sound);
            }
            if (s != null) {
                try {
                    s = new Sound2(s);
                }
                catch (Exception e) {
                    return null;
                }
                s.loopAt((float)pitch, (float)volume, (float)x, (float)y, SlickEngine.this.soundZ);
                return new MyLoop(s);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Sound2 getSound(String sound) {
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                if (!sound.contains(".")) {
                    sound = sound + ".ogg";
                }
                Sound2 snd = null;
                try {
                    snd = SlickEngine.this.sounds.get(sound);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (snd != null) {
                    return snd;
                }
                int i = 0;
                if (i < 5) {
                    try {
                        snd = new Sound2(SlickEngine.class.getResource(SlickEngine.this.soundLoadBase + sound));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (snd == null) {
                        for (File slb : SlickEngine.this.additionalSoundLoadBases) {
                            File f = new File(slb, sound);
                            if (!f.exists()) continue;
                            FileInputStream fis = null;
                            try {
                                fis = new FileInputStream(f);
                                snd = new Sound2(fis, sound);
                            }
                            catch (Throwable throwable) {
                            }
                            finally {
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (snd == null) continue;
                            break;
                        }
                    }
                    SlickEngine.this.sounds.put(sound, snd);
                    return snd;
                }
                return null;
            }
        }

        @Override
        public void preloadMusic(String music) {
            this.getMusic(music);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private Music2 getMusic(String music) {
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                if (!music.contains(".")) {
                    music = music + ".ogg";
                }
                if (SlickEngine.this.musics.containsKey(music)) {
                    return SlickEngine.this.musics.get(music);
                }
                try {
                    InputStream is = SlickEngine.class.getResourceAsStream(SlickEngine.this.soundLoadBase + music);
                    if (is != null) {
                        Music2 m = new Music2(is, music);
                        SlickEngine.this.musics.put(music, m);
                        return m;
                    }
                    for (File slb : SlickEngine.this.additionalSoundLoadBases) {
                        Music2 music2;
                        File f = new File(slb, music);
                        if (!f.exists()) continue;
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(f);
                            Music2 m = new Music2(fis, music);
                            SlickEngine.this.musics.put(music, m);
                            music2 = m;
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                        return music2;
                        continue;
                        finally {
                            try {
                                fis.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    SlickEngine.this.musics.put(music, null);
                    return null;
                }
                catch (OutOfMemoryError oom) {
                    SlickEngine.this.emergencyMemoryStash = null;
                    Runtime.getRuntime().gc();
                    SlickEngine.this.musics.put(music, null);
                    return null;
                }
                catch (Exception e) {
                    SlickEngine.this.musics.put(music, null);
                    return null;
                }
            }
        }

        @Override
        public void playMusic(final String music, final double volume, final MusicCallback startCallback, final MusicCallback doneCallback) {
            new Thread("MusicStarter"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = SlickEngine.this.soundLoadMutex;
                        synchronized (object) {
                            MyInput.this.stopMusic();
                            SlickEngine.this.currentMusic = MyInput.this.getMusic(music);
                            if (SlickEngine.this.currentMusic == null) {
                                doneCallback.run(music, volume);
                                return;
                            }
                            SlickEngine.this.currentMusic.play(1.0f, (float)volume);
                            if (startCallback != null) {
                                startCallback.run(music, volume);
                            }
                            SlickEngine.this.currentMusic.addListener(new MusicListener2(){

                                @Override
                                public void musicEnded(Music2 m) {
                                    if (m == SlickEngine.this.currentMusic && doneCallback != null) {
                                        doneCallback.run(music, volume);
                                    }
                                    SlickEngine.this.currentMusic = null;
                                }

                                @Override
                                public void musicSwapped(Music2 oldM, Music2 newM) {
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopMusic() {
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                if (SlickEngine.this.currentMusic != null && SlickEngine.this.currentMusic.playing()) {
                    SlickEngine.this.currentMusic.stop();
                    SlickEngine.this.currentMusic = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fadeOutMusic(int ms) {
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                if (SlickEngine.this.currentMusic != null && SlickEngine.this.currentMusic.playing()) {
                    SlickEngine.this.currentMusic.fade(ms, 0.0f, true);
                }
            }
        }

        @Override
        public String lastKeyPressed() {
            return SlickEngine.this.lastKeyPressed;
        }

        @Override
        public int scrollAmount() {
            return SlickEngine.this.mouseWheelMovement;
        }

        @Override
        public char lastInput() {
            return SlickEngine.this.lastChar;
        }

        public String typedText() {
            return SlickEngine.this.typedText.toString();
        }
    }

    public class MyLoop
    implements Loop {
        private final Sound2 s;

        public MyLoop(Sound2 s) {
            this.s = s;
        }

        @Override
        public void stop() {
            this.s.stop();
        }

        @Override
        public void setLocation(float x, float y) {
            this.s.setLocation(x, y, SlickEngine.this.soundZ);
        }

        @Override
        public void setPitch(float pitch) {
            this.s.setPitch(pitch);
        }

        @Override
        public void setVolume(float volume) {
            this.s.setVolume(volume);
        }
    }

    class MyAppGameContainer
    extends AppGameContainer {
        public MyAppGameContainer(org.newdawn.slick.Game game) throws SlickException {
            super(game, 800, 600, false);
        }

        public void runUntil(Condition c) throws SlickException {
            this.start();
        }
    }

    public static interface ReportHandler {
        public void report(String var1, Throwable var2);
    }
}

