/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.catengine.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    private Utils() {
    }

    public static <T> List<T> l(T ... ts) {
        return Utils.immute(Arrays.asList(ts));
    }

    public static <T> List<T> typedL(Class<T> c, Object ... ts) {
        return Utils.l(ts);
    }

    public static <T> List<T> immute(Collection<T> l) {
        return Collections.unmodifiableList(new ArrayList<T>(l));
    }

    public static <A, B> Pair<A, B> p(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    public static <A, B> Map<A, B> m(Pair<A, B> ... ps) {
        HashMap m = new HashMap(ps.length * 2);
        for (Pair<A, B> p : ps) {
            m.put(p.a, p.b);
        }
        return Collections.unmodifiableMap(m);
    }

    public static <T> List<T> join(List<T> ... ls) {
        int size = 0;
        for (List<T> l : ls) {
            size += l.size();
        }
        ArrayList<T> joint = new ArrayList<T>(size);
        for (List<T> l : ls) {
            joint.addAll(l);
        }
        return Collections.unmodifiableList(joint);
    }

    public static final class Pair<A, B>
    implements Serializable {
        public final A a;
        public final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair p2 = (Pair)o;
            return (this.a == null ? p2.a == null : this.a.equals(p2.a)) && (this.b == null ? p2.b == null : this.b.equals(p2.b));
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + (this.a != null ? this.a.hashCode() : 0);
            hash = 83 * hash + (this.b != null ? this.b.hashCode() : 0);
            return hash;
        }
    }
}

