/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.catengine.util;

public final class ScreenMode {
    public final int width;
    public final int height;
    public final boolean fullscreen;
    public final boolean fullscreenWindow;

    public ScreenMode(int width, int height, boolean fullscreen) {
        this.width = width;
        this.height = height;
        this.fullscreen = fullscreen;
        this.fullscreenWindow = false;
    }

    public ScreenMode(int width, int height, boolean fullscreen, boolean fullscreenWindow) {
        this.width = width;
        this.height = height;
        this.fullscreen = fullscreen;
        this.fullscreenWindow = fullscreenWindow;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + this.width;
        hash = 13 * hash + this.height;
        hash = 13 * hash + (this.fullscreen ? 1 : 0);
        hash = 13 * hash + (this.fullscreenWindow ? 1 : 0);
        return hash;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof ScreenMode)) {
            return false;
        }
        return ((ScreenMode)o2).width == this.width && ((ScreenMode)o2).height == this.height && ((ScreenMode)o2).fullscreen == this.fullscreen && ((ScreenMode)o2).fullscreenWindow == this.fullscreenWindow;
    }

    public String toString() {
        return this.width + "x" + this.height + (this.fullscreen ? " Fullscreen" : " Windowed") + (this.fullscreenWindow ? " Window" : "");
    }
}

