/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.catengine.util;

import java.io.Serializable;
import java.util.HashMap;

public final class Clr
implements Serializable {
    public final int r;
    public final int g;
    public final int b;
    public final int a;
    private final String toString;
    public transient Object machineColorCache;
    public static final Clr BLACK = new Clr(0, 0, 0);
    public static final Clr WHITE = new Clr(255, 255, 255);
    public static final Clr GREY = new Clr(127, 127, 127);
    public static final Clr LIGHT_GREY = new Clr(191, 191, 191);
    public static final Clr DARK_GREY = new Clr(31, 31, 31);
    public static final Clr RED = new Clr(255, 0, 0);
    public static final Clr GREEN = new Clr(0, 255, 0);
    public static final Clr BLUE = new Clr(0, 0, 255);
    public static final Clr YELLOW = new Clr(255, 255, 0);
    public static final Clr ORANGE = new Clr(255, 127, 0);
    public static final Clr MAGENTA = new Clr(255, 0, 255);
    public static final Clr CYAN = new Clr(0, 255, 255);
    public static final HashMap<String, Clr> COLORS = new HashMap();

    public Clr(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.toString = this.hex(r) + this.hex(g) + this.hex(b) + (a == 255 ? "" : this.hex(a));
    }

    public Clr(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 255;
        this.toString = this.hex(r) + this.hex(g) + this.hex(b) + (this.a == 255 ? "" : this.hex(this.a));
    }

    public static Clr fromHex(String hex) {
        if (hex.length() < 6) {
            return null;
        }
        if (!hex.matches("[0-9a-fA-F]{6,8}")) {
            return null;
        }
        return new Clr(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16), hex.length() >= 8 ? Integer.parseInt(hex.substring(6, 8), 16) : 255);
    }

    public static int clamp(int amt) {
        return amt > 255 ? 255 : (amt < 0 ? 0 : amt);
    }

    public Clr mix(double proportion, Clr c2) {
        return new Clr(Clr.clamp((int)((double)this.r * (1.0 - proportion) + (double)c2.r * proportion)), Clr.clamp((int)((double)this.g * (1.0 - proportion) + (double)c2.g * proportion)), Clr.clamp((int)((double)this.b * (1.0 - proportion) + (double)c2.b * proportion)), Clr.clamp((int)((double)this.a * (1.0 - proportion) + (double)c2.a * proportion)));
    }

    public Clr mult(Clr c2) {
        return c2 == null ? this : new Clr(this.r * c2.r / 255, this.g * c2.g / 255, this.b * c2.b / 255, this.a * c2.a / 255);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.r;
        hash = 89 * hash + this.g;
        hash = 89 * hash + this.b;
        hash = 89 * hash + this.a;
        return hash;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Clr)) {
            return false;
        }
        return ((Clr)o2).r == this.r && ((Clr)o2).g == this.g && ((Clr)o2).b == this.b && ((Clr)o2).a == this.a;
    }

    public String toString() {
        return this.toString;
    }

    String hex(int i) {
        String h = Integer.toHexString(i);
        return h.length() == 1 ? "0" + h : h;
    }

    public static Clr getNamedColor(String name) {
        return COLORS.get(name);
    }

    static {
        COLORS.put("BLACK", BLACK);
        COLORS.put("WHITE", WHITE);
        COLORS.put("GREY", GREY);
        COLORS.put("LIGHT_GREY", LIGHT_GREY);
        COLORS.put("DARK_GREY", DARK_GREY);
        COLORS.put("RED", RED);
        COLORS.put("GREEN", GREEN);
        COLORS.put("BLUE", BLUE);
        COLORS.put("YELLOW", YELLOW);
        COLORS.put("MAGENTA", MAGENTA);
        COLORS.put("CYAN", CYAN);
    }
}

