/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tiled;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.newdawn.slick.Color;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.tiled.GroupObject;
import org.newdawn.slick.tiled.TiledMap;
import org.newdawn.slick.tiled.TiledMapPlus;
import org.newdawn.slick.util.Log;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ObjectGroup {
    public int index;
    public String name;
    public ArrayList<GroupObject> objects;
    public int width;
    public int height;
    private HashMap<String, Integer> nameToObjectMap = new HashMap();
    public Properties props;
    TiledMap map;
    public float opacity = 1.0f;
    public boolean visible = true;
    public Color color = new Color(Color.white);

    public ObjectGroup(Element element, TiledMap map) throws SlickException {
        NodeList properties;
        Element propsElement;
        String colorS;
        String heightS;
        this.map = map;
        TiledMapPlus tmap = null;
        if (map instanceof TiledMapPlus) {
            tmap = (TiledMapPlus)map;
        }
        this.name = element.getAttribute("name");
        String widthS = element.getAttribute("width");
        if (widthS != null && widthS.length() != 0) {
            this.width = Integer.parseInt(widthS);
        }
        if ((heightS = element.getAttribute("height")) != null && heightS.length() != 0) {
            this.height = Integer.parseInt(heightS);
        }
        if (this.width == 0 || this.height == 0) {
            Log.warn("ObjectGroup " + this.name + " has zero size (width or height equal to 0)");
        }
        this.objects = new ArrayList();
        String opacityS = element.getAttribute("opacity");
        if (opacityS != null && opacityS.length() != 0) {
            this.opacity = Float.parseFloat(opacityS);
        }
        if ("0".equals(element.getAttribute("visible"))) {
            this.visible = false;
        }
        if ((colorS = element.getAttribute("color")) != null && colorS.length() != 0) {
            try {
                this.color = Color.decode(colorS);
            }
            catch (NumberFormatException e) {
                Log.warn("color attribute in element " + this.name + " could not be parsed; reverting to white");
            }
        }
        if ((propsElement = (Element)element.getElementsByTagName("properties").item(0)) != null && (properties = propsElement.getElementsByTagName("property")) != null) {
            this.props = new Properties();
            for (int p = 0; p < properties.getLength(); ++p) {
                Element propElement = (Element)properties.item(p);
                String name = propElement.getAttribute("name");
                String value = propElement.getAttribute("value");
                this.props.setProperty(name, value);
            }
        }
        NodeList objectNodes = element.getElementsByTagName("object");
        int i = 0;
        while (i < objectNodes.getLength()) {
            Element objElement = (Element)objectNodes.item(i);
            GroupObject object = null;
            object = tmap != null ? new GroupObject(objElement, tmap) : new GroupObject(objElement);
            object.index = i++;
            this.objects.add(object);
        }
    }

    public GroupObject getObject(String objectName) {
        GroupObject g = this.objects.get(this.nameToObjectMap.get(objectName));
        return g;
    }

    public ArrayList<GroupObject> getObjectsOfType(String type) {
        ArrayList<GroupObject> foundObjects = new ArrayList<GroupObject>();
        for (GroupObject object : this.objects) {
            if (!object.type.equals(type)) continue;
            foundObjects.add(object);
        }
        return foundObjects;
    }

    public void removeObject(String objectName) {
        int objectOffset = this.nameToObjectMap.get(objectName);
        GroupObject object = this.objects.remove(objectOffset);
    }

    public void setObjectNameMapping(HashMap<String, Integer> map) {
        this.nameToObjectMap = map;
    }

    public void addObject(GroupObject object) {
        this.objects.add(object);
        this.nameToObjectMap.put(object.name, this.objects.size());
    }

    public ArrayList<GroupObject> getObjects() {
        return this.objects;
    }
}

