/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tests;

import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.Log;

public class FontTest
extends BasicGame {
    private AngelCodeFont font;
    private AngelCodeFont font2;
    private Image image;
    private float widthMult = 1.0f;
    private float width = 0.0f;
    private static AppGameContainer container;

    public FontTest() {
        super("Font Test");
    }

    @Override
    public void init(GameContainer container) throws SlickException {
        this.font = new AngelCodeFont("testdata/demo.fnt", "testdata/demo.png");
        this.font2 = new AngelCodeFont("testdata/hiero.fnt", "testdata/hiero.png");
        this.image = this.font.getImage();
    }

    @Override
    public void render(GameContainer container, Graphics g) {
        if (g.getFont() instanceof AngelCodeFont) {
            AngelCodeFont f = (AngelCodeFont)g.getFont();
            String t = "testing } baseline";
            float w = f.getWidth(t);
            g.drawString(t, 400.0f, 500.0f);
            g.setColor(Color.red);
            int ascent = f.getAscent();
            g.drawLine(400.0f, 500 + ascent, 400.0f + w, 500 + ascent);
        }
        this.font.drawString(80.0f, 5.0f, "A Font Example", Color.green);
        this.font.drawString(100.0f, 32.0f, "We - AV - Here is a more complete line that hopefully");
        this.font.drawString(100.0f, 36 + this.font.getHeight("We Here is a more complete line that hopefully"), "will show some kerning.");
        this.font2.drawString(80.0f, 85.0f, "A Font Example", Color.green);
        this.font2.drawString(100.0f, 132.0f, "We - AV - Here is a more complete line that hopefully");
        this.font2.drawString(100.0f, 136 + this.font2.getHeight("We - Here is a more complete line that hopefully"), "will show some kerning.");
        this.image.draw(100.0f, 400.0f);
        String testStr = "Testing Font";
        this.font2.drawString(100.0f, 300.0f, testStr);
        g.setColor(Color.white);
        g.drawRect(100.0f, 300 + this.font2.getYOffset(testStr), this.font2.getWidth(testStr), this.font2.getHeight(testStr) - this.font2.getYOffset(testStr));
        this.font.drawString(500.0f, 300.0f, testStr);
        g.setColor(Color.white);
        g.drawRect(500.0f, 300 + this.font.getYOffset(testStr), this.font.getWidth(testStr), this.font.getHeight(testStr) - this.font.getYOffset(testStr));
        g.setColor(Color.white);
        this.drawTextBox(this.font, "custom font render", 500.0f, 350.0f, this.width);
        g.drawRect(500.0f, 350.0f, this.width, this.font.getLineHeight());
    }

    private void drawTextBox(AngelCodeFont font, CharSequence text, float x, float y, float maxWidth) {
        AngelCodeFont.Glyph lastDef = null;
        font.getImage().startUse();
        float startX = x;
        x = 0.0f;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            AngelCodeFont.Glyph def = font.getGlyph(c);
            if (def == null) continue;
            x = lastDef != null ? (x += (float)lastDef.getKerning(c)) : (x -= (float)def.xoffset);
            lastDef = def;
            if ((float)(def.xoffset + def.width) + x > maxWidth) break;
            Image subImage = def.image;
            subImage.drawEmbedded(startX + x + (float)def.xoffset, y + (float)def.yoffset, def.width, def.height);
            x += (float)def.xadvance;
        }
        font.getImage().endUse();
    }

    @Override
    public void update(GameContainer container, int delta) throws SlickException {
        this.width += (float)delta * 0.1f * this.widthMult;
        if (this.width > 270.0f || this.width < 0.0f) {
            this.widthMult = this.widthMult == 1.0f ? -1.0f : 1.0f;
        }
    }

    @Override
    public void keyPressed(int key, char c) {
        if (key == 1) {
            System.exit(0);
        }
        if (key == 57) {
            try {
                container.setDisplayMode(640, 480, false);
            }
            catch (SlickException e) {
                Log.error(e);
            }
        }
    }

    public static void main(String[] argv) {
        try {
            container = new AppGameContainer(new FontTest());
            container.setDisplayMode(800, 600, false);
            container.start();
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }
}

