<?php
/**
 * 店铺浏量统计
 */

namespace app\home\controller;

use Think\Lang;

class Statisticsflow extends BaseSeller
{
    private $search_arr;//处理后的参数
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/statisticsflow.lang.php');
        import('mall.statistics');
        import('mall.datehelper');
        $stat_model = model('stat');
        //存储参数
        $this->search_arr = $_REQUEST;
        //处理搜索时间
        $this->search_arr = $stat_model->dealwithSearchTime($this->search_arr);
        //获得系统年份
        $year_arr = getSystemYearArr();
        //获得系统月份
        $month_arr = getSystemMonthArr();
        //获得本月的周时间段
        $week_arr = getMonthWeekArr($this->search_arr['week']['current_year'], $this->search_arr['week']['current_month']);
        $this->assign('year_arr', $year_arr);
        $this->assign('month_arr', $month_arr);
        $this->assign('week_arr', $week_arr);
        $this->assign('search_arr', $this->search_arr);
    }
    /**
     * 店铺流量统计
     */
    public function index() {
        $store_id = intval(session('store_id'));
        //确定统计分表名称
        $last_num = $store_id % 10; //获取店铺ID的末位数字
        $tablenum = ($t = intval(config('flowstat_tablenum'))) > 1 ? $t : 1; //处理流量统计记录表数量
        $flow_tablename = ($t = ($last_num % $tablenum)) > 0 ? "flowstat_$t" : 'flowstat';
        if(!isset($this->search_arr['search_type'])){
            $this->search_arr['search_type'] = 'week';
        }
        $stat_model = model('stat');
        //获得搜索的开始时间和结束时间
        $searchtime_arr = $stat_model->getStarttimeAndEndtime($this->search_arr);
        $where = array();
        $where['store_id'] = $store_id;
        $where['flowstat_stattime'] = array('between',$searchtime_arr);
        $where['flowstat_type'] = 'sum';

        $field = ' SUM(flowstat_clicknum) as amount';
        if($this->search_arr['search_type'] == 'week'){
            //构造横轴数据
            for($i=1; $i<=7; $i++){
                $tmp_weekarr = getSystemWeekArr();
                //横轴
                $stat_arr['xAxis']['categories'][] = $tmp_weekarr[$i];
                unset($tmp_weekarr);
                $statlist[$i] = 0;
            }
            $field .= ' ,WEEKDAY(FROM_UNIXTIME(flowstat_stattime))+1 as timeval ';
        }
        if($this->search_arr['search_type'] == 'month'){
            //计算横轴的最大量（由于每个月的天数不同）
            $dayofmonth = date('t',$searchtime_arr[0]);
            //构造横轴数据
            for($i=1; $i<=$dayofmonth; $i++){
                //横轴
                $stat_arr['xAxis']['categories'][] = $i;
                $statlist[$i] = 0;
            }
            $field .= ' ,day(FROM_UNIXTIME(flowstat_stattime)) as timeval ';
        }
        $statlist_tmp = $stat_model->statByFlowstat($flow_tablename, $where, $field, 0, 0, 'timeval asc', 'timeval');
        if ($statlist_tmp){
            foreach((array)$statlist_tmp as $k=>$v){
                $statlist[$v['timeval']] = floatval($v['amount']);
            }
        }
        //得到统计图数据
        $stat_arr['legend']['enabled'] = false;
        $stat_arr['series'][0]['name'] = lang('traffic');
        $stat_arr['series'][0]['data'] = array_values($statlist);
        $stat_arr['title'] = lang('store_traffic_statistics');
        $stat_arr['yAxis'] = lang('visits');
        $stat_json = getStatData_LineLabels($stat_arr);
        $this->assign('stat_json',$stat_json);
        $this->setSellerCurMenu('Statisticsflow');
        $this->setSellerCurItem('index');
        return $this->fetch($this->template_dir.'index');
    }

    /**
     * 商品流量统计
     */
    public function goodsflow() {
        $store_id = intval(session('store_id'));
        //确定统计分表名称
        $last_num = $store_id % 10; //获取店铺ID的末位数字
        $tablenum = ($t = intval(config('flowstat_tablenum'))) > 1 ? $t : 1; //处理流量统计记录表数量
        $flow_tablename = ($t = ($last_num % $tablenum)) > 0 ? "flowstat_$t" : 'flowstat';
        if(!isset($this->search_arr['search_type'])){
            $this->search_arr['search_type'] = 'week';
        }
        $stat_model = model('stat');
        //获得搜索的开始时间和结束时间
        $searchtime_arr = $stat_model->getStarttimeAndEndtime($this->search_arr);
        $where = array();
        $where['store_id'] = $store_id;
        $where['flowstat_stattime'] = array('between',$searchtime_arr);
        $where['flowstat_type'] = 'goods';

        $field = ' goods_id,SUM(flowstat_clicknum) as amount';
        $stat_arr = array();
        //构造横轴数据
        for($i=1; $i<=30; $i++){
            //横轴
            $stat_arr['xAxis']['categories'][] = $i;
            $stat_arr['series'][0]['data'][] = array('name'=>'','y'=>0);
        }
        $statlist_tmp = $stat_model->statByFlowstat($flow_tablename, $where, $field, 0, 30, 'amount desc,goods_id asc', 'goods_id');
        if ($statlist_tmp){
            $goodsid_arr = array();
            foreach((array)$statlist_tmp as $k=>$v){
                $goodsid_arr[] = $v['goods_id'];
            }
            //查询相应商品
            $goods_list_tmp = $stat_model->statByGoods(array('goods_id'=>array('in',$goodsid_arr)), $field = 'goods_name,goods_id');
            foreach ((array)$goods_list_tmp as $k=>$v){
                $goods_list[$v['goods_id']] = $v;
            }
            foreach((array)$statlist_tmp as $k=>$v){
                if (isset($goods_list[$v['goods_id']])) {
                    $v['goods_name'] = $goods_list[$v['goods_id']];
                    $v['amount'] = floatval($v['amount']);
                    $statlist[] = $v;
                    $stat_arr['series'][0]['data'][$k] = array('name' => strval($goods_list[$v['goods_id']]['goods_name']), 'y' => floatval($v['amount']));
                }
            }
        }
        //得到统计图数据
        $stat_arr['legend']['enabled'] = false;
        $stat_arr['series'][0]['name'] = lang('traffic');
        $stat_arr['title'] = lang('product_visits');
        $stat_arr['yAxis'] = lang('visits');
        $stat_json = getStatData_Column2D($stat_arr);
        $this->assign('stat_json',$stat_json);
        $this->setSellerCurMenu('Statisticsflow');
        $this->setSellerCurItem('goodsflow');
        return $this->fetch($this->template_dir.'flowgoods');
    }
    /**
     * 用户中心右边，小导航
     *
     * @param string	$menu_type	导航类型
     * @param string 	$name	当前导航的name
     * @return
     */
    protected function getSellerItemList()
    {
        $menu_array	= array(
            array('name'=>'index','text'=>lang('total_store_flow'),'url'=>url('Statisticsflow/index')),
            array('name'=>'goodsflow','text'=>lang('commodity_flow_ranking'),'url'=>url('Statisticsflow/goodsflow'))
        );
        return $menu_array;
    }
}