<?php

namespace app\admin\controller;

use think\Lang;

class Activity extends AdminControl {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/'.config('default_lang').'/activity.lang.php');
    }

    /**
     * 活动列表/删除活动
     */
    public function index() {
        $activity_model = model('activity');
        //条件
        $condition = array();
        $condition['activity_type'] = '1'; //只显示商品活动
        //状态
        if ((input('param.searchstate'))) {
            $state = intval(input('param.searchstate')) - 1;
            $condition['activity_state'] = "$state";
        }
        //标题
        if ((input('param.searchtitle'))) {
            $condition['activity_title'] = array('like', "%" . input('param.searchtitle') . "%");
        }
        //有效期范围
        if ((input('param.searchstartdate')) && (input('param.searchenddate'))) {
            $startdate = strtotime(input('param.searchstartdate'));
            $enddate = strtotime(input('param.searchenddate'));
            if ($enddate > 0) {
                $enddate += 86400;
            }
            $condition['activity_enddate'] = array('egt',$startdate);
            $condition['activity_startdate'] = array('elt',$enddate);
        }
        //活动列表
        $activity_list = $activity_model->getActivityList($condition, 10 , 'activity_sort asc');
        //输出
        $this->assign('show_page', $activity_model->page_info->render());
        $this->assign('activity_list', $activity_list);
        $this->assign('filtered', $condition ? 1 : 0); //是否有查询条件
        $this->setAdminCurItem('index');
        return $this->fetch();
    }

    /**
     * 新建活动/保存新建活动
     */
    public function add() {
        if (request()->isPost()) {
            //提交表单
            $data = [
                'activity_title' => input('post.activity_title'),
                'activity_startdate' => strtotime(input('post.activity_startdate')),
                'activity_enddate' => strtotime(input('post.activity_enddate')),
                'activity_style' => input('post.activity_style'),
                'activity_type' =>input('post.activity_type'),
                'activity_banner' => $_FILES['activity_banner']['name'],
                'activity_sort' => intval(input('post.activity_sort'))
            ];
            $activity_validate = validate('activity');
            if (!$activity_validate->scene('add')->check($data)) {
                $this->error($activity_validate->getError());
            }

            $file_name = '';
            if (!empty($_FILES['activity_banner']['name'])) {
                $upload_file = BASE_UPLOAD_PATH . DS . ATTACH_ACTIVITY;
                $file = request()->file('activity_banner');
                $info = $file->rule('uniqid')->validate(['ext' => ALLOW_IMG_EXT])->move($upload_file);
                if ($info) {
                    $file_name = $info->getFilename();
                } else {
                    $this->error($file->getError());
                }
            }
            //保存
            $data['activity_banner'] = $file_name;
            $data['activity_desc'] = trim(input('post.activity_desc'));
            $data['activity_state'] = intval(input('post.activity_state'));
            
            $activity_model = model('activity');
            $result = $activity_model->addActivity($data);
            if ($result) {
                $this->log(lang('ds_add') . lang('activity_index') . '[' . input('post.activity_title') . ']', null);
                dsLayerOpenSuccess(lang('ds_common_op_succ'));
            } else {
                //添加失败则删除刚刚上传的图片,节省空间资源
                @unlink($upload_file . DS . $file_name);
                $this->error(lang('ds_common_op_fail'));
            }
        } else {
            $activity= array(
                'activity_type'=>'1',
                'activity_startdate'=>TIMESTAMP,
                'activity_enddate'=>TIMESTAMP,
                'activity_banner'=>'',
                'activity_style'=>'',
                'activity_desc'=>'',
                'activity_state'=>'1',
            );
            $this->assign('activity', $activity);
            return $this->fetch('form');
        }
    }

    /**
     * 异步修改
     */
    public function ajax() {
        if (in_array(input('param.branch'), array('activity_title', 'activity_sort'))) {
            $activity_model = model('activity');
            $update_array = array();
            switch (input('param.branch')) {
                /**
                 * 活动主题
                 */
                case 'activity_title':
                    if (trim(input('param.value')) == '')
                        exit;
                    break;
                /**
                 * 排序
                 */
                case 'activity_sort':
                    if (preg_match('/^\d+$/', trim(input('param.value'))) <= 0 or intval(trim(input('param.value'))) < 0 or intval(trim(input('param.value'))) > 255)
                        exit;
                    break;
                default:
                    exit;
            }
            $update_array[input('param.column')] = trim(input('param.value'));
            if ($activity_model->editActivity($update_array, intval(input('param.id'))))
                echo 'true';
        }elseif (in_array(input('param.branch'), array('activitydetail_sort'))) {
            $activitydetail_model = model('activitydetail');
            $update_array = array();
            switch (input('param.branch')) {
                /**
                 * 排序
                 */
                case 'activitydetail_sort':
                    if (preg_match('/^\d+$/', trim(input('param.value'))) <= 0 or intval(trim(input('param.value'))) < 0 or intval(trim(input('param.value'))) > 255)
                        exit;
                    break;
                default:
                    exit;
            }
            $update_array[input('param.column')] = trim(input('param.value'));
            if ($activitydetail_model->editActivitydetail($update_array, array('activitydetail_id'=>intval(input('param.id')))))
                echo 'true';
        }
    }

    /**
     * 删除活动
     */
    public function del() {
        $id = intval(input('param.activity_id'));
        if ($id <= 0) {
            ds_json_encode(10001, lang('param_error'));
        }

        $activity_model = model('activity');
        $activitydetail_model = model('activitydetail');
        //获取可以删除的数据
        $condition_arr = array();
        $condition_arr['activity_state'] = '0'; //已关闭
        $condition_arr['activity_enddate'] = array('lt',TIMESTAMP); //过期
        $condition_arr['activity_id'] = $id;
        $activity_list = $activity_model->getActivityList($condition_arr);
        if (empty($activity_list)) {//没有符合条件的活动信息直接返回成功信息
            ds_json_encode(10001, lang('activity_index_help3'));
        }
        $id_arr = array();
        foreach ($activity_list as $v) {
            $id_arr[] = $v['activity_id'];
        }
        $condition = array();
        $condition['activity_id'] = array('in',$id_arr);
        //只有关闭或者过期的活动，能删除
        if ($activitydetail_model->getActivitydetailList($condition)) {
            if (!$activitydetail_model->delActivitydetail($condition)) {
                ds_json_encode(10001, lang('activity_del_fail'));
            }
        }
        try {
            //删除数据先删除横幅图片，节省空间资源
            foreach ($id_arr as $v) {
                $this->delBanner(intval($v));
            }
        } catch (Exception $e) {
            ds_json_encode(10001, $e->getMessage());
        }
        if ($activity_model->delActivity($condition)) {
            $this->log(lang('ds_del') . lang('activity_index') . '[ID:' . $id . ']', null);
            ds_json_encode(10000, lang('ds_common_del_succ'));
        }
        ds_json_encode(10001, lang('activity_del_fail'));
    }

    /**
     * 编辑活动/保存编辑活动
     */
    public function edit() {
        $activity_id = intval(input('param.activity_id'));
        if ($activity_id<=0) {
            $this->error(lang('miss_argument'));
        }
        $activity_model = model('activity');
        $activity = $activity_model->getOneActivityById($activity_id);
        if (!request()->isPost()) {
            $this->assign('activity', $activity);
            return $this->fetch('form');
        } else {
            //提交表单
            $data = [
                'activity_title' => input('post.activity_title'),
                'activity_startdate' => strtotime(input('post.activity_startdate')),
                'activity_enddate' => strtotime(input('post.activity_enddate')),
                'activity_style' => input('post.activity_style'),
                'activity_type' => input('post.activity_type'),
                'activity_sort' => intval(input('post.activity_sort'))
            ];
            $activity_validate = validate('activity');
            if (!$activity_validate->scene('edit')->check($data)) {
                $this->error($activity_validate->getError());
            }
            //构造更新内容
            $file_name = '';
            if ($_FILES['activity_banner']['name'] != '') {
                $upload_file = BASE_UPLOAD_PATH . DS . ATTACH_ACTIVITY;
                $file = request()->file('activity_banner');
                $info = $file->rule('uniqid')->validate(['ext' => ALLOW_IMG_EXT])->move($upload_file);
                if ($info) {
                    $file_name = $info->getFilename();
                    $data['activity_banner'] = $file_name;
                } else {
                    $this->error($file->getError());
                }
            }
            
            $data['activity_desc'] = trim(input('post.activity_desc'));
            $data['activity_state'] = intval(input('post.activity_state'));
            
            $result = $activity_model->editActivity($data, $activity_id);
            if ($result) {
                //删除图片
                @unlink($upload_file . DS .$activity['activity_banner']);
                $this->log(lang('ds_edit') . lang('activity_index') . '[ID:' . $activity_id . ']', null);
                dsLayerOpenSuccess(lang('ds_common_save_succ'));
            } else {
                if ($_FILES['activity_banner']['name'] != '') {
                    @unlink($upload_file . DS .$file_name);
                }
                $this->error(lang('ds_common_save_fail'));
            }
        }
    }

    /**
     * 活动细节列表
     */
    public function detail() {
        $activity_id = intval(input('param.id'));
        if ($activity_id <= 0) {
            $this->error(lang('miss_argument'));
        }
        //条件
        $condition_arr = array();
        $condition_arr['activity_id'] = $activity_id;
        //审核状态
        if ((input('param.searchstate'))) {
            $state = intval(input('param.searchstate')) - 1;
            $condition_arr['activitydetail_state'] = "$state";
        }
        //店铺名称
        if ((input('param.searchstore'))) {
            $condition_arr['store_name'] = array('like', "%" . input('param.searchstore') . "%");
        }
        //商品名称
        if ((input('param.searchgoods'))) {
            $condition_arr['item_name'] = array('like', "%" . input('param.searchgoods') . "%");
        }

        $activitydetail_model = model('activitydetail');
        $activitydetail_list = $activitydetail_model->getActivitydetailList($condition_arr, 10);
        //输出到模板
        $this->assign('show_page', $activitydetail_model->page_info->render());
        $this->assign('activitydetail_list', $activitydetail_list);
        $this->setAdminCurItem('detail');
        return $this->fetch();
    }

    /**
     * 活动内容处理
     */
    public function deal() {
        $activitydetail_id = input('param.activitydetail_id');
        $activitydetail_id_array = ds_delete_param($activitydetail_id);
        if ($activitydetail_id_array == FALSE) {
            ds_json_encode('10001', lang('param_error'));
        }
        $condition = array();
        $condition['activitydetail_id'] = array('in',$activitydetail_id_array);

        //创建活动内容对象
        $activitydetail_state = intval(input('param.state'));
        $result = model('activitydetail')->where($condition)->update(array('activitydetail_state' => $activitydetail_state));
        if ($result>=0) {
            $this->log(lang('ds_edit') . lang('activity_index') . '[ID:' . $activitydetail_id . ']', null);
            $this->success(lang('ds_common_op_succ'));
        } else {
            $this->error(lang('ds_common_op_fail'));
        }
    }
    /**
     * 删除活动内容
     */
    public function del_detail() {
        $activitydetail_id = input('param.activitydetail_id');
        $activitydetail_id_array = ds_delete_param($activitydetail_id);
        if ($activitydetail_id_array == FALSE) {
            ds_json_encode('10001', lang('param_error'));
        }

        $activitydetail_model = model('activitydetail');
        //条件
        $condition_arr = array();
        $condition_arr['activitydetail_id'] =array('in',$activitydetail_id_array);
        $condition_arr['activitydetail_state'] = array('in',array('0','2')); //未审核和已拒绝
        if ($activitydetail_model->delActivitydetail($condition_arr)) {
            $this->log(lang('ds_del') . lang('activity_index_content') . '[ID:' . implode(',', $activitydetail_id_array) . ']', null);
            ds_json_encode(10000, lang('ds_common_del_succ'));
        } else {
            ds_json_encode(10001, lang('ds_common_del_fail'));
        }
    }

    /**
     * 根据活动编号删除横幅图片
     *
     * @param int $id
     */
    private function delBanner($id) {
        $activity_model = model('activity');
        $row = $activity_model->getOneActivityById($id);
        //删除图片文件
        @unlink(BASE_UPLOAD_PATH . DS . ATTACH_ACTIVITY . DS . $row['activity_banner']);
    }

    /**
     * 获取卖家栏目列表,针对控制器下的栏目
     */
    protected function getAdminItemList() {
        $menu_array = array(
            array(
                'name' => 'index', 'text' => lang('ds_manage'), 'url' => url('Activity/index')
            ), array(
                'name' => 'add',
                'text' => lang('ds_new'),
                'url' => "javascript:dsLayerOpen('".url('Activity/add')."','新增')"
            ),
        );
        if (request()->action() == 'detail') {
            $menu_array[] = array(
                'name' => 'detail', 'text' => lang('processing_application'), 'url' => 'javascript:void(0)'
            );
        }
        return $menu_array;
    }

}
