<?php
/**
 * DBERP 进销存系统
 *
 * ==========================================================================
 * @link      http://www.dberp.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   http://www.dberp.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Sales\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * 退货商品表
 * Class SalesOrderGoodsReturn
 * @package Sales\Entity
 * @ORM\Entity(repositoryClass="Sales\Repository\SalesOrderGoodsReturnRepository")
 * @ORM\Table(name="dberp_sales_order_goods_return")
 */
class SalesOrderGoodsReturn
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="goods_return_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $goodsReturnId;

    /**
     *
     * @ORM\Column(name="sales_order_return_id", type="integer", length=11)
     */
    private $salesOrderReturnId;

    /**
     * 销售商品id
     * @ORM\Column(name="sales_goods_id", type="integer", length=11)
     */
    private $salesGoodsId;

    /**
     * 商品名称
     * @ORM\Column(name="goods_name", type="string", length=100)
     */
    private $goodsName;

    /**
     * 商品编号
     * @ORM\Column(name="goods_number", type="string", length=50)
     */
    private $goodsNumber;

    /**
     * 商品规格
     * @ORM\Column(name="goods_spec", type="string", length=100)
     */
    private $goodsSpec;

    /**
     * 商品单位
     * @ORM\Column(name="goods_unit", type="string", length=20)
     */
    private $goodsUnit;

    /**
     * 销售商品单价
     * @ORM\Column(name="sales_goods_price", type="decimal", scale=4)
     */
    private $salesGoodsPrice;

    /**
     * 退货商品税金
     * @ORM\Column(name="sales_goods_tax", type="decimal", scale=4)
     */
    private $salesGoodsTax;

    /**
     * 退货商品数量
     * @ORM\Column(name="goods_return_num", type="integer", length=11)
     */
    private $goodsReturnNum;

    /**
     * 退货商品金额
     * @ORM\Column(name="goods_return_amount", type="decimal", scale=4)
     */
    private $goodsReturnAmount;

    /**
     * @return mixed
     */
    public function getGoodsReturnId()
    {
        return $this->goodsReturnId;
    }

    /**
     * @param mixed $goodsReturnId
     */
    public function setGoodsReturnId($goodsReturnId)
    {
        $this->goodsReturnId = $goodsReturnId;
    }

    /**
     * @return mixed
     */
    public function getSalesOrderReturnId()
    {
        return $this->salesOrderReturnId;
    }

    /**
     * @param mixed $salesOrderReturnId
     */
    public function setSalesOrderReturnId($salesOrderReturnId)
    {
        $this->salesOrderReturnId = $salesOrderReturnId;
    }

    /**
     * @return mixed
     */
    public function getSalesGoodsId()
    {
        return $this->salesGoodsId;
    }

    /**
     * @param mixed $salesGoodsId
     */
    public function setSalesGoodsId($salesGoodsId)
    {
        $this->salesGoodsId = $salesGoodsId;
    }

    /**
     * @return mixed
     */
    public function getGoodsName()
    {
        return $this->goodsName;
    }

    /**
     * @param mixed $goodsName
     */
    public function setGoodsName($goodsName)
    {
        $this->goodsName = $goodsName;
    }

    /**
     * @return mixed
     */
    public function getGoodsNumber()
    {
        return $this->goodsNumber;
    }

    /**
     * @param mixed $goodsNumber
     */
    public function setGoodsNumber($goodsNumber)
    {
        $this->goodsNumber = $goodsNumber;
    }

    /**
     * @return mixed
     */
    public function getGoodsSpec()
    {
        return $this->goodsSpec;
    }

    /**
     * @param mixed $goodsSpec
     */
    public function setGoodsSpec($goodsSpec)
    {
        $this->goodsSpec = $goodsSpec;
    }

    /**
     * @return mixed
     */
    public function getGoodsUnit()
    {
        return $this->goodsUnit;
    }

    /**
     * @param mixed $goodsUnit
     */
    public function setGoodsUnit($goodsUnit)
    {
        $this->goodsUnit = $goodsUnit;
    }

    /**
     * @return mixed
     */
    public function getSalesGoodsPrice()
    {
        return $this->salesGoodsPrice;
    }

    /**
     * @param mixed $salesGoodsPrice
     */
    public function setSalesGoodsPrice($salesGoodsPrice)
    {
        $this->salesGoodsPrice = $salesGoodsPrice;
    }

    /**
     * @return mixed
     */
    public function getSalesGoodsTax()
    {
        return $this->salesGoodsTax;
    }

    /**
     * @param mixed $salesGoodsTax
     */
    public function setSalesGoodsTax($salesGoodsTax)
    {
        $this->salesGoodsTax = $salesGoodsTax;
    }

    /**
     * @return mixed
     */
    public function getGoodsReturnNum()
    {
        return $this->goodsReturnNum;
    }

    /**
     * @param mixed $goodsReturnNum
     */
    public function setGoodsReturnNum($goodsReturnNum)
    {
        $this->goodsReturnNum = $goodsReturnNum;
    }

    /**
     * @return mixed
     */
    public function getGoodsReturnAmount()
    {
        return $this->goodsReturnAmount;
    }

    /**
     * @param mixed $goodsReturnAmount
     */
    public function setGoodsReturnAmount($goodsReturnAmount)
    {
        $this->goodsReturnAmount = $goodsReturnAmount;
    }

}