﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApplication7
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        private int[,] array;   //创建界面数组
        private int dire = 4;   //给定初始方向，1代表上，2代表左，3代表下，4代表右
        private Graphics g;     //创建图形类
        private Point startpoint;  //创建蛇头坐标
        private Point endpoint;    //蛇尾坐标
        private Point foodpoint;   //食物坐标
        private int score = 0;     //记录分数
        private int scores = 0;
        private int len = 3;       //记录长度


        private void Form1_KeyDown(object sender, KeyEventArgs e)   //按下方向键的动作
        {
            if (e.KeyCode.Equals(Keys.W))
            {
                dire = 1;  //此时方向为上，以下三个同理
            }
           else if (e.KeyCode.Equals(Keys.S))
            {
                dire = 3;
            }
            else if (e.KeyCode.Equals(Keys.A))
            {
                dire = 2;
            }
            else if (e.KeyCode.Equals(Keys.D))
            {
                dire = 4;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            switch (comboBox1.SelectedItem.ToString()) //按选择的难度开始
            {
                case "Easy":
                    timer1.Interval = 200;
                    break;
                case"Normal":
                    timer1.Interval = 100;
                    break;
                case"Hard":
                    timer1.Interval = 50;
                    break;
            }
            init();  //初始化函数
            addfood();  //添加一个食物
            timer1.Start();  //定时起启动
        }
        private void init()  //初始化函数
        {
            label3.Text = "Length:  3";
            label2.Text = "Scores:  0";
            len = 3;
            dire = 4;
            score = 0;
            timer1.Stop();
            g = label1.CreateGraphics();
            g.Clear(Color.Black);  //将界面填充为黑色
            array = new int[40, 30]; //重新给界面数组赋值，界面数组为1代表有蛇，0代表没蛇，-1代表有食物
            for (int i = 0; i < 40; i++)
            {
                for (int j = 0; j < 30; j++)
                {
                    array[i, j] = 0;
                }
            }
            array[0, 0] = 1;
            array[1, 0] = 1;
            array[2, 0] = 1;
            g.FillRectangle(new SolidBrush(Color.Yellow), 30, 0, 14, 14);//画蛇头，颜色为黄色
            g.FillRectangle(new SolidBrush(Color.Red), 0, 0, 14, 14);//画蛇身，颜色为红色
            g.FillRectangle(new SolidBrush(Color.Red), 15, 0, 14, 14);//同上
            startpoint = new Point(2,0);//初始化蛇头坐标
            endpoint = new Point(0, 0);//初始化蛇尾坐标
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            try
            {
                move();//蛇移动函数
            }
            catch (Exception ex)
            {
                init();
                MessageBox.Show("啊哦！你的得分："+scores.ToString(),"提示",MessageBoxButtons.OK,MessageBoxIcon.Information);
                scores = 0; 
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            g = label1.CreateGraphics();
            label2.Text = "Scores:  " + score.ToString();
            label3.Text = "Length:  " + len.ToString();
            comboBox1.DropDownStyle = ComboBoxStyle.DropDownList;
            comboBox1.SelectedIndex = 0;
        }
        private void move() //移动函数
        {
            g.FillRectangle(new SolidBrush(Color.Red), startpoint.X * 15, startpoint.Y*15, 14, 14);
            switch (dire)
            {
                case 4:
                    startpoint.X += 1;
                    checkk();
                    break;
                case 3:
                    startpoint.Y += 1;
                    checkk();
                    break;
                case 2:
                    startpoint.X -= 1;
                    checkk();
                    break;
                case 1:
                    startpoint.Y -= 1;
                    checkk();
                    break;

            }
            if (!meetfood())//如果没遇见食物
            {
                g.FillRectangle(new SolidBrush(Color.Black), endpoint.X * 15, endpoint.Y * 15, 14, 14);
                array[endpoint.X, endpoint.Y] = 0;
                checkend();
            }
            array[startpoint.X, startpoint.Y] = 1;
            g.FillRectangle(new SolidBrush(Color.Yellow), startpoint.X * 15, startpoint.Y * 15, 14, 14);//向前走了一步，画新的蛇头
        }
        private void checkend() //重组计算新的蛇尾坐标
        {
            if (endpoint.X >= 1 && array[endpoint.X-1, endpoint.Y] == 1) //左
            {
                endpoint.X -= 1;
            }
            else if (endpoint.X <= 39 && array[endpoint.X + 1, endpoint.Y] == 1)//右
            {
                endpoint.X += 1;
            }
            else if (endpoint.Y >= 1 && array[endpoint.X, endpoint.Y - 1] == 1)//上
            {
                endpoint.Y -= 1;
            }
            else if (endpoint.Y <= 29 && array[endpoint.X, endpoint.Y + 1] == 1)//下
            {
                endpoint.Y += 1;
            }
        }
        private Point createfoodpoint()//随机创建食物坐标
        {
            Point p = new Point();
            Random random = new Random();
            p.X = random.Next(0,39);
            p.Y = random.Next(0,29);
            return p;
        }
        private void createfood(Point newfood)//根据食物坐标，在相应位置画出食物
        {
            g.FillRectangle(new SolidBrush(Color.BlueViolet), newfood.X * 15, newfood.Y * 15, 14, 14);
            array[newfood.X, newfood.Y] = -1;
        }
        private void addfood() //添加食物
        {
            foodpoint = createfoodpoint();
            if (array[foodpoint.X, foodpoint.Y] == 0)
            {
                createfood(foodpoint);
            }
            else
            {
                addfood();
            }
        }
        private bool meetfood() //遇见食物事件
        {
            if (array[startpoint.X, startpoint.Y] == -1)
            {
                addfood();//既然吃到食物，那就在新建一个
                score+=5;
                len++;
                scores = score;
                label2.Text = "Scores:  " + score.ToString();
                label3.Text = "Length:  " + len.ToString();
                return true;
            }
            return false;
        }
        private bool check()//检查是否撞到了自己身上
        {
            if (array[startpoint.X, startpoint.Y] == 1)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        private void checkk()//游戏结束，原因是撞到了自身
        {
            if (check())
            {
                init();
                MessageBox.Show("啊哦！你的得分："+scores.ToString(), "提示", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        private void button1_Leave(object sender, EventArgs e)
        {
            
        }

        private void Form1_Leave(object sender, EventArgs e)
        {

        }

        private void button1_Enter(object sender, EventArgs e)
        {
            
        }
    }
}
