<?php
include('../includes/common.php');
$title = '网址管理';
include('head.php');
if (isset($_COOKIE['adminlogin'])) {
    $_SESSION['adminlogin'] = 1;
}
if ($_SESSION['adminlogin'] != 1) {
    exit('<script language=\'javascript\'>window.location.href=\'./login.php\';</script>');
}
?>
<div class="container" style="padding-top:70px">
    <div class="modal fade" align="left" id="search" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                    <h4 class="modal-title" id="myModalLabel">搜索网址</h4>
                </div>
                <div class="modal-body">
                    <input type="text" class="form-control" name="kw" placeholder="请输入网址"><br />
                    <button type="button" class="btn btn-primary btn-block" id="search_submit">搜索</button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php
    $my = isset($_GET['my']) ? $_GET['my'] : null;
    if ($my == 'add') {
        ?>
        <div class="panel panel-default">
            <div class="panel-heading font-bold" style="background-color: #9999CC;color: white;">添加新网址</div>
            <div class="panel-body">
                <form action="./urllist.php?my=add_submit" method="post" class="form-horizontal" role="form">
                    <div class="form-group">
                        <label class="col-sm-2 control-label">uid:</label>
                        <div class="col-sm-10"><input type="text" name="uid" value="10001" class="form-control" required /></div>
                    </div><br />
                    <div class="form-group">
                        <label class="col-sm-2 control-label">跳转网址:</label>
                        <div class="col-sm-10"><input type="text" name="url" value="" class="form-control" required /></div>
                    </div><br />
                    <div class="form-group">
                        <label class="col-sm-2 control-label">跳转方式:</label>
                        <div class="col-sm-10">
                            <select class="form-control" name="ttype">
                                <option value="1" selected>二次跳转</option>
                                <option value="0">直接跳转</option>
                            </select>
                        </div>
                    </div><br />
                    <div class="form-group">
                        <label class="col-sm-2 control-label">备注:</label>
                        <div class="col-sm-10"><input type="text" name="remarks" value="" class="form-control" /></div>
                    </div><br />
                    <div class="form-group">
                        <div class="col-sm-offset-2 col-sm-10"><input type="submit" name="submit" value="确认添加" class="btn btn-primary form-control" /><br />
                        </div>
                    </div>
                </form>
                <br /><a href="./urllist.php">>>返回网址列表</a>
            </div>
        </div>
    <?php
    } elseif ($my == 'add_submit') {
        $uid = trim($_POST['uid']);
        $url = trim($_POST['url']);
        $ttype = trim($_POST['ttype']);
        $remarks = $_POST['remarks'];
        if (($uid == NULL || $url == NULL) || $ttype == NULL) {
            showmsg('保存错误,请确保每项都不为空!', 3);
        } else {
            $preg = "/^http(s)?:\\/\\/.+/";
            if (!preg_match($preg, $url)) {
                $url = 'http://' . $url;
            }
            $id = getCode(8);
            $ip = $_SERVER["REMOTE_ADDR"];
            if ($ttype == 0) {
                $tzurl = $url;
            } else {
                $tzurl = 'http://' . $_SERVER['SERVER_NAME'] . '/tz.php?id=' . $id;
            }
            $tcn = tcn($tzurl);
            $urlcn = urlcn($tzurl);
            $sql = "insert into url_list(id,uid,addtime,tcn,urlcn,url,setip,jumptype,remarks) value('$id','$uid','$nowDate','$tcn','$urlcn','$url','$ip','$ttype','$remarks')";
            $rs = $conn->query($sql);
            if ($rs) {
                showmsg('添加网址成功！<br/><br/><a href="./urllist.php">>>返回网址列表</a>', 1);
            } else {
                showmsg('添加网址失败！', 4);
            }
        }
    } elseif ($my == 'edit_submit') {
        $id = $_GET['id'];
        $rows = $conn->query("select * from url_list where id = '{$id}'");
        if ($rows->num_rows == 0) {
            showmsg('当前记录不存在！', 3);
        }
        $tcn = trim($_POST['tcn']);
        $urlcn = $_POST['urlcn'];
        $url = $_POST['url'];
        $view = trim($_POST['view']);
        $setip = $_POST['setip'];
        $remarks = $_POST['remarks'];
        if ($url == NULL || $view == NULL) {
            showmsg('保存错误,请确保每项都不为空!', 3);
        }
        $rs = $conn->query("update url_list set tcn='$tcn',urlcn='$urlcn',url='$url',view='$view',setip='$setip',remarks='$remarks' where id='$id'");
        if ($rs) {
            showmsg('修改网址成功！<br/><br/><a href="./urllist.php">>>返回网址列表</a>', 1);
        } else {
            showmsg('修改网址失败！', 4);
        }
    } elseif ($my == 'edit') {
        $id = $_GET['id'];
        $rs = $conn->query("select * from url_list where id= '$id'");
        $row = $rs->fetch_assoc();
        ?>
        <div class="panel panel-default">
            <div class="panel-heading font-bold" style="background-color: #9999CC;color: white;">修改网址信息</div>
            <div class="panel-body">
                <form action="./urllist.php?my=edit_submit&id=<?php echo $row['id']; ?>" method="post" class="form-horizontal" role="form">
                    <div class="form-group">
                        <label class="col-sm-2 control-label">新浪网址:</label>
                        <div class="input-group col-sm-10">
                            <input type="text" name="tcn" value="<?php echo $row['tcn']; ?>" class="form-control" />
                            <span class="input-group-btn">
                                <a href="javascript:upTcn('<?php echo $row['id']; ?>')" class="btn btn-default" title="更新网址"><i class="fa fa-refresh"></i></a>
                            </span>
                        </div>
                    </div><br />
                    <div class="form-group">
                        <label class="col-sm-2 control-label">腾讯网址:</label>
                        <div class="input-group col-sm-10">
                            <input type="text" name="urlcn" value="<?php echo $row['urlcn']; ?>" class="form-control" />
                            <span class="input-group-btn">
                                <a href="javascript:upUrlcn('<?php echo $row['id']; ?>')" class="btn btn-default" title="更新网址"><i class="fa fa-refresh"></i></a>
                            </span>
                        </div>
                    </div><br />
                    <div class="form-group">
                        <label class="col-sm-2 control-label">跳转网址:</label>
                        <div class="col-sm-10"><input type="text" name="url" value="<?php echo $row['url']; ?>" class="form-control" required /></div>
                    </div><br />
                    <div class="form-group">
                        <label class="col-sm-2 control-label">访问次数:</label>
                        <div class="col-sm-10"><input type="text" name="view" value="<?php echo $row['view']; ?>" class="form-control" required /></div>
                    </div><br />
                    <div class="form-group">
                        <label class="col-sm-2 control-label">添加IP:</label>
                        <div class="col-sm-10"><input type="text" name="setip" value="<?php echo $row['setip']; ?>" class="form-control" /></div>
                    </div><br />
                    <div class="form-group">
                        <label class="col-sm-2 control-label">网址备注:</label>
                        <div class="col-sm-10"><input type="text" name="remarks" value="<?php echo $row['remarks']; ?>" class="form-control" /></div>
                    </div><br />
                    <div class="form-group">
                        <div class="col-sm-offset-2 col-sm-10"><input type="submit" name="submit" value="确认修改" class="btn btn-primary form-control" /><br />
                        </div>
                    </div>
                </form>
                <br /><a href="./urllist.php">>>返回网址列表</a>
            </div>
        </div>
    <?php
    } elseif ($my == 'delete') {
        $id = $_GET['id'];
        $rs = $conn->query("delete from url_list where id='$id'");
        if ($rs) {
            showmsg('删除成功！<br/><br/><a href="./urllist.php">>>返回网址列表</a>', 1);
        } else {
            showmsg('删除失败！', 4);
        }
    } else {
        $rs = $conn->query("select * from url_list");
        $numrows = $rs->num_rows;

        ?>
        <div class="text-center">
            <div class="panel panel-default">
                <div class="panel-heading">系统共有 <b><?php echo $numrows; ?></b> 个网址</div>
            </div>
        </div>
        <a href="./urllist.php?my=add" class="btn btn-primary">添加网址</a>&nbsp;
        <a href="#" data-toggle="modal" data-target="#search" id="search" class="btn btn-success">搜索</a>&nbsp;
        <a href="javascript:listTable('start')" class="btn btn-default" title="刷新网址列表"><i class="fa fa-refresh"></i></a>
        <div id="listTable"></div>
    <?php
    }
    ?>
</div>
<script>
    function listTable(query) {
        var url = window.document.location.href.toString();
        var queryString = url.split("?")[1];
        query = query || queryString;
        if (query == 'start' || query == undefined) {
            query = '';
            history.replaceState({}, null, './urllist.php');
        } else if (query != undefined) {
            history.replaceState({}, null, './urllist.php?' + query);
        }
        layer.closeAll();
        var ii = layer.load(2, {
            shade: [0.1, '#fff']
        });
        $.ajax({
            type: 'GET',
            url: 'urllist-table.php?' + query,
            dataType: 'html',
            cache: false,
            success: function(data) {
                layer.close(ii);
                $("#listTable").html(data)
            },
            error: function(data) {
                layer.msg('服务器错误');
                return false;
            }
        });
    }

    function upTcn(id) {
        $.ajax({
            type: 'GET',
            url: 'ajax.php?act=upTcn&id=' + id,
            dataType: 'json',
            success: function(data) {
                window.location.reload();
            },
            error: function(data) {
                layer.msg('服务器错误');
                return false;
            }
        });
    }

    function upUrlcn(id) {
        $.ajax({
            type: 'GET',
            url: 'ajax.php?act=upUrlcn&id=' + id,
            dataType: 'json',
            success: function(data) {
                window.location.reload();
            },
            error: function(data) {
                layer.msg('服务器错误');
                return false;
            }
        });
    }

    function setActive(id, state) {
        $.ajax({
            type: 'GET',
            url: 'ajax.php?act=setUrl&id=' + id + '&state=' + state,
            dataType: 'json',
            success: function(data) {
                listTable();
            },
            error: function(data) {
                layer.msg('服务器错误');
                return false;
            }
        });
    }

    function setJump(id, type) {
        $.ajax({
            type: 'GET',
            url: 'ajax.php?act=setJump&id=' + id + '&type=' + type,
            dataType: 'json',
            success: function(data) {
                listTable();
            },
            error: function(data) {
                layer.msg('服务器错误');
                return false;
            }
        });
    }

    $(document).ready(function() {
        $("#search_submit").click(function() {
            var kw = $("input[name='kw']").val();
            $("#search").modal('hide');
            if (kw == '') {
                listTable('start');
            } else {
                listTable('kw=' + kw);
            }
        });
    });
    $(document).ready(function() {
        listTable();
    })
</script>