/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

@BaseCmd.Syntax(cmd="extract-odex-from-coredump", syntax="<core.xxxx>", desc="Extract odex from dalvik memery core dump")
public class ExtractOdexFromCoredumpCmd
extends BaseCmd {
    public static void main(String ... args) {
        new ExtractOdexFromCoredumpCmd().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length < 1) {
            throw new BaseCmd.HelpException("<core.xxxx> is required.");
        }
        Path core = new File(this.remainingArgs[0]).toPath();
        try (FileChannel channel = FileChannel.open(core, StandardOpenOption.READ);){
            List<Long> possibleOdexs = ExtractOdexFromCoredumpCmd.findPossibleOdexLocation(channel);
            ExtractOdexFromCoredumpCmd.extractDex(channel, possibleOdexs, core.getFileName().toString());
        }
    }

    private static void extractDex(SeekableByteChannel channel, List<Long> possibleOdexs, String namePrefix) throws IOException {
        int dexIndex = 0;
        ByteBuffer odexHead = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer copyBuff = ByteBuffer.allocate(524288).order(ByteOrder.LITTLE_ENDIAN);
        int buffSize = 152;
        ByteBuffer head = ByteBuffer.allocate(152).order(ByteOrder.LITTLE_ENDIAN);
        for (long pos : possibleOdexs) {
            int version;
            System.err.println(String.format(">> Check for %08x", pos));
            channel.position(pos);
            head.position(0);
            int c = channel.read(head);
            head.position(0);
            if (c != 152 || (version = head.getInt(4)) != 0x363330 && version != 0x353330) continue;
            int dexOffset = head.getInt(8);
            int dexLength = head.getInt(12);
            int depsOffset = head.getInt(16);
            int depsLength = head.getInt(20);
            int optOffset = head.getInt(24);
            int optLength = head.getInt(28);
            int flags = head.getInt(32);
            int checksum = head.getInt(36);
            if (dexOffset != 40) {
                System.err.println(String.format(">>> dex offset is not 0x28", new Object[0]));
                continue;
            }
            int dexMagic = head.getInt(dexOffset + 0);
            int dexVersion = head.getInt(dexOffset + 4);
            if (dexMagic != 175662436 || dexVersion != 0x363330 && dexVersion != 0x353330) {
                System.err.println(String.format(">>> dex magic is not dex.036 or dex.035: 0x%08x 0x%08x", dexMagic, dexVersion));
                continue;
            }
            int fileSize = head.getInt(dexOffset + 32);
            if (fileSize != dexLength) {
                System.err.println(String.format(">>> dex file size is same with dexLength in odex %d vs %d", fileSize, dexLength));
                continue;
            }
            int endian = head.getInt(dexOffset + 40);
            if (endian != 305419896) {
                System.err.println(String.format(">>> dex endian is not 0x12345678", new Object[0]));
                continue;
            }
            Path nFile = new File(String.format("%s-%02d.odex", namePrefix, dexIndex++)).toPath();
            System.out.println(String.format(">>>> extract 0x%08x to %s", pos, nFile));
            SeekableByteChannel channel2 = Files.newByteChannel(nFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            Throwable throwable = null;
            try {
                odexHead.rewind();
                odexHead.putInt(175727972);
                odexHead.putInt(0x363330);
                odexHead.putInt(40);
                odexHead.putInt(fileSize);
                int nDepsOffset = 40 + fileSize;
                int nDepsPadding = 0;
                if (nDepsOffset % 8 != 0) {
                    nDepsPadding = 8 - nDepsOffset % 8;
                    nDepsOffset += nDepsPadding;
                }
                odexHead.putInt(nDepsOffset);
                odexHead.putInt(depsLength);
                int nOptOffset = nDepsOffset + depsLength;
                int nOptPadding = 0;
                if (nOptOffset % 8 != 0) {
                    nOptPadding = 8 - nOptOffset % 8;
                    nOptOffset += nOptPadding;
                }
                odexHead.putInt(nOptOffset);
                odexHead.putInt(optLength);
                odexHead.putInt(flags);
                odexHead.putInt(checksum);
                odexHead.position(0);
                channel2.write(odexHead);
                channel.position(pos + (long)dexOffset);
                ExtractOdexFromCoredumpCmd.copy(channel, channel2, copyBuff, fileSize);
                if (nDepsPadding != 0) {
                    channel2.write(ByteBuffer.allocate(nDepsPadding));
                }
                channel.position(pos + (long)depsOffset);
                ExtractOdexFromCoredumpCmd.copy(channel, channel2, copyBuff, depsLength);
                if (nOptPadding != 0) {
                    channel2.write(ByteBuffer.allocate(nOptPadding));
                }
                channel.position(pos + (long)optOffset);
                ExtractOdexFromCoredumpCmd.copy(channel, channel2, copyBuff, optLength);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (channel2 == null) continue;
                if (throwable != null) {
                    try {
                        channel2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                channel2.close();
            }
        }
    }

    private static void copy(SeekableByteChannel channel, SeekableByteChannel channel2, ByteBuffer copyBuff, int fileSize) throws IOException {
        int read;
        for (int remain = fileSize; remain > 0; remain -= read) {
            copyBuff.rewind();
            copyBuff.limit(Math.min(remain, copyBuff.capacity()));
            read = channel.read(copyBuff);
            copyBuff.position(0);
            channel2.write(copyBuff);
        }
    }

    private static List<Long> findPossibleOdexLocation(SeekableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(524288).order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = buffer.asIntBuffer();
        ArrayList<Long> possibleOdexs = new ArrayList<Long>();
        while (true) {
            long position = channel.position();
            int count = channel.read(buffer);
            if (count <= 0) break;
            int s = count / 4;
            for (int i = 0; i < s; ++i) {
                int u4 = intBuffer.get(i);
                if (u4 != 175727972) continue;
                if (i + 1 < s) {
                    int v4 = intBuffer.get(i + 1);
                    if (v4 != 0x363330 && v4 != 0x353330) continue;
                    possibleOdexs.add(position + (long)(4 * i));
                    System.err.println(String.format("> Possible %08x | %08x %08x", position + (long)(i * 4), u4, v4));
                    continue;
                }
                possibleOdexs.add(position + (long)(4 * i));
                System.err.println(String.format("> Possible %08x | %08x", position + (long)(i * 4), u4));
            }
            buffer.position(0);
            intBuffer.position(0);
        }
        return possibleOdexs;
    }
}

