/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc.voiceengine;

import android.annotation.TargetApi;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.AutomaticGainControl;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import java.util.UUID;
import org.wrtc.Logging;
import org.wrtc.voiceengine.WebRtcAudioUtils;

class WebRtcAudioEffects {
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    private static final UUID AOSP_AUTOMATIC_GAIN_CONTROL = UUID.fromString("aa8130e0-66fc-11e0-bad0-0002a5d5c51b");
    private static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioEffects";
    private static AudioEffect.Descriptor[] cachedEffects = null;
    private AcousticEchoCanceler aec = null;
    private AutomaticGainControl agc = null;
    private NoiseSuppressor ns = null;
    private boolean shouldEnableAec = false;
    private boolean shouldEnableAgc = false;
    private boolean shouldEnableNs = false;

    private WebRtcAudioEffects() {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
    }

    private static void assertTrue(boolean bl2) {
        if (!bl2) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean canUseAcousticEchoCanceler() {
        boolean bl2 = WebRtcAudioEffects.isAcousticEchoCancelerSupported() && !WebRtcAudioUtils.useWebRtcBasedAcousticEchoCanceler() && !WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted() && !WebRtcAudioEffects.isAcousticEchoCancelerExcludedByUUID();
        Logging.d(TAG, "canUseAcousticEchoCanceler: " + bl2);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean canUseAutomaticGainControl() {
        boolean bl2 = WebRtcAudioEffects.isAutomaticGainControlSupported() && !WebRtcAudioUtils.useWebRtcBasedAutomaticGainControl() && !WebRtcAudioEffects.isAutomaticGainControlBlacklisted() && !WebRtcAudioEffects.isAutomaticGainControlExcludedByUUID();
        Logging.d(TAG, "canUseAutomaticGainControl: " + bl2);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean canUseNoiseSuppressor() {
        boolean bl2 = WebRtcAudioEffects.isNoiseSuppressorSupported() && !WebRtcAudioUtils.useWebRtcBasedNoiseSuppressor() && !WebRtcAudioEffects.isNoiseSuppressorBlacklisted() && !WebRtcAudioEffects.isNoiseSuppressorExcludedByUUID();
        Logging.d(TAG, "canUseNoiseSuppressor: " + bl2);
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WebRtcAudioEffects create() {
        if (WebRtcAudioUtils.runningOnJellyBeanOrHigher()) return new WebRtcAudioEffects();
        Logging.w(TAG, "API level 16 or higher is required!");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=18)
    private boolean effectTypeIsVoIP(UUID uUID) {
        boolean bl2 = false;
        if (!WebRtcAudioUtils.runningOnJellyBeanMR2OrHigher()) {
            return bl2;
        }
        if (AudioEffect.EFFECT_TYPE_AEC.equals(uUID)) {
            if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) return true;
        }
        if (AudioEffect.EFFECT_TYPE_AGC.equals(uUID)) {
            if (WebRtcAudioEffects.isAutomaticGainControlSupported()) return true;
        }
        boolean bl3 = bl2;
        if (!AudioEffect.EFFECT_TYPE_NS.equals(uUID)) return bl3;
        bl3 = bl2;
        if (!WebRtcAudioEffects.isNoiseSuppressorSupported()) return bl3;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AudioEffect.Descriptor[] getAvailableEffects() {
        if (cachedEffects == null) return cachedEffects = AudioEffect.queryEffects();
        return cachedEffects;
    }

    public static boolean isAcousticEchoCancelerBlacklisted() {
        boolean bl2 = WebRtcAudioUtils.getBlackListedModelsForAecUsage().contains(Build.MODEL);
        if (bl2) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW AEC usage!");
        }
        return bl2;
    }

    @TargetApi(value=18)
    private static boolean isAcousticEchoCancelerEffectAvailable() {
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AEC);
    }

    @TargetApi(value=18)
    private static boolean isAcousticEchoCancelerExcludedByUUID() {
        boolean bl2 = false;
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        int n2 = descriptorArray.length;
        int n3 = 0;
        while (true) {
            block4: {
                boolean bl3;
                block3: {
                    bl3 = bl2;
                    if (n3 >= n2) break block3;
                    AudioEffect.Descriptor descriptor = descriptorArray[n3];
                    if (!descriptor.type.equals(AudioEffect.EFFECT_TYPE_AEC) || !descriptor.uuid.equals(AOSP_ACOUSTIC_ECHO_CANCELER)) break block4;
                    bl3 = true;
                }
                return bl3;
            }
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAcousticEchoCancelerSupported() {
        if (!WebRtcAudioUtils.runningOnJellyBeanOrHigher()) return false;
        if (!WebRtcAudioEffects.isAcousticEchoCancelerEffectAvailable()) return false;
        return true;
    }

    public static boolean isAutomaticGainControlBlacklisted() {
        boolean bl2 = WebRtcAudioUtils.getBlackListedModelsForAgcUsage().contains(Build.MODEL);
        if (bl2) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW AGC usage!");
        }
        return bl2;
    }

    @TargetApi(value=18)
    private static boolean isAutomaticGainControlEffectAvailable() {
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AGC);
    }

    @TargetApi(value=18)
    private static boolean isAutomaticGainControlExcludedByUUID() {
        boolean bl2 = false;
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        int n2 = descriptorArray.length;
        int n3 = 0;
        while (true) {
            block4: {
                boolean bl3;
                block3: {
                    bl3 = bl2;
                    if (n3 >= n2) break block3;
                    AudioEffect.Descriptor descriptor = descriptorArray[n3];
                    if (!descriptor.type.equals(AudioEffect.EFFECT_TYPE_AGC) || !descriptor.uuid.equals(AOSP_AUTOMATIC_GAIN_CONTROL)) break block4;
                    bl3 = true;
                }
                return bl3;
            }
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAutomaticGainControlSupported() {
        if (!WebRtcAudioUtils.runningOnJellyBeanOrHigher()) return false;
        if (!WebRtcAudioEffects.isAutomaticGainControlEffectAvailable()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isEffectTypeAvailable(UUID uUID) {
        boolean bl2 = false;
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        if (descriptorArray == null) {
            return bl2;
        }
        int n2 = descriptorArray.length;
        int n3 = 0;
        while (true) {
            boolean bl3 = bl2;
            if (n3 >= n2) return bl3;
            if (descriptorArray[n3].type.equals(uUID)) {
                return true;
            }
            ++n3;
        }
    }

    public static boolean isNoiseSuppressorBlacklisted() {
        boolean bl2 = WebRtcAudioUtils.getBlackListedModelsForNsUsage().contains(Build.MODEL);
        if (bl2) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW NS usage!");
        }
        return bl2;
    }

    @TargetApi(value=18)
    private static boolean isNoiseSuppressorEffectAvailable() {
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_NS);
    }

    @TargetApi(value=18)
    private static boolean isNoiseSuppressorExcludedByUUID() {
        boolean bl2 = false;
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        int n2 = descriptorArray.length;
        int n3 = 0;
        while (true) {
            block4: {
                boolean bl3;
                block3: {
                    bl3 = bl2;
                    if (n3 >= n2) break block3;
                    AudioEffect.Descriptor descriptor = descriptorArray[n3];
                    if (!descriptor.type.equals(AudioEffect.EFFECT_TYPE_NS) || !descriptor.uuid.equals(AOSP_NOISE_SUPPRESSOR)) break block4;
                    bl3 = true;
                }
                return bl3;
            }
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNoiseSuppressorSupported() {
        if (!WebRtcAudioUtils.runningOnJellyBeanOrHigher()) return false;
        if (!WebRtcAudioEffects.isNoiseSuppressorEffectAvailable()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void enable(int n2) {
        void var4_18;
        void var4_16;
        boolean bl2;
        boolean bl3 = true;
        Logging.d(TAG, "enable(audioSession=" + n2 + ")");
        boolean bl4 = this.aec == null;
        WebRtcAudioEffects.assertTrue(bl4);
        bl4 = this.agc == null;
        WebRtcAudioEffects.assertTrue(bl4);
        bl4 = this.ns == null;
        WebRtcAudioEffects.assertTrue(bl4);
        for (AudioEffect.Descriptor descriptor : AudioEffect.queryEffects()) {
            if (!this.effectTypeIsVoIP(descriptor.type)) continue;
            Logging.d(TAG, "name: " + descriptor.name + ", mode: " + descriptor.connectMode + ", implementor: " + descriptor.implementor + ", UUID: " + descriptor.uuid);
        }
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            this.aec = AcousticEchoCanceler.create((int)n2);
            if (this.aec != null) {
                void var4_8;
                void var4_6;
                bl2 = this.aec.getEnabled();
                bl4 = this.shouldEnableAec && WebRtcAudioEffects.canUseAcousticEchoCanceler();
                if (this.aec.setEnabled(bl4) != 0) {
                    Logging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                }
                StringBuilder stringBuilder = new StringBuilder().append("AcousticEchoCanceler: was ");
                if (bl2) {
                    String string2 = "enabled";
                } else {
                    String string3 = "disabled";
                }
                StringBuilder stringBuilder2 = stringBuilder.append((String)var4_6).append(", enable: ").append(bl4).append(", is now: ");
                if (this.aec.getEnabled()) {
                    String string4 = "enabled";
                } else {
                    String string5 = "disabled";
                }
                Logging.d(TAG, stringBuilder2.append((String)var4_8).toString());
            } else {
                Logging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isAutomaticGainControlSupported()) {
            this.agc = AutomaticGainControl.create((int)n2);
            if (this.agc != null) {
                void var4_13;
                void var4_11;
                bl2 = this.agc.getEnabled();
                bl4 = this.shouldEnableAgc && WebRtcAudioEffects.canUseAutomaticGainControl();
                if (this.agc.setEnabled(bl4) != 0) {
                    Logging.e(TAG, "Failed to set the AutomaticGainControl state");
                }
                StringBuilder stringBuilder = new StringBuilder().append("AutomaticGainControl: was ");
                if (bl2) {
                    String string6 = "enabled";
                } else {
                    String string7 = "disabled";
                }
                StringBuilder stringBuilder3 = stringBuilder.append((String)var4_11).append(", enable: ").append(bl4).append(", is now: ");
                if (this.agc.getEnabled()) {
                    String string8 = "enabled";
                } else {
                    String string9 = "disabled";
                }
                Logging.d(TAG, stringBuilder3.append((String)var4_13).toString());
            } else {
                Logging.e(TAG, "Failed to create the AutomaticGainControl instance");
            }
        }
        if (!WebRtcAudioEffects.isNoiseSuppressorSupported()) return;
        this.ns = NoiseSuppressor.create((int)n2);
        if (this.ns == null) {
            Logging.e(TAG, "Failed to create the NoiseSuppressor instance");
            return;
        }
        bl2 = this.ns.getEnabled();
        bl4 = this.shouldEnableNs && WebRtcAudioEffects.canUseNoiseSuppressor() ? bl3 : false;
        if (this.ns.setEnabled(bl4) != 0) {
            Logging.e(TAG, "Failed to set the NoiseSuppressor state");
        }
        StringBuilder stringBuilder = new StringBuilder().append("NoiseSuppressor: was ");
        if (bl2) {
            String string10 = "enabled";
        } else {
            String string11 = "disabled";
        }
        StringBuilder stringBuilder4 = stringBuilder.append((String)var4_16).append(", enable: ").append(bl4).append(", is now: ");
        if (this.ns.getEnabled()) {
            String string12 = "enabled";
        } else {
            String string13 = "disabled";
        }
        Logging.d(TAG, stringBuilder4.append((String)var4_18).toString());
    }

    public void release() {
        Logging.d(TAG, "release");
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        if (this.agc != null) {
            this.agc.release();
            this.agc = null;
        }
        if (this.ns != null) {
            this.ns.release();
            this.ns = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setAEC(boolean bl2) {
        boolean bl3 = false;
        Logging.d(TAG, "setAEC(" + bl2 + ")");
        if (!WebRtcAudioEffects.canUseAcousticEchoCanceler()) {
            Logging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return bl3;
        }
        if (this.aec != null && bl2 != this.shouldEnableAec) {
            Logging.e(TAG, "Platform AEC state can't be modified while recording");
            return bl3;
        }
        this.shouldEnableAec = bl2;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setAGC(boolean bl2) {
        boolean bl3 = false;
        Logging.d(TAG, "setAGC(" + bl2 + ")");
        if (!WebRtcAudioEffects.canUseAutomaticGainControl()) {
            Logging.w(TAG, "Platform AGC is not supported");
            this.shouldEnableAgc = false;
            return bl3;
        }
        if (this.agc != null && bl2 != this.shouldEnableAgc) {
            Logging.e(TAG, "Platform AGC state can't be modified while recording");
            return bl3;
        }
        this.shouldEnableAgc = bl2;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNS(boolean bl2) {
        boolean bl3 = false;
        Logging.d(TAG, "setNS(" + bl2 + ")");
        if (!WebRtcAudioEffects.canUseNoiseSuppressor()) {
            Logging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return bl3;
        }
        if (this.ns != null && bl2 != this.shouldEnableNs) {
            Logging.e(TAG, "Platform NS state can't be modified while recording");
            return bl3;
        }
        this.shouldEnableNs = bl2;
        return true;
    }
}

