/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import java.nio.ByteBuffer;
import org.wrtc.VideoRenderer;

public class VideoRenderer {
    long nativeVideoRenderer;

    public VideoRenderer(Callbacks callbacks) {
        this.nativeVideoRenderer = VideoRenderer.nativeWrapVideoRenderer(callbacks);
    }

    private static native void freeWrappedVideoRenderer(long var0);

    public static native void nativeCopyPlane(ByteBuffer var0, int var1, int var2, int var3, ByteBuffer var4, int var5);

    private static native long nativeWrapVideoRenderer(Callbacks var0);

    private static native void releaseNativeFrame(long var0);

    public static void renderFrameDone(I420Frame i420Frame) {
        i420Frame.yuvPlanes = null;
        i420Frame.textureId = 0;
        if (i420Frame.nativeFramePointer != 0L) {
            VideoRenderer.releaseNativeFrame(i420Frame.nativeFramePointer);
            I420Frame.access$002(i420Frame, 0L);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispose() {
        if (this.nativeVideoRenderer == 0L) {
            return;
        }
        VideoRenderer.freeWrappedVideoRenderer(this.nativeVideoRenderer);
        this.nativeVideoRenderer = 0L;
    }

    public static class I420Frame {
        public final int height;
        private long nativeFramePointer;
        public int rotationDegree;
        public final float[] samplingMatrix;
        public int textureId;
        public final int width;
        public final boolean yuvFrame;
        public ByteBuffer[] yuvPlanes;
        public final int[] yuvStrides;

        I420Frame(int n2, int n3, int n4, int n5, float[] fArray, long l2) {
            this.width = n2;
            this.height = n3;
            this.yuvStrides = null;
            this.yuvPlanes = null;
            this.samplingMatrix = fArray;
            this.textureId = n5;
            this.yuvFrame = false;
            this.rotationDegree = n4;
            this.nativeFramePointer = l2;
            if (n4 % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + n4);
            }
        }

        I420Frame(int n2, int n3, int n4, int[] nArray, ByteBuffer[] byteBufferArray, long l2) {
            this.width = n2;
            this.height = n3;
            this.yuvStrides = nArray;
            this.yuvPlanes = byteBufferArray;
            this.yuvFrame = true;
            this.rotationDegree = n4;
            this.nativeFramePointer = l2;
            if (n4 % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + n4);
            }
            this.samplingMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f};
        }

        static /* synthetic */ long access$002(I420Frame i420Frame, long l2) {
            i420Frame.nativeFramePointer = l2;
            return l2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int rotatedHeight() {
            if (this.rotationDegree % 180 != 0) return this.width;
            return this.height;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int rotatedWidth() {
            if (this.rotationDegree % 180 != 0) return this.height;
            return this.width;
        }

        public String toString() {
            return this.width + "x" + this.height + ":" + this.yuvStrides[0] + ":" + this.yuvStrides[1] + ":" + this.yuvStrides[2];
        }
    }
}

