/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.content.Context;
import org.wrtc.SurfaceTextureHelper;

public interface VideoCapturer {
    public void changeCaptureFormat(int var1, int var2, int var3);

    public void dispose();

    public void initialize(SurfaceTextureHelper var1, Context var2, CapturerObserver var3);

    public boolean isScreencast();

    public void startCapture(int var1, int var2, int var3);

    public void stopCapture() throws InterruptedException;

    public static class AndroidVideoTrackSourceObserver
    implements CapturerObserver {
        private final long nativeSource;

        public AndroidVideoTrackSourceObserver(long l2) {
            this.nativeSource = l2;
        }

        private native void nativeCapturerStarted(long var1, boolean var3);

        private native void nativeCapturerStopped(long var1);

        private native void nativeOnByteBufferFrameCaptured(long var1, byte[] var3, int var4, int var5, int var6, int var7, long var8);

        private native void nativeOnTextureFrameCaptured(long var1, int var3, int var4, int var5, float[] var6, int var7, long var8);

        @Override
        public void onByteBufferFrameCaptured(byte[] byArray, int n2, int n3, int n4, long l2) {
            this.nativeOnByteBufferFrameCaptured(this.nativeSource, byArray, byArray.length, n2, n3, n4, l2);
        }

        @Override
        public void onCapturerStarted(boolean bl2) {
            this.nativeCapturerStarted(this.nativeSource, bl2);
        }

        @Override
        public void onCapturerStopped() {
            this.nativeCapturerStopped(this.nativeSource);
        }

        @Override
        public void onTextureFrameCaptured(int n2, int n3, int n4, float[] fArray, int n5, long l2) {
            this.nativeOnTextureFrameCaptured(this.nativeSource, n2, n3, n4, fArray, n5, l2);
        }
    }

    public static interface CapturerObserver {
        public void onByteBufferFrameCaptured(byte[] var1, int var2, int var3, int var4, long var5);

        public void onCapturerStarted(boolean var1);

        public void onCapturerStopped();

        public void onTextureFrameCaptured(int var1, int var2, int var3, float[] var4, int var5, long var6);
    }
}

