/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.wrtc.ThreadUtils$1;
import org.wrtc.ThreadUtils$1CaughtException;
import org.wrtc.ThreadUtils$1Result;
import org.wrtc.ThreadUtils$2;
import org.wrtc.ThreadUtils$3;
import org.wrtc.ThreadUtils$4;
import org.wrtc.ThreadUtils$5;

public class ThreadUtils {
    public static void awaitUninterruptibly(CountDownLatch countDownLatch) {
        ThreadUtils.executeUninterruptibly(new ThreadUtils$2(countDownLatch));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, long l2) {
        boolean bl2 = false;
        long l3 = SystemClock.elapsedRealtime();
        boolean bl3 = false;
        long l4 = l2;
        while (true) {
            try {
                boolean bl4;
                bl2 = bl4 = countDownLatch.await(l4, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                long l5;
                boolean bl5 = true;
                bl3 = true;
                l4 = l5 = l2 - (SystemClock.elapsedRealtime() - l3);
                if (l5 > 0L) continue;
                bl3 = bl5;
            }
            break;
        }
        if (bl3) {
            Thread.currentThread().interrupt();
        }
        return bl2;
    }

    public static void checkIsOnMainThread() {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new IllegalStateException("Not on main thread!");
        }
    }

    private static StackTraceElement[] concatStackTraces(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[stackTraceElementArray.length + stackTraceElementArray2.length];
        System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray3, 0, stackTraceElementArray.length);
        System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, stackTraceElementArray.length, stackTraceElementArray2.length);
        return stackTraceElementArray3;
    }

    public static void executeUninterruptibly(BlockingOperation blockingOperation) {
        boolean bl2 = false;
        while (true) {
            try {
                blockingOperation.run();
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <V> V invokeAtFrontUninterruptibly(Handler object, Callable<V> callable) {
        if (object.getLooper().getThread() == Thread.currentThread()) {
            try {
                object = callable.call();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return (V)object;
        }
        ThreadUtils$1Result threadUtils$1Result = new ThreadUtils$1Result();
        ThreadUtils$1CaughtException threadUtils$1CaughtException = new ThreadUtils$1CaughtException();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        object.post((Runnable)new ThreadUtils$4(threadUtils$1Result, callable, threadUtils$1CaughtException, countDownLatch));
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        if (threadUtils$1CaughtException.e != null) {
            object = new RuntimeException(threadUtils$1CaughtException.e);
            ((Throwable)object).setStackTrace(ThreadUtils.concatStackTraces(threadUtils$1CaughtException.e.getStackTrace(), ((Throwable)object).getStackTrace()));
            throw object;
        }
        object = threadUtils$1Result.value;
        return (V)object;
    }

    public static void invokeAtFrontUninterruptibly(Handler handler, Runnable runnable) {
        ThreadUtils.invokeAtFrontUninterruptibly(handler, new ThreadUtils$5(runnable));
    }

    public static void joinUninterruptibly(Thread thread) {
        ThreadUtils.executeUninterruptibly(new ThreadUtils$1(thread));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean joinUninterruptibly(Thread thread, long l2) {
        boolean bl2 = true;
        long l3 = SystemClock.elapsedRealtime();
        boolean bl3 = false;
        long l4 = l2;
        while (l4 > 0L) {
            try {
                thread.join(l4);
                break;
            }
            catch (InterruptedException interruptedException) {
                l4 = l2 - (SystemClock.elapsedRealtime() - l3);
                bl3 = true;
            }
        }
        if (bl3) {
            Thread.currentThread().interrupt();
        }
        if (thread.isAlive()) return false;
        return bl2;
    }

    public static void waitUninterruptibly(Object object) {
        ThreadUtils.executeUninterruptibly(new ThreadUtils$3(object));
    }

    public static interface BlockingOperation {
        public void run() throws InterruptedException;
    }

    public static class ThreadChecker {
        private Thread thread = Thread.currentThread();

        public void checkIsOnValidThread() {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() != this.thread) {
                throw new IllegalStateException("Wrong thread");
            }
        }

        public void detachThread() {
            this.thread = null;
        }
    }
}

