/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import org.wrtc.MediaStreamTrack;
import org.wrtc.RtpParameters;

public class RtpSender {
    private MediaStreamTrack cachedTrack;
    final long nativeRtpSender;
    private boolean ownsTrack = true;

    /*
     * Enabled aggressive block sorting
     */
    public RtpSender(long l2) {
        this.nativeRtpSender = l2;
        l2 = RtpSender.nativeGetTrack(l2);
        MediaStreamTrack mediaStreamTrack = l2 == 0L ? null : new MediaStreamTrack(l2);
        this.cachedTrack = mediaStreamTrack;
    }

    private static native void free(long var0);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native long nativeGetTrack(long var0);

    private static native String nativeId(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native boolean nativeSetTrack(long var0, long var2);

    public void dispose() {
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        RtpSender.free(this.nativeRtpSender);
    }

    public RtpParameters getParameters() {
        return RtpSender.nativeGetParameters(this.nativeRtpSender);
    }

    public String id() {
        return RtpSender.nativeId(this.nativeRtpSender);
    }

    public boolean setParameters(RtpParameters rtpParameters) {
        return RtpSender.nativeSetParameters(this.nativeRtpSender, rtpParameters);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setTrack(MediaStreamTrack mediaStreamTrack, boolean bl2) {
        long l2 = this.nativeRtpSender;
        long l3 = mediaStreamTrack == null ? 0L : mediaStreamTrack.nativeTrack;
        if (!RtpSender.nativeSetTrack(l2, l3)) {
            return false;
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        this.cachedTrack = mediaStreamTrack;
        this.ownsTrack = bl2;
        return true;
    }

    public MediaStreamTrack track() {
        return this.cachedTrack;
    }
}

