/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.wrtc.DataChannel;
import org.wrtc.IceCandidate;
import org.wrtc.MediaConstraints;
import org.wrtc.MediaStream;
import org.wrtc.MediaStreamTrack;
import org.wrtc.RtpReceiver;
import org.wrtc.RtpSender;
import org.wrtc.SdpObserver;
import org.wrtc.SessionDescription;
import org.wrtc.StatsObserver;

public class PeerConnection {
    private final List<MediaStream> localStreams;
    private final long nativeObserver;
    private final long nativePeerConnection;
    private List<RtpReceiver> receivers;
    private List<RtpSender> senders;

    static {
        System.loadLibrary("wrtc_so");
    }

    PeerConnection(long l2, long l3) {
        this.nativePeerConnection = l2;
        this.nativeObserver = l3;
        this.localStreams = new LinkedList<MediaStream>();
        this.senders = new LinkedList<RtpSender>();
        this.receivers = new LinkedList<RtpReceiver>();
    }

    private static native void freeObserver(long var0);

    private static native void freePeerConnection(long var0);

    private native boolean nativeAddIceCandidate(String var1, int var2, String var3);

    private native boolean nativeAddLocalStream(long var1);

    private native RtpSender nativeCreateSender(String var1, String var2);

    private native List<RtpReceiver> nativeGetReceivers();

    private native List<RtpSender> nativeGetSenders();

    private native boolean nativeGetStats(StatsObserver var1, long var2);

    private native boolean nativeRemoveIceCandidates(IceCandidate[] var1);

    private native void nativeRemoveLocalStream(long var1);

    private native boolean nativeStartRtcEventLog(int var1, int var2);

    private native void nativeStopRtcEventLog();

    public boolean addIceCandidate(IceCandidate iceCandidate) {
        return this.nativeAddIceCandidate(iceCandidate.sdpMid, iceCandidate.sdpMLineIndex, iceCandidate.sdp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addStream(MediaStream mediaStream) {
        if (!this.nativeAddLocalStream(mediaStream.nativeStream)) {
            return false;
        }
        this.localStreams.add(mediaStream);
        return true;
    }

    public native void close();

    public native void createAnswer(SdpObserver var1, MediaConstraints var2);

    public native DataChannel createDataChannel(String var1, DataChannel.Init var2);

    public native void createOffer(SdpObserver var1, MediaConstraints var2);

    public RtpSender createSender(String object, String string2) {
        if ((object = this.nativeCreateSender((String)object, string2)) != null) {
            this.senders.add((RtpSender)object);
        }
        return object;
    }

    public void dispose() {
        this.close();
        for (MediaStream mediaStream : this.localStreams) {
            this.nativeRemoveLocalStream(mediaStream.nativeStream);
            mediaStream.dispose();
        }
        this.localStreams.clear();
        Iterator<Object> iterator = this.senders.iterator();
        while (iterator.hasNext()) {
            ((RtpSender)iterator.next()).dispose();
        }
        this.senders.clear();
        iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            ((RtpReceiver)iterator.next()).dispose();
        }
        this.receivers.clear();
        PeerConnection.freePeerConnection(this.nativePeerConnection);
        PeerConnection.freeObserver(this.nativeObserver);
    }

    public native SessionDescription getLocalDescription();

    public List<RtpReceiver> getReceivers() {
        Iterator<RtpReceiver> iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        this.receivers = this.nativeGetReceivers();
        return Collections.unmodifiableList(this.receivers);
    }

    public native SessionDescription getRemoteDescription();

    public List<RtpSender> getSenders() {
        Iterator<RtpSender> iterator = this.senders.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        this.senders = this.nativeGetSenders();
        return Collections.unmodifiableList(this.senders);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getStats(StatsObserver statsObserver, MediaStreamTrack mediaStreamTrack) {
        long l2;
        if (mediaStreamTrack == null) {
            l2 = 0L;
            return this.nativeGetStats(statsObserver, l2);
        }
        l2 = mediaStreamTrack.nativeTrack;
        return this.nativeGetStats(statsObserver, l2);
    }

    public native IceConnectionState iceConnectionState();

    public native IceGatheringState iceGatheringState();

    public boolean removeIceCandidates(IceCandidate[] iceCandidateArray) {
        return this.nativeRemoveIceCandidates(iceCandidateArray);
    }

    public void removeStream(MediaStream mediaStream) {
        this.nativeRemoveLocalStream(mediaStream.nativeStream);
        this.localStreams.remove(mediaStream);
    }

    public native boolean setConfiguration(RTCConfiguration var1);

    public native void setLocalDescription(SdpObserver var1, SessionDescription var2);

    public native void setRemoteDescription(SdpObserver var1, SessionDescription var2);

    public native SignalingState signalingState();

    public boolean startRtcEventLog(int n2, int n3) {
        return this.nativeStartRtcEventLog(n2, n3);
    }

    public void stopRtcEventLog() {
        this.nativeStopRtcEventLog();
    }

    public static enum BundlePolicy {
        BALANCED,
        MAXBUNDLE,
        MAXCOMPAT;

    }

    public static enum CandidateNetworkPolicy {
        ALL,
        LOW_COST;

    }

    public static enum ContinualGatheringPolicy {
        GATHER_ONCE,
        GATHER_CONTINUALLY;

    }

    public static enum IceConnectionState {
        NEW,
        CHECKING,
        CONNECTED,
        COMPLETED,
        FAILED,
        DISCONNECTED,
        CLOSED;

    }

    public static enum IceGatheringState {
        NEW,
        GATHERING,
        COMPLETE;

    }

    public static class IceServer {
        public final String password;
        public final String uri;
        public final String username;

        public IceServer(String string2) {
            this(string2, "", "");
        }

        public IceServer(String string2, String string3, String string4) {
            this.uri = string2;
            this.username = string3;
            this.password = string4;
        }

        public String toString() {
            return this.uri + "[" + this.username + ":" + this.password + "]";
        }
    }

    public static enum IceTransportsType {
        NONE,
        RELAY,
        NOHOST,
        ALL;

    }

    public static enum KeyType {
        RSA,
        ECDSA;

    }

    public static interface Observer {
        public void onAddStream(MediaStream var1);

        public void onDataChannel(DataChannel var1);

        public void onIceCandidate(IceCandidate var1);

        public void onIceCandidatesRemoved(IceCandidate[] var1);

        public void onIceConnectionChange(IceConnectionState var1);

        public void onIceConnectionReceivingChange(boolean var1);

        public void onIceGatheringChange(IceGatheringState var1);

        public void onRemoveStream(MediaStream var1);

        public void onRenegotiationNeeded();

        public void onSignalingChange(SignalingState var1);
    }

    public static class RTCConfiguration {
        public boolean audioJitterBufferFastAccelerate;
        public int audioJitterBufferMaxPackets;
        public BundlePolicy bundlePolicy;
        public CandidateNetworkPolicy candidateNetworkPolicy;
        public ContinualGatheringPolicy continualGatheringPolicy;
        public int iceBackupCandidatePairPingInterval;
        public int iceCandidatePoolSize;
        public int iceConnectionReceivingTimeout;
        public List<IceServer> iceServers;
        public IceTransportsType iceTransportsType = IceTransportsType.ALL;
        public KeyType keyType;
        public boolean presumeWritableWhenFullyRelayed;
        public boolean pruneTurnPorts;
        public RtcpMuxPolicy rtcpMuxPolicy;
        public TcpCandidatePolicy tcpCandidatePolicy;

        public RTCConfiguration(List<IceServer> list) {
            this.bundlePolicy = BundlePolicy.BALANCED;
            this.rtcpMuxPolicy = RtcpMuxPolicy.NEGOTIATE;
            this.tcpCandidatePolicy = TcpCandidatePolicy.ENABLED;
            CandidateNetworkPolicy candidateNetworkPolicy = this.candidateNetworkPolicy;
            this.candidateNetworkPolicy = CandidateNetworkPolicy.ALL;
            this.iceServers = list;
            this.audioJitterBufferMaxPackets = 50;
            this.audioJitterBufferFastAccelerate = false;
            this.iceConnectionReceivingTimeout = -1;
            this.iceBackupCandidatePairPingInterval = -1;
            this.keyType = KeyType.ECDSA;
            this.continualGatheringPolicy = ContinualGatheringPolicy.GATHER_ONCE;
            this.iceCandidatePoolSize = 0;
            this.pruneTurnPorts = false;
            this.presumeWritableWhenFullyRelayed = false;
        }
    }

    public static enum RtcpMuxPolicy {
        NEGOTIATE,
        REQUIRE;

    }

    public static enum SignalingState {
        STABLE,
        HAVE_LOCAL_OFFER,
        HAVE_LOCAL_PRANSWER,
        HAVE_REMOTE_OFFER,
        HAVE_REMOTE_PRANSWER,
        CLOSED;

    }

    public static enum TcpCandidatePolicy {
        ENABLED,
        DISABLED;

    }
}

