/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.wrtc.GlUtil;
import org.wrtc.Logging;

public class GlShader {
    private static final String TAG = "GlShader";
    private int program;

    public GlShader(String object, String string2) {
        int n2 = GlShader.compileShader(35633, (String)object);
        int n3 = GlShader.compileShader(35632, string2);
        this.program = GLES20.glCreateProgram();
        if (this.program == 0) {
            throw new RuntimeException("glCreateProgram() failed. GLES20 error: " + GLES20.glGetError());
        }
        GLES20.glAttachShader((int)this.program, (int)n2);
        GLES20.glAttachShader((int)this.program, (int)n3);
        GLES20.glLinkProgram((int)this.program);
        object = new int[1];
        object[0] = false;
        GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])object, (int)0);
        if (object[0] != true) {
            Logging.e(TAG, "Could not link program: " + GLES20.glGetProgramInfoLog((int)this.program));
            throw new RuntimeException(GLES20.glGetProgramInfoLog((int)this.program));
        }
        GLES20.glDeleteShader((int)n2);
        GLES20.glDeleteShader((int)n3);
        GlUtil.checkNoGLES2Error("Creating GlShader");
    }

    private static int compileShader(int n2, String object) {
        int n3 = GLES20.glCreateShader((int)n2);
        if (n3 == 0) {
            throw new RuntimeException("glCreateShader() failed. GLES20 error: " + GLES20.glGetError());
        }
        GLES20.glShaderSource((int)n3, (String)object);
        GLES20.glCompileShader((int)n3);
        object = new int[1];
        object[0] = false;
        GLES20.glGetShaderiv((int)n3, (int)35713, (int[])object, (int)0);
        if (object[0] != true) {
            Logging.e(TAG, "Could not compile shader " + n2 + ":" + GLES20.glGetShaderInfoLog((int)n3));
            throw new RuntimeException(GLES20.glGetShaderInfoLog((int)n3));
        }
        GlUtil.checkNoGLES2Error("compileShader");
        return n3;
    }

    public int getAttribLocation(String string2) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int n2 = GLES20.glGetAttribLocation((int)this.program, (String)string2);
        if (n2 < 0) {
            throw new RuntimeException("Could not locate '" + string2 + "' in program");
        }
        return n2;
    }

    public int getUniformLocation(String string2) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int n2 = GLES20.glGetUniformLocation((int)this.program, (String)string2);
        if (n2 < 0) {
            throw new RuntimeException("Could not locate uniform '" + string2 + "' in program");
        }
        return n2;
    }

    public void release() {
        Logging.d(TAG, "Deleting shader.");
        if (this.program != -1) {
            GLES20.glDeleteProgram((int)this.program);
            this.program = -1;
        }
    }

    public void setVertexAttribArray(String string2, int n2, FloatBuffer floatBuffer) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int n3 = this.getAttribLocation(string2);
        GLES20.glEnableVertexAttribArray((int)n3);
        GLES20.glVertexAttribPointer((int)n3, (int)n2, (int)5126, (boolean)false, (int)0, (Buffer)floatBuffer);
        GlUtil.checkNoGLES2Error("setVertexAttribArray");
    }

    public void useProgram() {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        GLES20.glUseProgram((int)this.program);
        GlUtil.checkNoGLES2Error("glUseProgram");
    }
}

