/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import java.util.Arrays;
import org.wrtc.CameraCapturer$1;
import org.wrtc.CameraCapturer$2;
import org.wrtc.CameraCapturer$3;
import org.wrtc.CameraCapturer$4;
import org.wrtc.CameraCapturer$5;
import org.wrtc.CameraCapturer$6;
import org.wrtc.CameraCapturer$7;
import org.wrtc.CameraCapturer$8;
import org.wrtc.CameraEnumerator;
import org.wrtc.CameraSession;
import org.wrtc.CameraVideoCapturer;
import org.wrtc.Logging;
import org.wrtc.SurfaceTextureHelper;
import org.wrtc.ThreadUtils;
import org.wrtc.VideoCapturer;

public abstract class CameraCapturer
implements CameraVideoCapturer {
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private static final int OPEN_CAMERA_TIMEOUT = 5000;
    private static final String TAG = "CameraCapturer";
    private Context applicationContext;
    private final CameraEnumerator cameraEnumerator;
    private String cameraName;
    private final CameraSession.Events cameraSessionEventsHandler;
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private Handler cameraThreadHandler;
    private VideoCapturer.CapturerObserver capturerObserver;
    private final CameraSession.CreateSessionCallback createSessionCallback = new CameraCapturer$1(this);
    private CameraSession currentSession;
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private boolean firstFrameObserved;
    private int framerate;
    private int height;
    private int openAttemptsRemaining;
    private final Runnable openCameraTimeoutRunnable;
    private boolean sessionOpening;
    private final Object stateLock;
    private SurfaceTextureHelper surfaceHelper;
    private CameraVideoCapturer.CameraSwitchHandler switchEventsHandler;
    private SwitchState switchState;
    private final Handler uiThreadHandler;
    private int width;

    public CameraCapturer(String stringArray, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, CameraEnumerator cameraEnumerator) {
        this.cameraSessionEventsHandler = new CameraCapturer$2(this);
        this.openCameraTimeoutRunnable = new CameraCapturer$3(this);
        this.stateLock = new Object();
        this.switchState = SwitchState.IDLE;
        CameraVideoCapturer.CameraEventsHandler cameraEventsHandler2 = cameraEventsHandler;
        if (cameraEventsHandler == null) {
            cameraEventsHandler2 = new CameraCapturer$4(this);
        }
        this.eventsHandler = cameraEventsHandler2;
        this.cameraEnumerator = cameraEnumerator;
        this.cameraName = stringArray;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        stringArray = cameraEnumerator.getDeviceNames();
        if (stringArray.length == 0) {
            throw new RuntimeException("No cameras attached.");
        }
        if (!Arrays.asList(stringArray).contains(this.cameraName)) {
            throw new IllegalArgumentException("Camera name " + this.cameraName + " does not match any known camera device.");
        }
    }

    static /* synthetic */ void access$000(CameraCapturer cameraCapturer) {
        cameraCapturer.checkIsOnCameraThread();
    }

    static /* synthetic */ Runnable access$100(CameraCapturer cameraCapturer) {
        return cameraCapturer.openCameraTimeoutRunnable;
    }

    static /* synthetic */ boolean access$1000(CameraCapturer cameraCapturer) {
        return cameraCapturer.firstFrameObserved;
    }

    static /* synthetic */ boolean access$1002(CameraCapturer cameraCapturer, boolean bl2) {
        cameraCapturer.firstFrameObserved = bl2;
        return bl2;
    }

    static /* synthetic */ SwitchState access$1100(CameraCapturer cameraCapturer) {
        return cameraCapturer.switchState;
    }

    static /* synthetic */ SwitchState access$1102(CameraCapturer cameraCapturer, SwitchState switchState) {
        cameraCapturer.switchState = switchState;
        return switchState;
    }

    static /* synthetic */ CameraVideoCapturer.CameraSwitchHandler access$1200(CameraCapturer cameraCapturer) {
        return cameraCapturer.switchEventsHandler;
    }

    static /* synthetic */ CameraVideoCapturer.CameraSwitchHandler access$1202(CameraCapturer cameraCapturer, CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        cameraCapturer.switchEventsHandler = cameraSwitchHandler;
        return cameraSwitchHandler;
    }

    static /* synthetic */ String access$1300(CameraCapturer cameraCapturer) {
        return cameraCapturer.cameraName;
    }

    static /* synthetic */ CameraEnumerator access$1400(CameraCapturer cameraCapturer) {
        return cameraCapturer.cameraEnumerator;
    }

    static /* synthetic */ void access$1500(CameraCapturer cameraCapturer, CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        cameraCapturer.switchCameraInternal(cameraSwitchHandler);
    }

    static /* synthetic */ int access$1600(CameraCapturer cameraCapturer) {
        return cameraCapturer.openAttemptsRemaining;
    }

    static /* synthetic */ int access$1610(CameraCapturer cameraCapturer) {
        int n2 = cameraCapturer.openAttemptsRemaining;
        cameraCapturer.openAttemptsRemaining = n2 - 1;
        return n2;
    }

    static /* synthetic */ void access$1700(CameraCapturer cameraCapturer, int n2) {
        cameraCapturer.createSessionInternal(n2);
    }

    static /* synthetic */ CameraSession.CreateSessionCallback access$1800(CameraCapturer cameraCapturer) {
        return cameraCapturer.createSessionCallback;
    }

    static /* synthetic */ CameraSession.Events access$1900(CameraCapturer cameraCapturer) {
        return cameraCapturer.cameraSessionEventsHandler;
    }

    static /* synthetic */ Handler access$200(CameraCapturer cameraCapturer) {
        return cameraCapturer.uiThreadHandler;
    }

    static /* synthetic */ Context access$2000(CameraCapturer cameraCapturer) {
        return cameraCapturer.applicationContext;
    }

    static /* synthetic */ int access$2100(CameraCapturer cameraCapturer) {
        return cameraCapturer.width;
    }

    static /* synthetic */ int access$2200(CameraCapturer cameraCapturer) {
        return cameraCapturer.height;
    }

    static /* synthetic */ int access$2300(CameraCapturer cameraCapturer) {
        return cameraCapturer.framerate;
    }

    static /* synthetic */ Object access$300(CameraCapturer cameraCapturer) {
        return cameraCapturer.stateLock;
    }

    static /* synthetic */ VideoCapturer.CapturerObserver access$400(CameraCapturer cameraCapturer) {
        return cameraCapturer.capturerObserver;
    }

    static /* synthetic */ boolean access$502(CameraCapturer cameraCapturer, boolean bl2) {
        cameraCapturer.sessionOpening = bl2;
        return bl2;
    }

    static /* synthetic */ CameraSession access$600(CameraCapturer cameraCapturer) {
        return cameraCapturer.currentSession;
    }

    static /* synthetic */ CameraSession access$602(CameraCapturer cameraCapturer, CameraSession cameraSession) {
        cameraCapturer.currentSession = cameraSession;
        return cameraSession;
    }

    static /* synthetic */ CameraVideoCapturer.CameraStatistics access$700(CameraCapturer cameraCapturer) {
        return cameraCapturer.cameraStatistics;
    }

    static /* synthetic */ CameraVideoCapturer.CameraStatistics access$702(CameraCapturer cameraCapturer, CameraVideoCapturer.CameraStatistics cameraStatistics) {
        cameraCapturer.cameraStatistics = cameraStatistics;
        return cameraStatistics;
    }

    static /* synthetic */ SurfaceTextureHelper access$800(CameraCapturer cameraCapturer) {
        return cameraCapturer.surfaceHelper;
    }

    static /* synthetic */ CameraVideoCapturer.CameraEventsHandler access$900(CameraCapturer cameraCapturer) {
        return cameraCapturer.eventsHandler;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            Logging.e(TAG, "Check is on camera thread failed.");
            throw new RuntimeException("Not on camera thread.");
        }
    }

    private void createSessionInternal(int n2) {
        this.uiThreadHandler.postDelayed(this.openCameraTimeoutRunnable, (long)(n2 + 5000));
        this.cameraThreadHandler.postDelayed((Runnable)new CameraCapturer$5(this), (long)n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void switchCameraInternal(CameraVideoCapturer.CameraSwitchHandler object) {
        Logging.d(TAG, "switchCamera internal");
        String[] stringArray = this.cameraEnumerator.getDeviceNames();
        if (stringArray.length < 2) {
            if (object == null) return;
            object.onCameraSwitchError("No camera to switch to.");
            return;
        }
        Object object2 = this.stateLock;
        synchronized (object2) {
            if (this.switchState != SwitchState.IDLE) {
                Logging.d(TAG, "switchCamera switchInProgress");
                if (object == null) return;
                object.onCameraSwitchError("Camera switch already in progress.");
                return;
            }
            if (!this.sessionOpening && this.currentSession == null) {
                Logging.d(TAG, "switchCamera: No session open");
                if (object == null) return;
                object.onCameraSwitchError("Camera is not running.");
                return;
            }
            this.switchEventsHandler = object;
            if (this.sessionOpening) {
                this.switchState = SwitchState.PENDING;
                return;
            }
            this.switchState = SwitchState.IN_PROGRESS;
            Logging.d(TAG, "switchCamera: Stopping session");
            this.cameraStatistics.release();
            this.cameraStatistics = null;
            CameraSession cameraSession = this.currentSession;
            Handler handler = this.cameraThreadHandler;
            object = new CameraCapturer$8(this, cameraSession);
            handler.post((Runnable)object);
            this.currentSession = null;
            this.cameraName = stringArray[(Arrays.asList(stringArray).indexOf(this.cameraName) + 1) % stringArray.length];
            this.sessionOpening = true;
            this.openAttemptsRemaining = 1;
            this.createSessionInternal(0);
        }
        Logging.d(TAG, "switchCamera done");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void changeCaptureFormat(int n2, int n3, int n4) {
        Logging.d(TAG, "changeCaptureFormat: " + n2 + "x" + n3 + "@" + n4);
        Object object = this.stateLock;
        synchronized (object) {
            this.stopCapture();
            this.startCapture(n2, n3, n4);
            return;
        }
    }

    protected abstract void createCameraSession(CameraSession.CreateSessionCallback var1, CameraSession.Events var2, Context var3, SurfaceTextureHelper var4, String var5, int var6, int var7, int var8);

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose");
        this.stopCapture();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getCameraName() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.cameraName;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, VideoCapturer.CapturerObserver capturerObserver) {
        this.applicationContext = context;
        this.capturerObserver = capturerObserver;
        this.surfaceHelper = surfaceTextureHelper;
        surfaceTextureHelper = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
        this.cameraThreadHandler = surfaceTextureHelper;
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public void printStackTrace() {
        StackTraceElement[] stackTraceElementArray = null;
        if (this.cameraThreadHandler != null) {
            stackTraceElementArray = this.cameraThreadHandler.getLooper().getThread();
        }
        if (stackTraceElementArray != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()).length > 0) {
            Logging.d(TAG, "CameraCapturer stack trace:");
            int n2 = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Logging.d(TAG, stackTraceElementArray[i2].toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startCapture(int n2, int n3, int n4) {
        Logging.d(TAG, "startCapture: " + n2 + "x" + n3 + "@" + n4);
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.sessionOpening && this.currentSession == null) {
                this.width = n2;
                this.height = n3;
                this.framerate = n4;
                this.sessionOpening = true;
                this.openAttemptsRemaining = 3;
                this.createSessionInternal(0);
                return;
            }
            Logging.w(TAG, "Session already open");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stopCapture() {
        Logging.d(TAG, "Stop capture");
        Object object = this.stateLock;
        synchronized (object) {
            while (this.sessionOpening) {
                Logging.d(TAG, "Stop capture: Waiting for session to open");
                ThreadUtils.waitUninterruptibly(this.stateLock);
            }
            if (this.currentSession != null) {
                Logging.d(TAG, "Stop capture: Nulling session");
                this.cameraStatistics.release();
                this.cameraStatistics = null;
                CameraSession cameraSession = this.currentSession;
                Handler handler = this.cameraThreadHandler;
                CameraCapturer$6 cameraCapturer$6 = new CameraCapturer$6(this, cameraSession);
                handler.post((Runnable)cameraCapturer$6);
                this.currentSession = null;
                this.capturerObserver.onCapturerStopped();
            } else {
                Logging.d(TAG, "Stop capture: No session open");
            }
        }
        Logging.d(TAG, "Stop capture done");
    }

    @Override
    public void switchCamera(CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.d(TAG, "switchCamera");
        this.cameraThreadHandler.post((Runnable)new CameraCapturer$7(this, cameraSwitchHandler));
    }

    static enum SwitchState {
        IDLE,
        PENDING,
        IN_PROGRESS;

    }
}

