/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.util.Range;
import android.view.Surface;
import android.view.WindowManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.wrtc.Camera2Enumerator;
import org.wrtc.Camera2Session$1;
import org.wrtc.Camera2Session$CaptureSessionCallback$1;
import org.wrtc.CameraEnumerationAndroid;
import org.wrtc.CameraSession;
import org.wrtc.Logging;
import org.wrtc.Metrics;
import org.wrtc.Size;
import org.wrtc.SurfaceTextureHelper;

@TargetApi(value=21)
public class Camera2Session
implements CameraSession {
    private static final String TAG = "Camera2Session";
    private static final Metrics.Histogram camera2StartTimeMsHistogram = Metrics.Histogram.createCounts("WebRTC.Android.Camera2.StartTimeMs", 1, 10000, 50);
    private static final Metrics.Histogram camera2StopTimeMsHistogram = Metrics.Histogram.createCounts("WebRTC.Android.Camera2.StopTimeMs", 1, 10000, 50);
    private final Context applicationContext;
    private final CameraSession.CreateSessionCallback callback;
    private CameraCharacteristics cameraCharacteristics;
    private CameraDevice cameraDevice;
    private final String cameraId;
    private final CameraManager cameraManager;
    private int cameraOrientation;
    private final Handler cameraThreadHandler;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private CameraCaptureSession captureSession;
    private final long constructionTimeNs;
    private final CameraSession.Events events;
    private boolean firstFrameReported = false;
    private int fpsUnitFactor;
    private final int framerate;
    private final int height;
    private boolean isCameraFrontFacing;
    private SessionState state = SessionState.RUNNING;
    private Surface surface;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int width;

    private Camera2Session(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String string2, int n2, int n3, int n4) {
        Logging.d(TAG, "Create new camera2 session on camera " + string2);
        this.constructionTimeNs = System.nanoTime();
        this.cameraThreadHandler = new Handler();
        this.callback = createSessionCallback;
        this.events = events;
        this.applicationContext = context;
        this.cameraManager = cameraManager;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = string2;
        this.width = n2;
        this.height = n3;
        this.framerate = n4;
        this.start();
    }

    static /* synthetic */ Surface access$1002(Camera2Session camera2Session, Surface surface) {
        camera2Session.surface = surface;
        return surface;
    }

    static /* synthetic */ CameraCaptureSession access$102(Camera2Session camera2Session, CameraCaptureSession cameraCaptureSession) {
        camera2Session.captureSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    static /* synthetic */ boolean access$1500(Camera2Session camera2Session) {
        return camera2Session.firstFrameReported;
    }

    static /* synthetic */ boolean access$1502(Camera2Session camera2Session, boolean bl2) {
        camera2Session.firstFrameReported = bl2;
        return bl2;
    }

    static /* synthetic */ long access$1600(Camera2Session camera2Session) {
        return camera2Session.constructionTimeNs;
    }

    static /* synthetic */ Metrics.Histogram access$1700() {
        return camera2StartTimeMsHistogram;
    }

    static /* synthetic */ int access$1800(Camera2Session camera2Session) {
        return camera2Session.getFrameOrientation();
    }

    static /* synthetic */ boolean access$1900(Camera2Session camera2Session) {
        return camera2Session.isCameraFrontFacing;
    }

    static /* synthetic */ SessionState access$200(Camera2Session camera2Session) {
        return camera2Session.state;
    }

    static /* synthetic */ int access$2000(Camera2Session camera2Session) {
        return camera2Session.cameraOrientation;
    }

    static /* synthetic */ SessionState access$202(Camera2Session camera2Session, SessionState sessionState) {
        camera2Session.state = sessionState;
        return sessionState;
    }

    static /* synthetic */ CameraDevice access$702(Camera2Session camera2Session, CameraDevice cameraDevice) {
        camera2Session.cameraDevice = cameraDevice;
        return cameraDevice;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String string2, int n2, int n3, int n4) {
        new Camera2Session(createSessionCallback, events, context, cameraManager, surfaceTextureHelper, string2, n2, n3, n4);
    }

    private void findCaptureFormat() {
        this.checkIsOnCameraThread();
        Object object = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = Camera2Enumerator.getFpsUnitFactor(object);
        Object object2 = Camera2Enumerator.convertFramerates(object, this.fpsUnitFactor);
        object = Camera2Enumerator.getSupportedSizes(this.cameraCharacteristics);
        Logging.d(TAG, "Available preview sizes: " + object);
        Logging.d(TAG, "Available fps ranges: " + object2);
        if (object2.isEmpty() || object.isEmpty()) {
            this.reportError("No supported capture formats.");
        }
        object2 = CameraEnumerationAndroid.getClosestSupportedFramerateRange(object2, (int)this.framerate);
        object = CameraEnumerationAndroid.getClosestSupportedSize((List)object, (int)this.width, (int)this.height);
        this.captureFormat = new CameraEnumerationAndroid.CaptureFormat(((Size)object).width, ((Size)object).height, (CameraEnumerationAndroid.CaptureFormat.FramerateRange)object2);
        Logging.d(TAG, "Using capture format: " + this.captureFormat);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getDeviceOrientation() {
        switch (((WindowManager)this.applicationContext.getSystemService("window")).getDefaultDisplay().getRotation()) {
            default: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: 
        }
        return 270;
    }

    private int getFrameOrientation() {
        int n2;
        int n3 = n2 = this.getDeviceOrientation();
        if (!this.isCameraFrontFacing) {
            n3 = 360 - n2;
        }
        return (n3 + this.cameraOrientation) % 360;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openCamera() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "Opening camera " + this.cameraId);
        this.events.onCameraOpening();
        try {
            CameraManager cameraManager = this.cameraManager;
            String string2 = this.cameraId;
            CameraStateCallback cameraStateCallback = new CameraStateCallback(null);
            cameraManager.openCamera(string2, (CameraDevice.StateCallback)cameraStateCallback, this.cameraThreadHandler);
            return;
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("Failed to open camera: " + (Object)((Object)cameraAccessException));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void reportError(String string2) {
        this.checkIsOnCameraThread();
        Logging.e(TAG, "Error: " + string2);
        boolean bl2 = this.captureSession == null;
        this.state = SessionState.STOPPED;
        this.stopInternal();
        if (bl2) {
            this.callback.onFailure(string2);
            return;
        }
        this.events.onCameraError(this, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void start() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "start");
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("getCameraCharacteristics(): " + cameraAccessException.getMessage());
        }
        this.cameraOrientation = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        boolean bl2 = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        this.isCameraFrontFacing = bl2;
        this.findCaptureFormat();
        this.openCamera();
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        this.surfaceTextureHelper.stopListening();
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        Logging.d(TAG, "Stop done");
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera2 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long l2 = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            int n2 = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
            camera2StopTimeMsHistogram.addSample(n2);
        }
    }

    private class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private CameraCaptureCallback() {
        }

        /* synthetic */ CameraCaptureCallback(Camera2Session$1 camera2Session$1) {
            this();
        }

        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            Logging.d(Camera2Session.TAG, "Capture failed: " + captureFailure);
        }
    }

    private class CameraStateCallback
    extends CameraDevice.StateCallback {
        private CameraStateCallback() {
        }

        /* synthetic */ CameraStateCallback(Camera2Session$1 camera2Session$1) {
            this();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getErrorDescription(int n2) {
            switch (n2) {
                default: {
                    return "Unknown camera error: " + n2;
                }
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 1: {
                    return "Camera device is in use already.";
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 2: 
            }
            return "Camera device could not be opened because there are too many other open camera devices.";
        }

        public void onClosed(CameraDevice cameraDevice) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera device closed.");
            Camera2Session.this.events.onCameraClosed(Camera2Session.this);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onDisconnected(CameraDevice cameraDevice) {
            Camera2Session.this.checkIsOnCameraThread();
            boolean bl2 = Camera2Session.this.captureSession == null;
            Camera2Session.access$202(Camera2Session.this, SessionState.STOPPED);
            Camera2Session.this.stopInternal();
            if (bl2) {
                Camera2Session.this.callback.onFailure("Camera disconnected / evicted.");
                return;
            }
            Camera2Session.this.events.onCameraDisconnected(Camera2Session.this);
        }

        public void onError(CameraDevice cameraDevice, int n2) {
            Camera2Session.this.checkIsOnCameraThread();
            Camera2Session.this.reportError(this.getErrorDescription(n2));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onOpened(CameraDevice cameraDevice) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera opened.");
            Camera2Session.access$702(Camera2Session.this, cameraDevice);
            SurfaceTexture surfaceTexture = Camera2Session.this.surfaceTextureHelper.getSurfaceTexture();
            surfaceTexture.setDefaultBufferSize(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height);
            Camera2Session.access$1002(Camera2Session.this, new Surface(surfaceTexture));
            try {
                List<Surface> list = Arrays.asList(Camera2Session.this.surface);
                CaptureSessionCallback captureSessionCallback = new CaptureSessionCallback(null);
                cameraDevice.createCaptureSession(list, (CameraCaptureSession.StateCallback)captureSessionCallback, Camera2Session.this.cameraThreadHandler);
                return;
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to create capture session. " + (Object)((Object)cameraAccessException));
                return;
            }
        }
    }

    private class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionCallback() {
        }

        /* synthetic */ CaptureSessionCallback(Camera2Session$1 camera2Session$1) {
            this();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void chooseFocusMode(CaptureRequest.Builder builder) {
            int[] nArray = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (nArray[i2] != 3) continue;
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Logging.d(Camera2Session.TAG, "Using continuous video auto-focus.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Auto-focus is not available.");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void chooseStabilizationMode(CaptureRequest.Builder builder) {
            int n2;
            int n3;
            int[] nArray = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (nArray != null) {
                n3 = nArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (nArray[n2] != 1) continue;
                    builder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.d(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            nArray = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
            n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (nArray[n2] != 1) continue;
                builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                builder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                Logging.d(Camera2Session.TAG, "Using video stabilization.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Stabilization not available.");
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Camera2Session.this.checkIsOnCameraThread();
            cameraCaptureSession.close();
            Camera2Session.this.reportError("Failed to configure capture session.");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera capture session configured.");
            Camera2Session.access$102(Camera2Session.this, cameraCaptureSession);
            try {
                CaptureRequest.Builder builder = Camera2Session.this.cameraDevice.createCaptureRequest(3);
                CaptureRequest.Key key = CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE;
                Range range = new Range((Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.min / Camera2Session.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.max / Camera2Session.this.fpsUnitFactor));
                builder.set(key, (Object)range);
                builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                builder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
                this.chooseStabilizationMode(builder);
                this.chooseFocusMode(builder);
                builder.addTarget(Camera2Session.this.surface);
                range = builder.build();
                CameraCaptureCallback cameraCaptureCallback = new CameraCaptureCallback(null);
                cameraCaptureSession.setRepeatingRequest((CaptureRequest)range, (CameraCaptureSession.CaptureCallback)cameraCaptureCallback, Camera2Session.this.cameraThreadHandler);
                Camera2Session.this.surfaceTextureHelper.startListening(new Camera2Session$CaptureSessionCallback$1(this));
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to start capture request. " + (Object)((Object)cameraAccessException));
                return;
            }
            Logging.d(Camera2Session.TAG, "Camera device successfully started.");
            Camera2Session.this.callback.onDone(Camera2Session.this);
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

