/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.os.SystemClock;
import android.util.AndroidException;
import android.util.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wrtc.Camera2Capturer;
import org.wrtc.CameraEnumerationAndroid;
import org.wrtc.CameraEnumerator;
import org.wrtc.CameraVideoCapturer;
import org.wrtc.Logging;
import org.wrtc.Size;

@TargetApi(value=21)
public class Camera2Enumerator
implements CameraEnumerator {
    private static final double NANO_SECONDS_PER_SECOND = 1.0E9;
    private static final String TAG = "Camera2Enumerator";
    private static final Map<String, List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats = new HashMap<String, List<CameraEnumerationAndroid.CaptureFormat>>();
    final CameraManager cameraManager;
    final Context context;

    public Camera2Enumerator(Context context) {
        this.context = context;
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(Range<Integer>[] rangeArray, int n2) {
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        for (Range<Integer> range : rangeArray) {
            arrayList.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange((Integer)range.getLower() * n2, (Integer)range.getUpper() * n2));
        }
        return arrayList;
    }

    private static List<Size> convertSizes(android.util.Size[] sizeArray) {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        for (android.util.Size size : sizeArray) {
            arrayList.add(new Size(size.getWidth(), size.getHeight()));
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CameraCharacteristics getCameraCharacteristics(String string2) {
        try {
            return this.cameraManager.getCameraCharacteristics(string2);
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)androidException));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int getFpsUnitFactor(Range<Integer>[] rangeArray) {
        int n2 = 1000;
        if (rangeArray.length == 0) {
            return n2;
        }
        if ((Integer)rangeArray[0].getUpper() >= 1000) return 1;
        return 1000;
    }

    static List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(Context context, String string2) {
        return Camera2Enumerator.getSupportedFormats((CameraManager)context.getSystemService("camera"), string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(CameraManager object, String string2) {
        Map<String, List<CameraEnumerationAndroid.CaptureFormat>> map = cachedSupportedFormats;
        synchronized (map) {
            Object object2;
            if (cachedSupportedFormats.containsKey(string2)) {
                return cachedSupportedFormats.get(string2);
            }
            StringBuilder stringBuilder = new StringBuilder();
            Logging.d(TAG, stringBuilder.append("Get supported formats for camera index ").append(string2).append(".").toString());
            long l2 = SystemClock.elapsedRealtime();
            try {
                object2 = object.getCameraCharacteristics(string2);
            }
            catch (Exception exception) {
                object = new StringBuilder();
                Logging.e(TAG, ((StringBuilder)object).append("getCameraCharacteristics(): ").append(exception).toString());
                return new ArrayList();
            }
            stringBuilder = (StreamConfigurationMap)object2.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            object = (Range[])object2.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            object = Camera2Enumerator.convertFramerates(object, Camera2Enumerator.getFpsUnitFactor(object));
            object2 = Camera2Enumerator.getSupportedSizes((CameraCharacteristics)object2);
            int n2 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                n2 = Math.max(n2, ((CameraEnumerationAndroid.CaptureFormat.FramerateRange)object.next()).max);
            }
            object = new ArrayList();
            object2 = object2.iterator();
            while (true) {
                Object object3;
                long l3;
                if (!object2.hasNext()) {
                    cachedSupportedFormats.put(string2, (List<CameraEnumerationAndroid.CaptureFormat>)object);
                    l3 = SystemClock.elapsedRealtime();
                    stringBuilder = new StringBuilder();
                    Logging.d(TAG, stringBuilder.append("Get supported formats for camera index ").append(string2).append(" done. Time spent: ").append(l3 - l2).append(" ms.").toString());
                    return object;
                }
                Size size = (Size)object2.next();
                long l4 = 0L;
                try {
                    object3 = new android.util.Size(size.width, size.height);
                    l3 = stringBuilder.getOutputMinFrameDuration(SurfaceTexture.class, (android.util.Size)object3);
                }
                catch (Exception exception) {
                    l3 = l4;
                }
                int n3 = l3 == 0L ? n2 : (int)Math.round(1.0E9 / (double)l3) * 1000;
                object3 = new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, 0, n3);
                object.add(object3);
                object3 = new StringBuilder();
                Logging.d(TAG, ((StringBuilder)object3).append("Format: ").append(size.width).append("x").append(size.height).append("@").append(n3).toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<Size> getSupportedSizes(CameraCharacteristics object) {
        Object object2 = (StreamConfigurationMap)object.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        int n2 = (Integer)object.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        object2 = Camera2Enumerator.convertSizes(object2.getOutputSizes(SurfaceTexture.class));
        if (Build.VERSION.SDK_INT >= 22) return object2;
        if (n2 != 2) return object2;
        Rect rect = (Rect)object.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        object = new ArrayList();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Size size = (Size)object2.next();
            if (rect.width() * size.height != rect.height() * size.width) continue;
            ((ArrayList)object).add(size);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSupported(Context context) {
        int n2;
        int n3;
        String[] stringArray;
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        context = (CameraManager)context.getSystemService("camera");
        try {
            stringArray = context.getCameraIdList();
            n3 = stringArray.length;
            n2 = 0;
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)androidException));
            return false;
        }
        while (n2 < n3) {
            int n4 = (Integer)context.getCameraCharacteristics(stringArray[n2]).get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            if (n4 == 2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public CameraVideoCapturer createCapturer(String string2, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler) {
        return new Camera2Capturer(this.context, string2, cameraEventsHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getDeviceNames() {
        try {
            return this.cameraManager.getCameraIdList();
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)androidException));
            return new String[0];
        }
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String string2) {
        return Camera2Enumerator.getSupportedFormats(this.context, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isBackFacing(String string2) {
        if ((string2 = this.getCameraCharacteristics(string2)) == null) return false;
        if ((Integer)string2.get(CameraCharacteristics.LENS_FACING) != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isFrontFacing(String string2) {
        if ((string2 = this.getCameraCharacteristics(string2)) == null) return false;
        if ((Integer)string2.get(CameraCharacteristics.LENS_FACING) != 0) return false;
        return true;
    }
}

