/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.hardware.Camera;
import android.os.SystemClock;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wrtc.Camera1Capturer;
import org.wrtc.CameraEnumerationAndroid;
import org.wrtc.CameraEnumerator;
import org.wrtc.CameraVideoCapturer;
import org.wrtc.Logging;
import org.wrtc.Size;

public class Camera1Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera1Enumerator";
    private static List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;
    private final boolean captureToTexture;

    public Camera1Enumerator() {
        this(true);
    }

    public Camera1Enumerator(boolean bl2) {
        this.captureToTexture = bl2;
    }

    static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(List<int[]> object) {
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        object = object.iterator();
        while (object.hasNext()) {
            int[] nArray = (int[])object.next();
            arrayList.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange(nArray[0], nArray[1]));
        }
        return arrayList;
    }

    static List<Size> convertSizes(List<Camera.Size> object) {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        object = object.iterator();
        while (object.hasNext()) {
            Camera.Size size = (Camera.Size)object.next();
            arrayList.add(new Size(size.width, size.height));
        }
        return arrayList;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int n2) {
        Serializable serializable;
        Object object;
        long l2;
        block10: {
            block9: {
                Object object2;
                StringBuilder stringBuilder222;
                block8: {
                    Logging.d(TAG, "Get supported formats for camera index " + n2 + ".");
                    l2 = SystemClock.elapsedRealtime();
                    stringBuilder222 = null;
                    object = object2 = null;
                    serializable = stringBuilder222;
                    object = object2;
                    serializable = stringBuilder222;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    object = object2;
                    serializable = stringBuilder222;
                    Logging.d(TAG, stringBuilder2.append("Opening camera with index ").append(n2).toString());
                    object = object2;
                    serializable = stringBuilder222;
                    object = object2 = Camera.open((int)n2);
                    serializable = object2;
                    stringBuilder222 = object2.getParameters();
                    if (object2 == null) break block8;
                    object2.release();
                }
                serializable = new ArrayList();
                object = stringBuilder222.getSupportedPreviewFpsRange();
                if (object == null) break block9;
                object = (int[])object.get(object.size() - 1);
                Object object3 = object[0];
                Object object4 = object[1];
                break block10;
                catch (RuntimeException runtimeException) {
                    serializable = object;
                    try {
                        serializable = object;
                        object2 = new StringBuilder();
                        serializable = object;
                        Logging.e(TAG, ((StringBuilder)object2).append("Open camera failed on camera index ").append(n2).toString(), runtimeException);
                        serializable = object;
                        object2 = new ArrayList();
                        serializable = object2;
                        if (object == null) return serializable;
                    }
                    catch (Throwable throwable) {
                        if (serializable == null) throw throwable;
                        serializable.release();
                        throw throwable;
                    }
                    object.release();
                    return object2;
                }
            }
            boolean bl2 = false;
            boolean bl3 = false;
        }
        try {
            for (StringBuilder stringBuilder222 : stringBuilder222.getSupportedPreviewSizes()) {
                void var9_14;
                void var8_11;
                object = new CameraEnumerationAndroid.CaptureFormat(((Camera.Size)stringBuilder222).width, ((Camera.Size)stringBuilder222).height, (int)var8_11, (int)var9_14);
                serializable.add(object);
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "getSupportedFormats() failed on camera index " + n2, exception);
        }
        long l3 = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + n2 + " done. Time spent: " + (l3 - l2) + " ms.");
        return serializable;
    }

    static int getCameraIndex(String string2) {
        Logging.d(TAG, "getCameraIndex: " + string2);
        for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
            if (!string2.equals(CameraEnumerationAndroid.getDeviceName((int)i2))) continue;
            return i2;
        }
        throw new IllegalArgumentException("No such camera: " + string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Camera.CameraInfo getCameraInfo(int n2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
            return cameraInfo;
        }
        catch (Exception exception) {
            Logging.e(TAG, "getCameraInfo failed on index " + n2, exception);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getDeviceName(int n2) {
        String string2;
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(n2);
        if (cameraInfo == null) {
            return null;
        }
        if (cameraInfo.facing == 1) {
            string2 = "front";
            return "Camera " + n2 + ", Facing " + string2 + ", Orientation " + cameraInfo.orientation;
        }
        string2 = "back";
        return "Camera " + n2 + ", Facing " + string2 + ", Orientation " + cameraInfo.orientation;
    }

    static List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int n2) {
        synchronized (Camera1Enumerator.class) {
            List<Object> list;
            block7: {
                if (cachedSupportedFormats != null) break block7;
                list = new List<Object>();
                cachedSupportedFormats = list;
                int n3 = 0;
                while (true) {
                    if (n3 >= CameraEnumerationAndroid.getDeviceCount()) break;
                    cachedSupportedFormats.add(Camera1Enumerator.enumerateFormats(n3));
                    ++n3;
                    continue;
                    break;
                }
            }
            try {
                list = cachedSupportedFormats.get(n2);
                return list;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
        }
    }

    @Override
    public CameraVideoCapturer createCapturer(String string2, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler) {
        return new Camera1Capturer(string2, cameraEventsHandler, this.captureToTexture);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String[] getDeviceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < Camera.getNumberOfCameras()) {
            String string2 = Camera1Enumerator.getDeviceName(n2);
            if (string2 != null) {
                arrayList.add(string2);
                Logging.d(TAG, "Index: " + n2 + ". " + string2);
            } else {
                Logging.e(TAG, "Index: " + n2 + ". Failed to query camera name.");
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String string2) {
        return Camera1Enumerator.getSupportedFormats(Camera1Enumerator.getCameraIndex(string2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isBackFacing(String string2) {
        if ((string2 = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string2))) == null) return false;
        if (((Camera.CameraInfo)string2).facing != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isFrontFacing(String string2) {
        boolean bl2 = true;
        if ((string2 = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string2))) == null) return false;
        if (((Camera.CameraInfo)string2).facing != 1) return false;
        return bl2;
    }
}

