/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.aspectj.lang.reflect.InitializerSignature;
import org.aspectj.runtime.reflect.CodeSignatureImpl;
import org.aspectj.runtime.reflect.SignatureImpl;
import org.aspectj.runtime.reflect.StringMaker;

class InitializerSignatureImpl
extends CodeSignatureImpl
implements InitializerSignature {
    private Constructor constructor;

    /*
     * Enabled aggressive block sorting
     */
    InitializerSignatureImpl(int n2, Class clazz) {
        String string2 = Modifier.isStatic(n2) ? "<clinit>" : "<init>";
        super(n2, string2, clazz, SignatureImpl.EMPTY_CLASS_ARRAY, SignatureImpl.EMPTY_STRING_ARRAY, SignatureImpl.EMPTY_CLASS_ARRAY);
    }

    InitializerSignatureImpl(String string2) {
        super(string2);
    }

    @Override
    protected String createToString(StringMaker stringMaker) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringMaker.makeModifiersString(this.getModifiers()));
        stringBuffer.append(stringMaker.makePrimaryTypeName(this.getDeclaringType(), this.getDeclaringTypeName()));
        stringBuffer.append(".");
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Constructor getInitializer() {
        if (this.constructor != null) return this.constructor;
        try {
            this.constructor = this.getDeclaringType().getDeclaredConstructor(this.getParameterTypes());
            return this.constructor;
        }
        catch (Exception exception) {
            return this.constructor;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getName() {
        if (!Modifier.isStatic(this.getModifiers())) return "<init>";
        return "<clinit>";
    }
}

