/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.aspectj.lang.NoAspectBoundException;

public class Aspects {
    private static final String ASPECTOF = "aspectOf";
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final String HASASPECT = "hasAspect";
    private static final Class[] PEROBJECT_CLASS_ARRAY;
    private static final Class[] PERTYPEWITHIN_CLASS_ARRAY;

    static {
        PEROBJECT_CLASS_ARRAY = new Class[]{Object.class};
        PERTYPEWITHIN_CLASS_ARRAY = new Class[]{Class.class};
        EMPTY_OBJECT_ARRAY = new Object[0];
    }

    public static <T> T aspectOf(Class<T> clazz) throws NoAspectBoundException {
        Object object;
        try {
            object = Aspects.getSingletonOrThreadAspectOf(clazz).invoke(null, EMPTY_OBJECT_ARRAY);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoAspectBoundException(clazz.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new NoAspectBoundException(clazz.getName(), exception);
        }
        return (T)object;
    }

    public static <T> T aspectOf(Class<T> clazz, Class<?> object) throws NoAspectBoundException {
        try {
            object = Aspects.getPerTypeWithinAspectOf(clazz).invoke(null, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoAspectBoundException(clazz.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new NoAspectBoundException(clazz.getName(), exception);
        }
        return (T)object;
    }

    public static <T> T aspectOf(Class<T> clazz, Object object) throws NoAspectBoundException {
        try {
            object = Aspects.getPerObjectAspectOf(clazz).invoke(null, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoAspectBoundException(clazz.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new NoAspectBoundException(clazz.getName(), exception);
        }
        return (T)object;
    }

    private static Method checkAspectOf(Method method, Class<?> clazz) throws NoSuchMethodException {
        method.setAccessible(true);
        if (!(method.isAccessible() && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()))) {
            throw new NoSuchMethodException(clazz.getName() + ".aspectOf(..) is not accessible public static");
        }
        return method;
    }

    private static Method checkHasAspect(Method method, Class clazz) throws NoSuchMethodException {
        method.setAccessible(true);
        if (!(method.isAccessible() && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()))) {
            throw new NoSuchMethodException(clazz.getName() + ".hasAspect(..) is not accessible public static");
        }
        return method;
    }

    private static Method getPerObjectAspectOf(Class<?> clazz) throws NoSuchMethodException {
        return Aspects.checkAspectOf(clazz.getDeclaredMethod(ASPECTOF, PEROBJECT_CLASS_ARRAY), clazz);
    }

    private static Method getPerObjectHasAspect(Class clazz) throws NoSuchMethodException {
        return Aspects.checkHasAspect(clazz.getDeclaredMethod(HASASPECT, PEROBJECT_CLASS_ARRAY), clazz);
    }

    private static Method getPerTypeWithinAspectOf(Class<?> clazz) throws NoSuchMethodException {
        return Aspects.checkAspectOf(clazz.getDeclaredMethod(ASPECTOF, PERTYPEWITHIN_CLASS_ARRAY), clazz);
    }

    private static Method getPerTypeWithinHasAspect(Class clazz) throws NoSuchMethodException {
        return Aspects.checkHasAspect(clazz.getDeclaredMethod(HASASPECT, PERTYPEWITHIN_CLASS_ARRAY), clazz);
    }

    private static Method getSingletonOrThreadAspectOf(Class<?> clazz) throws NoSuchMethodException {
        return Aspects.checkAspectOf(clazz.getDeclaredMethod(ASPECTOF, EMPTY_CLASS_ARRAY), clazz);
    }

    private static Method getSingletonOrThreadHasAspect(Class clazz) throws NoSuchMethodException {
        return Aspects.checkHasAspect(clazz.getDeclaredMethod(HASASPECT, EMPTY_CLASS_ARRAY), clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasAspect(Class<?> clazz) throws NoAspectBoundException {
        try {
            return (Boolean)Aspects.getSingletonOrThreadHasAspect(clazz).invoke(null, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasAspect(Class<?> clazz, Class<?> clazz2) throws NoAspectBoundException {
        try {
            return (Boolean)Aspects.getPerTypeWithinHasAspect(clazz).invoke(null, clazz2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasAspect(Class<?> clazz, Object object) throws NoAspectBoundException {
        try {
            return (Boolean)Aspects.getPerObjectHasAspect(clazz).invoke(null, object);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

