/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.aspectj.internal.lang.reflect.PointcutExpressionImpl;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.Pointcut;
import org.aspectj.lang.reflect.PointcutExpression;

public class PointcutImpl
implements Pointcut {
    private final Method baseMethod;
    private final AjType declaringType;
    private final String name;
    private String[] parameterNames = new String[0];
    private final PointcutExpression pc;

    protected PointcutImpl(String string2, String string3, Method method, AjType ajType, String string4) {
        this.name = string2;
        this.pc = new PointcutExpressionImpl(string3);
        this.baseMethod = method;
        this.declaringType = ajType;
        this.parameterNames = this.splitOnComma(string4);
    }

    private String[] splitOnComma(String object) {
        object = new StringTokenizer((String)object, ",");
        String[] stringArray = new String[((StringTokenizer)object).countTokens()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = ((StringTokenizer)object).nextToken().trim();
        }
        return stringArray;
    }

    @Override
    public AjType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public int getModifiers() {
        return this.baseMethod.getModifiers();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterNames;
    }

    @Override
    public AjType<?>[] getParameterTypes() {
        Class<?>[] classArray = this.baseMethod.getParameterTypes();
        AjType[] ajTypeArray = new AjType[classArray.length];
        for (int i2 = 0; i2 < ajTypeArray.length; ++i2) {
            ajTypeArray[i2] = AjTypeSystem.getAjType(classArray[i2]);
        }
        return ajTypeArray;
    }

    @Override
    public PointcutExpression getPointcutExpression() {
        return this.pc;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        AjType<?>[] ajTypeArray = this.getParameterTypes();
        for (int i2 = 0; i2 < ajTypeArray.length; ++i2) {
            stringBuffer.append(ajTypeArray[i2].getName());
            if (this.parameterNames != null && this.parameterNames[i2] != null) {
                stringBuffer.append(" ");
                stringBuffer.append(this.parameterNames[i2]);
            }
            if (i2 + 1 >= ajTypeArray.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(") : ");
        stringBuffer.append(this.getPointcutExpression().asString());
        return stringBuffer.toString();
    }
}

