/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.aspectj.internal.lang.reflect.InterTypeDeclarationImpl;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.InterTypeMethodDeclaration;

public class InterTypeMethodDeclarationImpl
extends InterTypeDeclarationImpl
implements InterTypeMethodDeclaration {
    private Method baseMethod;
    private AjType<?>[] exceptionTypes;
    private Type[] genericParameterTypes;
    private Type genericReturnType;
    private String name;
    private int parameterAdjustmentFactor = 1;
    private AjType<?>[] parameterTypes;
    private AjType<?> returnType;

    public InterTypeMethodDeclarationImpl(AjType<?> ajType, String string2, int n2, String string3, Method method) {
        super(ajType, string2, n2);
        this.name = string3;
        this.baseMethod = method;
    }

    public InterTypeMethodDeclarationImpl(AjType<?> ajType, AjType<?> ajType2, Method method, int n2) {
        super(ajType, ajType2, n2);
        this.parameterAdjustmentFactor = 0;
        this.name = method.getName();
        this.baseMethod = method;
    }

    @Override
    public AjType<?>[] getExceptionTypes() {
        Class<?>[] classArray = this.baseMethod.getExceptionTypes();
        AjType[] ajTypeArray = new AjType[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            ajTypeArray[i2] = AjTypeSystem.getAjType(classArray[i2]);
        }
        return ajTypeArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Type[] getGenericParameterTypes() {
        Type[] typeArray = this.baseMethod.getGenericParameterTypes();
        Type[] typeArray2 = new AjType[typeArray.length - this.parameterAdjustmentFactor];
        int n2 = this.parameterAdjustmentFactor;
        while (n2 < typeArray.length) {
            typeArray2[n2 - this.parameterAdjustmentFactor] = typeArray[n2] instanceof Class ? AjTypeSystem.getAjType((Class)typeArray[n2]) : typeArray[n2];
            ++n2;
        }
        return typeArray2;
    }

    @Override
    public Type getGenericReturnType() {
        AjType ajType;
        AjType ajType2 = ajType = this.baseMethod.getGenericReturnType();
        if (ajType instanceof Class) {
            ajType2 = AjTypeSystem.getAjType((Class)((Object)ajType));
        }
        return ajType2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AjType<?>[] getParameterTypes() {
        Class<?>[] classArray = this.baseMethod.getParameterTypes();
        AjType[] ajTypeArray = new AjType[classArray.length - this.parameterAdjustmentFactor];
        for (int i2 = this.parameterAdjustmentFactor; i2 < classArray.length; ++i2) {
            ajTypeArray[i2 - this.parameterAdjustmentFactor] = AjTypeSystem.getAjType(classArray[i2]);
        }
        return ajTypeArray;
    }

    @Override
    public AjType<?> getReturnType() {
        return AjTypeSystem.getAjType(this.baseMethod.getReturnType());
    }

    @Override
    public TypeVariable<Method>[] getTypeParameters() {
        return this.baseMethod.getTypeParameters();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Modifier.toString(this.getModifiers()));
        stringBuffer.append(" ");
        stringBuffer.append(this.getReturnType().toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.targetTypeName);
        stringBuffer.append(".");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        AjType<?>[] ajTypeArray = this.getParameterTypes();
        for (int i2 = 0; i2 < ajTypeArray.length - 1; ++i2) {
            stringBuffer.append(ajTypeArray[i2].toString());
            stringBuffer.append(", ");
        }
        if (ajTypeArray.length > 0) {
            stringBuffer.append(ajTypeArray[ajTypeArray.length - 1].toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

