/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.reflect.Type;
import org.aspectj.internal.lang.reflect.StringToType;
import org.aspectj.internal.lang.reflect.TypePatternImpl;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.DeclareParents;
import org.aspectj.lang.reflect.TypePattern;

public class DeclareParentsImpl
implements DeclareParents {
    private AjType<?> declaringType;
    private String firstMissingTypeName;
    private boolean isExtends;
    private Type[] parents;
    private boolean parentsError = false;
    private String parentsString;
    private TypePattern targetTypesPattern;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeclareParentsImpl(String string2, String string3, boolean bl2, AjType<?> ajType) {
        this.targetTypesPattern = new TypePatternImpl(string2);
        this.isExtends = bl2;
        this.declaringType = ajType;
        this.parentsString = string3;
        try {
            this.parents = StringToType.commaSeparatedListToTypeArray(string3, ajType.getJavaClass());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.parentsError = true;
            this.firstMissingTypeName = classNotFoundException.getMessage();
            return;
        }
    }

    @Override
    public AjType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public Type[] getParentTypes() throws ClassNotFoundException {
        if (this.parentsError) {
            throw new ClassNotFoundException(this.firstMissingTypeName);
        }
        return this.parents;
    }

    @Override
    public TypePattern getTargetTypesPattern() {
        return this.targetTypesPattern;
    }

    @Override
    public boolean isExtends() {
        return this.isExtends;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isImplements() {
        if (this.isExtends) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("declare parents : ");
        stringBuffer.append(this.getTargetTypesPattern().asString());
        String string2 = this.isExtends() ? " extends " : " implements ";
        stringBuffer.append(string2);
        stringBuffer.append(this.parentsString);
        return stringBuffer.toString();
    }
}

