/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.annotation.Annotation;
import org.aspectj.internal.lang.reflect.SignaturePatternImpl;
import org.aspectj.internal.lang.reflect.TypePatternImpl;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.DeclareAnnotation;
import org.aspectj.lang.reflect.SignaturePattern;
import org.aspectj.lang.reflect.TypePattern;

public class DeclareAnnotationImpl
implements DeclareAnnotation {
    private String annText;
    private AjType<?> declaringType;
    private DeclareAnnotation.Kind kind;
    private SignaturePattern signaturePattern;
    private Annotation theAnnotation;
    private TypePattern typePattern;

    /*
     * Enabled aggressive block sorting
     */
    public DeclareAnnotationImpl(AjType<?> ajType, String string2, String string3, Annotation annotation, String string4) {
        this.declaringType = ajType;
        if (string2.equals("at_type")) {
            this.kind = DeclareAnnotation.Kind.Type;
        } else if (string2.equals("at_field")) {
            this.kind = DeclareAnnotation.Kind.Field;
        } else if (string2.equals("at_method")) {
            this.kind = DeclareAnnotation.Kind.Method;
        } else {
            if (!string2.equals("at_constructor")) {
                throw new IllegalStateException("Unknown declare annotation kind: " + string2);
            }
            this.kind = DeclareAnnotation.Kind.Constructor;
        }
        if (this.kind == DeclareAnnotation.Kind.Type) {
            this.typePattern = new TypePatternImpl(string3);
        } else {
            this.signaturePattern = new SignaturePatternImpl(string3);
        }
        this.theAnnotation = annotation;
        this.annText = string4;
    }

    @Override
    public Annotation getAnnotation() {
        return this.theAnnotation;
    }

    @Override
    public String getAnnotationAsText() {
        return this.annText;
    }

    @Override
    public AjType<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public DeclareAnnotation.Kind getKind() {
        return this.kind;
    }

    @Override
    public SignaturePattern getSignaturePattern() {
        return this.signaturePattern;
    }

    @Override
    public TypePattern getTypePattern() {
        return this.typePattern;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("declare @");
        switch (1.$SwitchMap$org$aspectj$lang$reflect$DeclareAnnotation$Kind[this.getKind().ordinal()]) {
            case 1: {
                stringBuffer.append("type : ");
                stringBuffer.append(this.getTypePattern().asString());
                break;
            }
            case 2: {
                stringBuffer.append("method : ");
                stringBuffer.append(this.getSignaturePattern().asString());
                break;
            }
            case 3: {
                stringBuffer.append("field : ");
                stringBuffer.append(this.getSignaturePattern().asString());
                break;
            }
            case 4: {
                stringBuffer.append("constructor : ");
                stringBuffer.append(this.getSignaturePattern().asString());
                break;
            }
        }
        stringBuffer.append(" : ");
        stringBuffer.append(this.getAnnotationAsText());
        return stringBuffer.toString();
    }
}

