/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.widget.NestedScrollView;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.SmoothAppBarLayout;
import me.henrytao.smoothappbarlayout.base.ObservableNestedScrollView;
import me.henrytao.smoothappbarlayout.base.ObservableRecyclerView;
import me.henrytao.smoothappbarlayout.base.OnScrollListener;
import me.henrytao.smoothappbarlayout.base.ScrollTargetCallback;
import me.henrytao.smoothappbarlayout.base.Utils;

public abstract class BaseBehavior
extends AppBarLayout.Behavior {
    private CoordinatorLayout mCoordinatorLayout;
    private int mCurrentOffset;
    private AppBarLayout.Behavior.DragCallback mDragCallbackListener;
    private boolean mIsOnInit = false;
    private boolean mIsPullDownFromTop;
    private boolean mOverrideOnScrollListener;
    private ScrollTargetCallback mScrollTargetCallback;
    private List<Long> mScrollTargets = new ArrayList<Long>();
    private View vScrollTarget;

    public BaseBehavior() {
    }

    public BaseBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View getScrollTarget(View view) {
        if (this.mScrollTargetCallback == null) return this.getSupportedScrollTarget(view);
        return this.mScrollTargetCallback.callback(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View getSupportedScrollTarget(View view) {
        View view2 = view;
        if (!(view instanceof SwipeRefreshLayout)) return view2;
        view2 = view;
        if (((SwipeRefreshLayout)view).getChildCount() <= 0) return view2;
        SwipeRefreshLayout swipeRefreshLayout = (SwipeRefreshLayout)view;
        int n2 = swipeRefreshLayout.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            view2 = swipeRefreshLayout.getChildAt(n3);
            if (view2 instanceof NestedScrollView) return view2;
            if (view2 instanceof RecyclerView) {
                return view2;
            }
            ++n3;
        }
        return ((SwipeRefreshLayout)view).getChildAt(0);
    }

    private void init(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout) {
        if (this.mDragCallbackListener == null) {
            this.mDragCallbackListener = new AppBarLayout.Behavior.DragCallback(){

                public boolean canDrag(AppBarLayout appBarLayout) {
                    return false;
                }
            };
            this.setDragCallback(this.mDragCallbackListener);
        }
        Utils.log("onInit", new Object[0]);
        this.mCoordinatorLayout = coordinatorLayout;
        this.onInit(coordinatorLayout, appBarLayout);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void initScrollTarget(CoordinatorLayout object, AppBarLayout appBarLayout) {
        void var2_3;
        boolean bl2 = this.vScrollTarget != null;
        Utils.log("initScrollTarget | %b", bl2);
        if (this.vScrollTarget == null) return;
        long l2 = this.getViewTag(this.vScrollTarget, true);
        if (this.mScrollTargets.contains(l2)) return;
        this.mScrollTargets.add(l2);
        OnScrollListener onScrollListener = new OnScrollListener((CoordinatorLayout)object, (AppBarLayout)var2_3){
            final /* synthetic */ AppBarLayout val$child;
            final /* synthetic */ CoordinatorLayout val$coordinatorLayout;
            {
                this.val$coordinatorLayout = coordinatorLayout;
                this.val$child = appBarLayout;
            }

            @Override
            public void onScrollChanged(View view, int n2, int n3, int n4, int n5, boolean bl2) {
                if (view == BaseBehavior.this.vScrollTarget) {
                    BaseBehavior.this.onScrollChanged(this.val$coordinatorLayout, this.val$child, view, n3, n5, bl2);
                }
            }
        };
        if (this.vScrollTarget instanceof NestedScrollView) {
            ObservableNestedScrollView.newInstance((NestedScrollView)this.vScrollTarget, this.mOverrideOnScrollListener, onScrollListener);
            return;
        }
        if (!(this.vScrollTarget instanceof RecyclerView)) return;
        ObservableRecyclerView.newInstance((RecyclerView)this.vScrollTarget, onScrollListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void dispatchOffsetUpdates(AppBarLayout appBarLayout, int n2) {
        if (appBarLayout instanceof SmoothAppBarLayout) {
            List list = ((SmoothAppBarLayout)appBarLayout).mOffsetChangedListeners;
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                WeakReference weakReference = (WeakReference)list.get(i2);
                weakReference = weakReference != null ? (AppBarLayout.OnOffsetChangedListener)weakReference.get() : null;
                if (weakReference == null) continue;
                weakReference.onOffsetChanged(appBarLayout, n2);
            }
        }
    }

    public int getCurrentOffset() {
        return this.mCurrentOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getViewTag(View view, boolean bl2) {
        Object object;
        if (view == null) {
            return 0L;
        }
        Object object2 = object = view.getTag(R.id.tag_view_target);
        if (object != null) return (Long)object2;
        if (!bl2) {
            return 0L;
        }
        object2 = System.currentTimeMillis();
        view.setTag(R.id.tag_view_target, object2);
        return (Long)object2;
    }

    protected abstract void onInit(CoordinatorLayout var1, AppBarLayout var2);

    public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int n2, int n3, int n4, int n5) {
        if (!this.mIsOnInit && coordinatorLayout != null && appBarLayout != null) {
            this.mIsOnInit = true;
            this.init(coordinatorLayout, appBarLayout);
        }
        return super.onMeasureChild(coordinatorLayout, appBarLayout, n2, n3, n4, n5);
    }

    public boolean onNestedFling(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, float f2, float f3, boolean bl2) {
        Utils.log("onNestedFling | %f | %f | %b", Float.valueOf(f2), Float.valueOf(f3), bl2);
        return true;
    }

    public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, float f2, float f3) {
        Utils.log("onNestedPreFling | %f | %f", Float.valueOf(f2), Float.valueOf(f3));
        return false;
    }

    public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, int n2, int n3, int[] nArray) {
        Utils.log("onNestedPreScroll | %d | %d", n2, n3);
        this.vScrollTarget = this.getScrollTarget(view);
        this.initScrollTarget(coordinatorLayout, appBarLayout);
        if (n3 < 0 && this.mIsPullDownFromTop) {
            this.onScrollChanged(coordinatorLayout, appBarLayout, this.vScrollTarget, 0, n3, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, int n2, int n3, int n4, int n5) {
        Utils.log("onNestedScroll | %d | %d | %d | %d", n2, n3, n4, n5);
        if (n5 < 0) {
            this.mIsPullDownFromTop = true;
            return;
        }
        this.mIsPullDownFromTop = false;
    }

    public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, View view2, int n2) {
        Utils.log("onNestedScrollAccepted | %d", n2);
        this.onNestedPreScroll(coordinatorLayout, appBarLayout, view2, 0, 0, null);
    }

    protected abstract void onScrollChanged(CoordinatorLayout var1, AppBarLayout var2, View var3, int var4, int var5, boolean var6);

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view, View view2, int n2) {
        Utils.log("onStartNestedScroll | %d", n2);
        return true;
    }

    public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, View view) {
        Utils.log("onStopNestedScroll", new Object[0]);
    }

    public void setDragCallback(AppBarLayout.Behavior.DragCallback dragCallback) {
        super.setDragCallback(dragCallback);
        this.mDragCallbackListener = dragCallback;
    }

    public void setOverrideOnScrollListener(boolean bl2) {
        this.mOverrideOnScrollListener = bl2;
    }

    public void setScrollTargetCallback(ScrollTargetCallback scrollTargetCallback) {
        this.mScrollTargetCallback = scrollTargetCallback;
    }

    protected void syncOffset(AppBarLayout appBarLayout, int n2) {
        Utils.log("syncOffset | %d", n2);
        this.setTopAndBottomOffset(n2);
        if (appBarLayout instanceof SmoothAppBarLayout && ((SmoothAppBarLayout)appBarLayout).mHaveChildWithInterpolator && this.mCoordinatorLayout != null) {
            this.mCoordinatorLayout.dispatchDependentViewsChanged((View)appBarLayout);
        }
        this.dispatchOffsetUpdates(appBarLayout, n2);
        this.mCurrentOffset = n2;
        appBarLayout.setTag(R.id.tag_current_offset, (Object)this.mCurrentOffset);
    }
}

