/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.Pair;
import de.tavendo.autobahn.NoCopyByteArrayOutputStream;
import de.tavendo.autobahn.Utf8Validator;
import de.tavendo.autobahn.WebSocketException;
import de.tavendo.autobahn.WebSocketFrameHeader;
import de.tavendo.autobahn.WebSocketMessage;
import de.tavendo.autobahn.WebSocketOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;

public class WebSocketReader
extends Thread {
    private static /* synthetic */ int[] $SWITCH_TABLE$de$tavendo$autobahn$WebSocketReader$ReaderState;
    private static final String TAG = WebSocketReader.class.getCanonicalName();
    private final ByteBuffer mApplicationBuffer;
    private WebSocketFrameHeader mFrameHeader;
    private InputStream mInputStream;
    private boolean mInsideMessage = false;
    private int mMessageOpcode;
    private NoCopyByteArrayOutputStream mMessagePayload;
    private final byte[] mNetworkBuffer;
    private final Socket mSocket;
    private ReaderState mState;
    private volatile boolean mStopped = false;
    private Utf8Validator mUTF8Validator = new Utf8Validator();
    private final Handler mWebSocketConnectionHandler;
    private final WebSocketOptions mWebSocketOptions;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ int[] $SWITCH_TABLE$de$tavendo$autobahn$WebSocketReader$ReaderState() {
        int[] nArray = $SWITCH_TABLE$de$tavendo$autobahn$WebSocketReader$ReaderState;
        if (nArray != null) {
            return nArray;
        }
        nArray = new int[ReaderState.values().length];
        try {
            nArray[ReaderState.STATE_CLOSED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderState.STATE_CLOSING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderState.STATE_CONNECTING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReaderState.STATE_OPEN.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$tavendo$autobahn$WebSocketReader$ReaderState = nArray;
        return nArray;
    }

    public WebSocketReader(Handler handler, Socket socket, WebSocketOptions webSocketOptions, String string2) {
        super(string2);
        this.mWebSocketConnectionHandler = handler;
        this.mSocket = socket;
        this.mWebSocketOptions = webSocketOptions;
        this.mNetworkBuffer = new byte[4096];
        this.mApplicationBuffer = ByteBuffer.allocateDirect(webSocketOptions.getMaxFramePayloadSize() + 14);
        this.mMessagePayload = new NoCopyByteArrayOutputStream(webSocketOptions.getMaxMessagePayloadSize());
        this.mFrameHeader = null;
        this.mState = ReaderState.STATE_CONNECTING;
        Log.d((String)TAG, (String)"WebSocket reader created.");
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private boolean consumeData() throws Exception {
        boolean bl2;
        boolean bl3 = bl2 = false;
        int n2 = 0;
        block5: do {
            switch (n2 == 0 ? WebSocketReader.$SWITCH_TABLE$de$tavendo$autobahn$WebSocketReader$ReaderState()[this.mState.ordinal()] : n2) {
                default: {
                    bl3 = bl2;
                    n2 = 1;
                    continue block5;
                }
                case 3: 
                case 4: {
                    bl3 = this.processData();
                }
                case 1: {
                    return bl3;
                }
                case 2: 
            }
            return this.processHandshake();
        } while (true);
        return this.processHandshake();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Pair<Integer, String> parseHTTPStatus() throws UnsupportedEncodingException {
        int n2;
        int n3;
        for (n3 = 4; n3 < this.mApplicationBuffer.position() && this.mApplicationBuffer.get(n3) != 32; ++n3) {
        }
        for (n2 = n3 + 1; n2 < this.mApplicationBuffer.position() && this.mApplicationBuffer.get(n2) != 32; ++n2) {
        }
        int n4 = n3 + 1;
        int n5 = 0;
        n3 = 0;
        while (true) {
            if (n4 + n5 >= n2) break;
            n3 = n3 * 10 + (this.mApplicationBuffer.get(n4 + n5) - 48);
            ++n5;
        }
        n2 = n5 = n2 + 1;
        while (true) {
            if (n2 >= this.mApplicationBuffer.position() || this.mApplicationBuffer.get(n2) == 13) {
                byte[] byArray = new byte[n2 -= n5];
                this.mApplicationBuffer.position(n5);
                this.mApplicationBuffer.get(byArray, 0, n2);
                String string2 = new String(byArray, "UTF-8");
                Log.w((String)TAG, (String)String.format("Status: %d (%s)", n3, string2));
                return new Pair((Object)n3, (Object)string2);
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean processData() throws Exception {
        block57: {
            block60: {
                block55: {
                    block59: {
                        block58: {
                            block56: {
                                block47: {
                                    block46: {
                                        block53: {
                                            block51: {
                                                block52: {
                                                    block44: {
                                                        block45: {
                                                            block50: {
                                                                block49: {
                                                                    block48: {
                                                                        block43: {
                                                                            block42: {
                                                                                var1_1 = 2;
                                                                                var2_2 = false;
                                                                                if (this.mFrameHeader != null) break block47;
                                                                                var3_3 = var2_2;
                                                                                if (this.mApplicationBuffer.position() < 2) ** GOTO lbl103
                                                                                var4_4 = this.mApplicationBuffer.get(0);
                                                                                if ((var4_4 & 128) != 0) {
                                                                                    var5_6 = true;
lbl9:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        var6_7 = (var4_4 & 112) >> 4;
                                                                                        var7_8 = var4_4 & 15;
                                                                                        var4_4 = this.mApplicationBuffer.get(1);
                                                                                        if ((var4_4 & 128) == 0) break block42;
                                                                                        var8_9 = true;
lbl15:
                                                                                        // 2 sources

                                                                                        while (true) {
                                                                                            var9_10 = var4_4 & 127;
                                                                                            if (var6_7 != 0) {
                                                                                                throw new WebSocketException("RSV != 0 and no extension negotiated");
                                                                                            }
                                                                                            break block43;
                                                                                            break;
                                                                                        }
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                var5_6 = false;
                                                                                ** while (true)
                                                                            }
                                                                            var8_9 = false;
                                                                            ** while (true)
                                                                        }
                                                                        if (var8_9) {
                                                                            throw new WebSocketException("masked server frame");
                                                                        }
                                                                        if (var7_8 > 7) {
                                                                            if (!var5_6) {
                                                                                throw new WebSocketException("fragmented control frame");
                                                                            }
                                                                            if (var9_10 > 125) {
                                                                                throw new WebSocketException("control frame with payload length > 125 octets");
                                                                            }
                                                                            if (var7_8 != 8 && var7_8 != 9 && var7_8 != 10) {
                                                                                throw new WebSocketException("control frame using reserved opcode " + var7_8);
                                                                            }
                                                                            if (var7_8 == 8 && var9_10 == 1) {
                                                                                throw new WebSocketException("received close control frame with payload len 1");
                                                                            }
                                                                        } else {
                                                                            if (var7_8 != 0 && var7_8 != 1 && var7_8 != 2) {
                                                                                throw new WebSocketException("data frame using reserved opcode " + var7_8);
                                                                            }
                                                                            if (!this.mInsideMessage && var7_8 == 0) {
                                                                                throw new WebSocketException("received continuation data frame outside fragmented message");
                                                                            }
                                                                            if (this.mInsideMessage && var7_8 != 0) {
                                                                                throw new WebSocketException("received non-continuation data frame while inside fragmented message");
                                                                            }
                                                                        }
                                                                        if (!var8_9) break block48;
                                                                        var4_4 = 4;
lbl46:
                                                                        // 2 sources

                                                                        while (var9_10 < 126) {
                                                                            var4_4 += 2;
lbl48:
                                                                            // 3 sources

                                                                            while (true) {
                                                                                var3_3 = var2_2;
                                                                                if (this.mApplicationBuffer.position() >= var4_4) {
                                                                                    if (var9_10 != 126) break block44;
                                                                                    var10_11 = (this.mApplicationBuffer.get(2) & 255) << 8 | this.mApplicationBuffer.get(3) & 255;
                                                                                    if (var10_11 < 126L) {
                                                                                        throw new WebSocketException("invalid data frame length (not using minimal length encoding)");
                                                                                    }
                                                                                    break block45;
                                                                                }
                                                                                ** GOTO lbl103
                                                                                break;
                                                                            }
                                                                        }
                                                                        break block49;
                                                                    }
                                                                    var4_4 = 0;
                                                                    ** GOTO lbl46
                                                                }
                                                                if (var9_10 != 126) break block50;
                                                                var4_4 += 4;
                                                                ** GOTO lbl48
                                                            }
                                                            if (var9_10 == 127) {
                                                                var4_4 += 10;
                                                                ** continue;
                                                            }
                                                            throw new Exception("logic error");
                                                        }
                                                        var1_1 = 4;
lbl72:
                                                        // 3 sources

                                                        while (var10_11 > (long)this.mWebSocketOptions.getMaxFramePayloadSize()) {
                                                            throw new WebSocketException("frame payload too large");
                                                        }
                                                        break block51;
                                                    }
                                                    if (var9_10 != 127) break block52;
                                                    if ((this.mApplicationBuffer.get(2) & 128) != 0) {
                                                        throw new WebSocketException("invalid data frame length (> 2^63)");
                                                    }
                                                    var10_11 = (this.mApplicationBuffer.get(2) & 255) << 56 | (this.mApplicationBuffer.get(3) & 255) << 48 | (this.mApplicationBuffer.get(4) & 255) << 40 | (this.mApplicationBuffer.get(5) & 255) << 32 | (this.mApplicationBuffer.get(6) & 255) << 24 | (this.mApplicationBuffer.get(7) & 255) << 16 | (this.mApplicationBuffer.get(8) & 255) << 8 | this.mApplicationBuffer.get(9) & 255;
                                                    if (var10_11 < 65536L) {
                                                        throw new WebSocketException("invalid data frame length (not using minimal length encoding)");
                                                    }
                                                    var1_1 = 10;
                                                    ** GOTO lbl72
                                                }
                                                var10_11 = var9_10;
                                                ** GOTO lbl72
                                            }
                                            this.mFrameHeader = new WebSocketFrameHeader();
                                            this.mFrameHeader.setOpcode(var7_8);
                                            this.mFrameHeader.setFin(var5_6);
                                            this.mFrameHeader.setReserved(var6_7);
                                            this.mFrameHeader.setPayloadLength((int)var10_11);
                                            this.mFrameHeader.setHeaderLength(var4_4);
                                            this.mFrameHeader.setTotalLen(this.mFrameHeader.getHeaderLength() + this.mFrameHeader.getPayloadLength());
                                            if (!var8_9) break block53;
                                            var12_12 = new byte[4];
                                            var4_4 = 0;
                                            while (true) {
                                                block54: {
                                                    if (var4_4 < 4) break block54;
                                                    this.mFrameHeader.setMask(var12_12);
lbl101:
                                                    // 2 sources

                                                    while (this.mFrameHeader.getPayloadLength() != 0 && this.mApplicationBuffer.position() < this.mFrameHeader.getTotalLength()) {
                                                        var3_3 = var2_2;
lbl103:
                                                        // 7 sources

                                                        return var3_3;
                                                    }
                                                    break block46;
                                                }
                                                var12_12[var1_1] = (byte)(this.mApplicationBuffer.get(var1_1 + var4_4) & 255);
                                                ++var4_4;
                                            }
                                        }
                                        this.mFrameHeader.setMask(null);
                                        ** GOTO lbl101
                                    }
                                    var3_3 = true;
                                    ** GOTO lbl103
                                }
                                var3_3 = var2_2;
                                if (this.mApplicationBuffer.position() < this.mFrameHeader.getTotalLength()) ** GOTO lbl103
                                var12_13 = null;
                                var4_5 = this.mApplicationBuffer.position();
                                if (this.mFrameHeader.getPayloadLength() > 0) {
                                    var12_13 = new byte[this.mFrameHeader.getPayloadLength()];
                                    this.mApplicationBuffer.position(this.mFrameHeader.getHeaderLength());
                                    this.mApplicationBuffer.get((byte[])var12_13, 0, this.mFrameHeader.getPayloadLength());
                                }
                                this.mApplicationBuffer.position(this.mFrameHeader.getTotalLength());
                                this.mApplicationBuffer.limit(var4_5);
                                this.mApplicationBuffer.compact();
                                if (this.mFrameHeader.getOpcode() <= 7) break block55;
                                if (this.mFrameHeader.getOpcode() != 8) break block56;
                                var4_5 = 1005;
                                if (this.mFrameHeader.getPayloadLength() < 2) break block57;
                                var1_1 = (var12_13[0] & 255) * 256 + (var12_13[1] & 255);
                                if (var1_1 < 1000 || var1_1 >= 1000 && var1_1 <= 2999 && var1_1 != 1000 && var1_1 != 1001 && var1_1 != 1002 && var1_1 != 1003 && var1_1 != 1007 && var1_1 != 1008 && var1_1 != 1009 && var1_1 != 1010 && var1_1 != 1011 || var1_1 >= 5000) {
                                    throw new WebSocketException("invalid close code " + var1_1);
                                }
                                var4_5 = var1_1;
                                if (this.mFrameHeader.getPayloadLength() <= 2) break block57;
                                var13_14 = new byte[this.mFrameHeader.getPayloadLength() - 2];
                                System.arraycopy(var12_13, 2, var13_14, 0, this.mFrameHeader.getPayloadLength() - 2);
                                var12_13 = new Utf8Validator();
                                var12_13.validate(var13_14);
                                if (!var12_13.isValid()) {
                                    throw new WebSocketException("invalid close reasons (not UTF-8)");
                                }
                                var12_13 = new String(var13_14, "UTF-8");
                                var4_5 = var1_1;
lbl151:
                                // 2 sources

                                while (true) {
                                    this.onClose(var4_5, (String)var12_13);
lbl153:
                                    // 5 sources

                                    while (true) {
                                        this.mFrameHeader = null;
                                        var3_3 = var2_2;
                                        if (this.mApplicationBuffer.position() <= 0) ** GOTO lbl103
                                        var3_3 = true;
                                        ** continue;
                                        break;
                                    }
                                    break;
                                }
                            }
                            if (this.mFrameHeader.getOpcode() != 9) break block58;
                            this.onPing((byte[])var12_13);
                            ** GOTO lbl153
                        }
                        if (this.mFrameHeader.getOpcode() != 10) break block59;
                        this.onPong((byte[])var12_13);
                        ** GOTO lbl153
                    }
                    throw new Exception("logic error");
                }
                if (!this.mInsideMessage) {
                    this.mInsideMessage = true;
                    this.mMessageOpcode = this.mFrameHeader.getOpcode();
                    if (this.mMessageOpcode == 1 && this.mWebSocketOptions.getValidateIncomingUtf8()) {
                        this.mUTF8Validator.reset();
                    }
                }
                if (var12_13 != null) {
                    if (this.mMessagePayload.size() + ((byte[])var12_13).length > this.mWebSocketOptions.getMaxMessagePayloadSize()) {
                        throw new WebSocketException("message payload too large");
                    }
                    if (this.mMessageOpcode == 1 && this.mWebSocketOptions.getValidateIncomingUtf8() && !this.mUTF8Validator.validate((byte[])var12_13)) {
                        throw new WebSocketException("invalid UTF-8 in text message payload");
                    }
                    this.mMessagePayload.write((byte[])var12_13);
                }
                if (!this.mFrameHeader.isFin()) ** GOTO lbl153
                if (this.mMessageOpcode != 1) break block60;
                if (this.mWebSocketOptions.getValidateIncomingUtf8() && !this.mUTF8Validator.isValid()) {
                    throw new WebSocketException("UTF-8 text message payload ended within Unicode code point");
                }
                if (this.mWebSocketOptions.getReceiveTextMessagesRaw()) {
                    this.onRawTextMessage(this.mMessagePayload.toByteArray());
lbl187:
                    // 3 sources

                    while (true) {
                        this.mInsideMessage = false;
                        this.mMessagePayload.reset();
                        ** continue;
                        break;
                    }
                }
                this.onTextMessage(new String(this.mMessagePayload.toByteArray(), "UTF-8"));
                ** GOTO lbl187
            }
            if (this.mMessageOpcode == 2) {
                this.onBinaryMessage(this.mMessagePayload.toByteArray());
                ** continue;
            }
            throw new Exception("logic error");
        }
        var12_13 = null;
        ** while (true)
    }

    /*
     * Unable to fully structure code
     */
    private boolean processHandshake() throws UnsupportedEncodingException {
        var1_1 = false;
        var2_2 = false;
        var3_3 = this.mApplicationBuffer.position() - 4;
        while (true) {
            block8: {
                if (var3_3 < 0) lbl-1000:
                // 2 sources

                {
                    return var2_2;
                }
                if (this.mApplicationBuffer.get(var3_3 + 0) != 13 || this.mApplicationBuffer.get(var3_3 + 1) != 10 || this.mApplicationBuffer.get(var3_3 + 2) != 13 || this.mApplicationBuffer.get(var3_3 + 3) != 10) break block8;
                var4_4 = this.mApplicationBuffer.position();
                if (this.mApplicationBuffer.get(0) != 72 || this.mApplicationBuffer.get(1) != 84 || this.mApplicationBuffer.get(2) != 84 || this.mApplicationBuffer.get(3) != 80) break;
                var5_5 = this.parseHTTPStatus();
                if ((Integer)var5_5.first < 300) break;
                this.notify(new WebSocketMessage.ServerError((Integer)var5_5.first, (String)var5_5.second));
                var6_6 = true;
lbl15:
                // 2 sources

                while (true) {
                    block7: {
                        block9: {
                            block10: {
                                this.mApplicationBuffer.position(var3_3 + 4);
                                this.mApplicationBuffer.limit(var4_4);
                                this.mApplicationBuffer.compact();
                                if (var6_6) break block9;
                                if (this.mApplicationBuffer.position() <= 0) break block10;
                                var2_2 = true;
lbl25:
                                // 2 sources

                                while (true) {
                                    this.mState = ReaderState.STATE_OPEN;
lbl27:
                                    // 2 sources

                                    while (var6_6) lbl-1000:
                                    // 2 sources

                                    {
                                        while (true) {
                                            this.onHandshake(var1_1);
                                            ** continue;
                                            break;
                                        }
lbl31:
                                        // 1 sources

                                        ** GOTO lbl-1000
                                    }
                                    break block7;
                                    break;
                                }
                            }
                            var2_2 = false;
                            ** continue;
                        }
                        this.mState = ReaderState.STATE_CLOSED;
                        this.mStopped = true;
                        var2_2 = true;
                        ** GOTO lbl27
                    }
                    var1_1 = true;
                    ** continue;
                    break;
                }
            }
            --var3_3;
        }
        var6_6 = false;
        ** while (true)
    }

    protected void notify(Object object) {
        Message message = this.mWebSocketConnectionHandler.obtainMessage();
        message.obj = object;
        this.mWebSocketConnectionHandler.sendMessage(message);
    }

    protected void onBinaryMessage(byte[] byArray) {
        this.notify(new WebSocketMessage.BinaryMessage(byArray));
    }

    protected void onClose(int n2, String string2) {
        this.notify(new WebSocketMessage.Close(n2, string2));
    }

    protected void onHandshake(boolean bl2) {
        this.notify(new WebSocketMessage.ServerHandshake(bl2));
    }

    protected void onPing(byte[] byArray) {
        this.notify(new WebSocketMessage.Ping(byArray));
    }

    protected void onPong(byte[] byArray) {
        this.notify(new WebSocketMessage.Pong(byArray));
    }

    protected void onRawTextMessage(byte[] byArray) {
        this.notify(new WebSocketMessage.RawTextMessage(byArray));
    }

    protected void onTextMessage(String string2) {
        this.notify(new WebSocketMessage.TextMessage(string2));
    }

    public void quit() {
        this.mStopped = true;
        Log.d((String)TAG, (String)"quit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object;
        synchronized (this) {
            this.notifyAll();
        }
        try {
            object = this.mSocket.getInputStream();
            this.mInputStream = object;
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.getLocalizedMessage());
            return;
        }
        Log.d((String)TAG, (String)"WebSocker reader running.");
        this.mApplicationBuffer.clear();
        while (true) {
            if (this.mStopped) {
                Log.d((String)TAG, (String)"WebSocket reader ended.");
                return;
            }
            try {
                int n2 = this.mInputStream.read(this.mNetworkBuffer);
                if (n2 > 0) {
                    this.mApplicationBuffer.put(this.mNetworkBuffer, 0, n2);
                    while (this.consumeData()) {
                    }
                    continue;
                }
                if (n2 == -1) {
                    Log.d((String)TAG, (String)"run() : ConnectionLost");
                    object = new WebSocketMessage.ConnectionLost();
                    this.notify(object);
                    this.mStopped = true;
                    continue;
                }
                Log.e((String)TAG, (String)"WebSocketReader read() failed.");
                continue;
            }
            catch (WebSocketException webSocketException) {
                Log.d((String)TAG, (String)("run() : WebSocketException (" + webSocketException.toString() + ")"));
                this.notify(new WebSocketMessage.ProtocolViolation(webSocketException));
                continue;
            }
            catch (SocketException socketException) {
                Log.d((String)TAG, (String)("run() : SocketException (" + socketException.toString() + ")"));
                this.notify(new WebSocketMessage.ConnectionLost());
                continue;
            }
            catch (IOException iOException) {
                Log.d((String)TAG, (String)("run() : IOException (" + iOException.toString() + ")"));
                this.notify(new WebSocketMessage.ConnectionLost());
                continue;
            }
            catch (Exception exception) {
                Log.d((String)TAG, (String)("run() : Exception (" + exception.toString() + ")"));
                this.notify(new WebSocketMessage.Error(exception));
                continue;
            }
            break;
        }
    }

    private static enum ReaderState {
        STATE_CLOSED,
        STATE_CONNECTING,
        STATE_CLOSING,
        STATE_OPEN;

    }
}

