/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

public class WebSocketOptions {
    private boolean mMaskClientFrames;
    private int mMaxFramePayloadSize;
    private int mMaxMessagePayloadSize;
    private boolean mReceiveTextMessagesRaw;
    private int mReconnectInterval;
    private int mSocketConnectTimeout;
    private int mSocketReceiveTimeout;
    private boolean mTcpNoDelay;
    private boolean mValidateIncomingUtf8;

    public WebSocketOptions() {
        this.mMaxFramePayloadSize = 131072;
        this.mMaxMessagePayloadSize = 131072;
        this.mReceiveTextMessagesRaw = false;
        this.mTcpNoDelay = true;
        this.mSocketReceiveTimeout = 200;
        this.mSocketConnectTimeout = 6000;
        this.mValidateIncomingUtf8 = true;
        this.mMaskClientFrames = true;
        this.mReconnectInterval = 0;
    }

    public WebSocketOptions(WebSocketOptions webSocketOptions) {
        this.mMaxFramePayloadSize = webSocketOptions.mMaxFramePayloadSize;
        this.mMaxMessagePayloadSize = webSocketOptions.mMaxMessagePayloadSize;
        this.mReceiveTextMessagesRaw = webSocketOptions.mReceiveTextMessagesRaw;
        this.mTcpNoDelay = webSocketOptions.mTcpNoDelay;
        this.mSocketReceiveTimeout = webSocketOptions.mSocketReceiveTimeout;
        this.mSocketConnectTimeout = webSocketOptions.mSocketConnectTimeout;
        this.mValidateIncomingUtf8 = webSocketOptions.mValidateIncomingUtf8;
        this.mMaskClientFrames = webSocketOptions.mMaskClientFrames;
        this.mReconnectInterval = webSocketOptions.mReconnectInterval;
    }

    public boolean getMaskClientFrames() {
        return this.mMaskClientFrames;
    }

    public int getMaxFramePayloadSize() {
        return this.mMaxFramePayloadSize;
    }

    public int getMaxMessagePayloadSize() {
        return this.mMaxMessagePayloadSize;
    }

    public boolean getReceiveTextMessagesRaw() {
        return this.mReceiveTextMessagesRaw;
    }

    public int getReconnectInterval() {
        return this.mReconnectInterval;
    }

    public int getSocketConnectTimeout() {
        return this.mSocketConnectTimeout;
    }

    public int getSocketReceiveTimeout() {
        return this.mSocketReceiveTimeout;
    }

    public boolean getTcpNoDelay() {
        return this.mTcpNoDelay;
    }

    public boolean getValidateIncomingUtf8() {
        return this.mValidateIncomingUtf8;
    }

    public void setMaskClientFrames(boolean bl2) {
        this.mMaskClientFrames = bl2;
    }

    public void setMaxFramePayloadSize(int n2) {
        if (n2 > 0) {
            this.mMaxFramePayloadSize = n2;
            if (this.mMaxMessagePayloadSize < this.mMaxFramePayloadSize) {
                this.mMaxMessagePayloadSize = this.mMaxFramePayloadSize;
            }
        }
    }

    public void setMaxMessagePayloadSize(int n2) {
        if (n2 > 0) {
            this.mMaxMessagePayloadSize = n2;
            if (this.mMaxMessagePayloadSize < this.mMaxFramePayloadSize) {
                this.mMaxFramePayloadSize = this.mMaxMessagePayloadSize;
            }
        }
    }

    public void setReceiveTextMessagesRaw(boolean bl2) {
        this.mReceiveTextMessagesRaw = bl2;
    }

    public void setReconnectInterval(int n2) {
        this.mReconnectInterval = n2;
    }

    public void setSocketConnectTimeout(int n2) {
        if (n2 >= 0) {
            this.mSocketConnectTimeout = n2;
        }
    }

    public void setSocketReceiveTimeout(int n2) {
        if (n2 >= 0) {
            this.mSocketReceiveTimeout = n2;
        }
    }

    public void setTcpNoDelay(boolean bl2) {
        this.mTcpNoDelay = bl2;
    }

    public void setValidateIncomingUtf8(boolean bl2) {
        this.mValidateIncomingUtf8 = bl2;
    }
}

