/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer mBuffer;
    private final int mGrowSize;
    private final int mInitialSize;

    public ByteBufferOutputStream() {
        this(131072, 65536);
    }

    public ByteBufferOutputStream(int n2, int n3) {
        this.mInitialSize = n2;
        this.mGrowSize = n3;
        this.mBuffer = ByteBuffer.allocateDirect(this.mInitialSize);
        this.mBuffer.clear();
    }

    public Buffer clear() {
        return this.mBuffer.clear();
    }

    public void crlf() throws IOException {
        synchronized (this) {
            this.write(13);
            this.write(10);
            return;
        }
    }

    public void expand(int n2) {
        synchronized (this) {
            if (n2 > this.mBuffer.capacity()) {
                ByteBuffer byteBuffer = this.mBuffer;
                int n3 = this.mBuffer.position();
                this.mBuffer = ByteBuffer.allocateDirect((n2 / this.mGrowSize + 1) * this.mGrowSize);
                byteBuffer.clear();
                this.mBuffer.clear();
                this.mBuffer.put(byteBuffer);
                this.mBuffer.position(n3);
            }
            return;
        }
    }

    public Buffer flip() {
        return this.mBuffer.flip();
    }

    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public int remaining() {
        return this.mBuffer.remaining();
    }

    @Override
    public void write(int n2) throws IOException {
        synchronized (this) {
            if (this.mBuffer.position() + 1 > this.mBuffer.capacity()) {
                this.expand(this.mBuffer.capacity() + 1);
            }
            this.mBuffer.put((byte)n2);
            return;
        }
    }

    public void write(String string2) throws IOException {
        synchronized (this) {
            this.write(string2.getBytes("UTF-8"));
            return;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        synchronized (this) {
            this.write(byArray, 0, byArray.length);
            return;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        synchronized (this) {
            if (this.mBuffer.position() + n3 > this.mBuffer.capacity()) {
                this.expand(this.mBuffer.capacity() + n3);
            }
            this.mBuffer.put(byArray, n2, n3);
            return;
        }
    }
}

