/*
 * Decompiled with CFR 0.152.
 */
package com.yintong.secure.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.yintong.secure.f.g;
import com.yintong.secure.widget.Cell;
import com.yintong.secure.widget.LockPatternUtils;
import com.yintong.secure.widget.LockPatternView;
import com.yintong.secure.widget.LockPatternView$DisplayMode;
import com.yintong.secure.widget.LockPatternView$SavedState;
import java.util.ArrayList;
import java.util.List;

public class LockPatternView
extends View {
    private static final int MILLIS_PER_CIRCLE_ANIMATING = 700;
    private static final boolean PROFILE_DRAWING = false;
    static final int STATUS_BAR_HEIGHT = 25;
    private long mAnimatingPeriodStart;
    private Bitmap mBitmapBtnDefault;
    private Bitmap mBitmapBtnTouched;
    private int mBitmapHeight;
    private int mBitmapWidth;
    private final Path mCurrentPath;
    private float mDiameterFactor = 0.5f;
    private boolean mDrawingProfilingStarted = false;
    private float mHitFactor = 0.6f;
    private float mInProgressX = -1.0f;
    private float mInProgressY = -1.0f;
    private boolean mInStealthMode = false;
    private boolean mInputEnabled = true;
    private final Rect mInvalidate;
    private OnPatternListener mOnPatternListener;
    private Paint mPaint = new Paint();
    private Paint mPathPaint = new Paint();
    private ArrayList mPattern = new ArrayList(9);
    private LockPatternView$DisplayMode mPatternDisplayMode;
    private boolean[][] mPatternDrawLookup = new boolean[3][3];
    private boolean mPatternInProgress = true;
    private float mSquareHeight;
    private float mSquareWidth;
    private boolean mTactileFeedbackEnabled = true;
    private float pathStrokeWidth = 20.0f;

    public LockPatternView(Context context) {
        this(context, null);
    }

    public LockPatternView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mPatternDisplayMode = LockPatternView$DisplayMode.Correct;
        this.mCurrentPath = new Path();
        this.mInvalidate = new Rect();
        this.setClickable(true);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mPathPaint.setColor(-1426173952);
        this.mPathPaint.setAlpha(128);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPathPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mBitmapBtnDefault = g.f((Context)context, (String)"ll_stand_pattern_grid_normal");
        this.mBitmapBtnTouched = g.f((Context)context, (String)"ll_stand_pattern_grid_touch");
        this.mBitmapWidth = this.mBitmapBtnDefault.getWidth();
        this.mBitmapHeight = this.mBitmapBtnDefault.getHeight();
    }

    private void addCellToPattern(Cell cell) {
        this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        this.mPattern.add(cell);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCellAdded((List)this.mPattern);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cell checkForNewHit(float f2, float f3) {
        Cell cell = null;
        int n2 = this.getRowHit(f3);
        if (n2 < 0) {
            return cell;
        }
        int n3 = this.getColumnHit(f2);
        Cell cell2 = cell;
        if (n3 < 0) return cell2;
        cell2 = cell;
        if (this.mPatternDrawLookup[n2][n3]) return cell2;
        return Cell.of(n2, n3);
    }

    private void clearPatternDrawLookup() {
        int n2 = 0;
        block0: while (n2 < 3) {
            int n3 = 0;
            while (true) {
                if (n3 >= 3) {
                    ++n2;
                    continue block0;
                }
                this.mPatternDrawLookup[n2][n3] = false;
                ++n3;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Cell detectAndAddHit(float f2, float f3) {
        Cell cell = null;
        Cell cell2 = null;
        int n2 = 1;
        Cell cell3 = this.checkForNewHit(f2, f3);
        if (cell3 == null) return cell;
        ArrayList arrayList = this.mPattern;
        cell = cell2;
        if (!arrayList.isEmpty()) {
            cell = (Cell)arrayList.get(arrayList.size() - 1);
            int n3 = cell3.row - cell.row;
            int n4 = cell3.column - cell.column;
            int n5 = cell.row;
            int n6 = cell.column;
            int n7 = n5;
            if (Math.abs(n3) == 2) {
                n7 = n5;
                if (Math.abs(n4) != 1) {
                    n5 = cell.row;
                    n7 = n3 > 0 ? 1 : -1;
                    n7 += n5;
                }
            }
            if (Math.abs(n4) == 2 && Math.abs(n3) != 1) {
                n6 = cell.column;
                if (n4 <= 0) {
                    n2 = -1;
                }
                n2 = n6 + n2;
            } else {
                n2 = n6;
            }
            cell = Cell.of(n7, n2);
        }
        if (cell != null && !this.mPatternDrawLookup[cell.row][cell.column]) {
            this.addCellToPattern(cell);
        }
        this.addCellToPattern(cell3);
        return cell3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawCircle(Canvas canvas, int n2, int n3, boolean bl2) {
        Bitmap bitmap;
        if (!bl2 || this.mInStealthMode && this.mPatternDisplayMode != LockPatternView$DisplayMode.Wrong) {
            bitmap = this.mBitmapBtnDefault;
        } else if (this.mPatternInProgress) {
            bitmap = this.mBitmapBtnTouched;
        } else if (this.mPatternDisplayMode == LockPatternView$DisplayMode.Wrong) {
            bitmap = this.mBitmapBtnTouched;
        } else {
            if (this.mPatternDisplayMode != LockPatternView$DisplayMode.Correct && this.mPatternDisplayMode != LockPatternView$DisplayMode.Animate) {
                throw new IllegalStateException("unknown display mode " + (Object)((Object)this.mPatternDisplayMode));
            }
            bitmap = this.mBitmapBtnTouched;
        }
        int n4 = this.mBitmapWidth;
        int n5 = this.mBitmapHeight;
        float f2 = this.mSquareWidth;
        float f3 = this.mSquareHeight;
        n4 = (int)((f2 - (float)n4) / 2.0f);
        n5 = (int)((f3 - (float)n5) / 2.0f);
        canvas.drawBitmap(bitmap, (float)(n4 + n2), (float)(n5 + n3), this.mPaint);
    }

    private Bitmap getBitmapFor(int n2) {
        return BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)n2);
    }

    private float getCenterXForColumn(int n2) {
        return (float)this.getPaddingLeft() + (float)n2 * this.mSquareWidth + this.mSquareWidth / 2.0f;
    }

    private float getCenterYForRow(int n2) {
        return (float)this.getPaddingTop() + (float)n2 * this.mSquareHeight + this.mSquareHeight / 2.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getColumnHit(float f2) {
        float f3 = this.mSquareWidth;
        float f4 = f3 * this.mHitFactor;
        float f5 = this.getPaddingLeft();
        float f6 = (f3 - f4) / 2.0f;
        int n2 = 0;
        while (n2 < 3) {
            float f7 = (float)n2 * f3 + (f6 + f5);
            if (f2 >= f7) {
                int n3 = n2;
                if (f2 <= f7 + f4) return n3;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getRowHit(float f2) {
        float f3 = this.mSquareHeight;
        float f4 = f3 * this.mHitFactor;
        float f5 = this.getPaddingTop();
        float f6 = (f3 - f4) / 2.0f;
        int n2 = 0;
        while (n2 < 3) {
            float f7 = (float)n2 * f3 + (f6 + f5);
            if (f2 >= f7) {
                int n3 = n2;
                if (f2 <= f7 + f4) return n3;
            }
            ++n2;
        }
        return -1;
    }

    private void resetPattern() {
        this.mPattern.clear();
        this.clearPatternDrawLookup();
        this.mPatternDisplayMode = LockPatternView$DisplayMode.Correct;
        this.invalidate();
    }

    public void clearPattern() {
        this.resetPattern();
    }

    public void disableInput() {
        this.mInputEnabled = false;
    }

    public void enableInput() {
        this.mInputEnabled = true;
    }

    public boolean isInStealthMode() {
        return this.mInStealthMode;
    }

    public boolean isTactileFeedbackEnabled() {
        return this.mTactileFeedbackEnabled;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        float f2;
        float f3;
        float f4;
        Cell cell;
        float f5;
        int n2;
        int n3;
        int n4;
        ArrayList arrayList = this.mPattern;
        int n5 = arrayList.size();
        boolean[][] blArray = this.mPatternDrawLookup;
        if (this.mPatternDisplayMode == LockPatternView$DisplayMode.Animate) {
            n4 = (int)(SystemClock.elapsedRealtime() - this.mAnimatingPeriodStart) % ((n5 + 1) * 700);
            n3 = n4 / 700;
            this.clearPatternDrawLookup();
            n2 = 0;
            while (true) {
                if (n2 >= n3) {
                    n2 = n3 > 0 && n3 < n5 ? 1 : 0;
                    if (n2 != 0) {
                        f5 = (float)(n4 % 700) / 700.0f;
                        cell = (Cell)arrayList.get(n3 - 1);
                        f4 = this.getCenterXForColumn(cell.column);
                        float f6 = this.getCenterYForRow(cell.row);
                        cell = (Cell)arrayList.get(n3);
                        f3 = this.getCenterXForColumn(cell.column);
                        f2 = this.getCenterYForRow(cell.row);
                        this.mInProgressX = f4 + (f3 - f4) * f5;
                        this.mInProgressY = (f2 - f6) * f5 + f6;
                    }
                    this.invalidate();
                    break;
                }
                cell = (Cell)arrayList.get(n2);
                blArray[cell.getRow()][cell.getColumn()] = true;
                ++n2;
            }
        }
        f4 = this.mSquareWidth;
        f5 = this.mSquareHeight;
        f2 = this.mDiameterFactor;
        this.mPathPaint.setStrokeWidth(this.pathStrokeWidth);
        Path path = this.mCurrentPath;
        path.rewind();
        int n6 = this.getPaddingTop();
        n4 = this.getPaddingLeft();
        n2 = 0;
        block1: while (true) {
            block9: {
                if (n2 < 3) break block9;
                boolean bl2 = true;
                while (true) {
                    block14: {
                        block13: {
                            block11: {
                                block12: {
                                    block10: {
                                        if (!bl2 || (bl2 = false)) break block10;
                                        n2 = this.mInStealthMode && this.mPatternDisplayMode != LockPatternView$DisplayMode.Wrong ? 0 : 1;
                                        if (n2 == 0) break block11;
                                        n2 = 0;
                                        n3 = 0;
                                    }
                                    if (n3 >= n5) break block12;
                                    cell = (Cell)arrayList.get(n3);
                                    if (!blArray[cell.row][cell.column]) break block12;
                                    n2 = 1;
                                    f5 = this.getCenterXForColumn(cell.column);
                                    f4 = this.getCenterYForRow(cell.row);
                                    if (n3 != 0) break block13;
                                    path.moveTo(f5, f4);
                                    break block14;
                                }
                                if ((this.mPatternInProgress || this.mPatternDisplayMode == LockPatternView$DisplayMode.Animate) && n2 != 0) {
                                    path.lineTo(this.mInProgressX, this.mInProgressY);
                                }
                                canvas.drawPath(path, this.mPathPaint);
                            }
                            boolean bl3 = (this.mPaint.getFlags() & 2) != 0;
                            this.mPaint.setFilterBitmap(true);
                            this.mPaint.setFilterBitmap(bl3);
                            return;
                        }
                        path.lineTo(f5, f4);
                    }
                    ++n3;
                }
            }
            f3 = n6;
            f2 = n2;
            n3 = 0;
            while (true) {
                if (n3 >= 3) {
                    ++n2;
                    continue block1;
                }
                this.drawCircle(canvas, (int)((float)n4 + (float)n3 * f4), (int)(f2 * f5 + f3), blArray[n2][n3]);
                ++n3;
            }
            break;
        }
    }

    protected void onMeasure(int n2, int n3) {
        n2 = Math.min(View.MeasureSpec.getSize((int)n2), View.MeasureSpec.getSize((int)n3));
        this.setMeasuredDimension(n2, n2);
    }

    protected void onRestoreInstanceState(Parcelable object) {
        object = (LockPatternView$SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.setPattern(LockPatternView$DisplayMode.Correct, LockPatternUtils.stringToPattern(((LockPatternView$SavedState)((Object)object)).a()));
        this.mPatternDisplayMode = LockPatternView$DisplayMode.values()[((LockPatternView$SavedState)((Object)object)).b()];
        this.mInputEnabled = ((LockPatternView$SavedState)((Object)object)).c();
        this.mInStealthMode = ((LockPatternView$SavedState)((Object)object)).d();
        this.mTactileFeedbackEnabled = ((LockPatternView$SavedState)((Object)object)).e();
    }

    protected Parcelable onSaveInstanceState() {
        return new LockPatternView$SavedState(super.onSaveInstanceState(), LockPatternUtils.patternToString(this.mPattern), this.mPatternDisplayMode.ordinal(), this.mInputEnabled, this.mInStealthMode, this.mTactileFeedbackEnabled, null);
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        this.mSquareWidth = (float)(n2 - this.getPaddingLeft() - this.getPaddingRight()) / 3.0f;
        this.mSquareHeight = (float)(n3 - this.getPaddingTop() - this.getPaddingBottom()) / 3.0f;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        if (!this.mInputEnabled || !this.isEnabled()) {
            var2_2 = false;
lbl3:
            // 6 sources

            return var2_2;
        }
        var3_3 = var1_1 /* !! */ .getX();
        var4_4 = var1_1 /* !! */ .getY();
        switch (var1_1 /* !! */ .getAction()) {
            default: {
                var2_2 = false;
                ** GOTO lbl3
            }
            case 0: {
                this.resetPattern();
                var1_1 /* !! */  = this.detectAndAddHit(var3_3, var4_4);
                if (var1_1 /* !! */  == null || this.mOnPatternListener == null) ** GOTO lbl29
                this.mPatternInProgress = true;
                this.mPatternDisplayMode = LockPatternView$DisplayMode.Correct;
                this.mOnPatternListener.onPatternStart();
lbl18:
                // 3 sources

                while (true) {
                    if (var1_1 /* !! */  != null) {
                        var5_5 = this.getCenterXForColumn(var1_1 /* !! */ .column);
                        var6_7 = this.getCenterYForRow(var1_1 /* !! */ .row);
                        var7_9 = this.mSquareWidth / 2.0f;
                        var8_11 = this.mSquareHeight / 2.0f;
                        this.invalidate((int)(var5_5 - var7_9), (int)(var6_7 - var8_11), (int)(var5_5 + var7_9), (int)(var6_7 + var8_11));
                    }
                    this.mInProgressX = var3_3;
                    this.mInProgressY = var4_4;
                    var2_2 = true;
                    ** GOTO lbl3
                    break;
                }
lbl29:
                // 1 sources

                if (this.mOnPatternListener == null) ** GOTO lbl18
                this.mPatternInProgress = false;
                this.mOnPatternListener.onPatternCleared();
                ** continue;
            }
            case 1: {
                if (!this.mPattern.isEmpty() && this.mOnPatternListener != null) {
                    this.mPatternInProgress = false;
                    this.mOnPatternListener.onPatternDetected((List)this.mPattern);
                    this.invalidate();
                }
                var2_2 = true;
                ** GOTO lbl3
            }
            case 2: {
                var9_13 = this.mPattern.size();
                var1_1 /* !! */  = this.detectAndAddHit(var3_3, var4_4);
                var10_14 = this.mPattern.size();
                if (var1_1 /* !! */  != null && this.mOnPatternListener != null && var10_14 == 1) {
                    this.mPatternInProgress = true;
                    this.mOnPatternListener.onPatternStart();
                }
                if (!(Math.abs(var3_3 - this.mInProgressX) + Math.abs(var4_4 - this.mInProgressY) > this.mSquareWidth * 0.01f)) ** GOTO lbl97
                var8_12 = this.mInProgressX;
                var6_8 = this.mInProgressY;
                this.mInProgressX = var3_3;
                this.mInProgressY = var4_4;
                if (!this.mPatternInProgress || var10_14 <= 0) ** GOTO lbl114
                var11_15 = this.mPattern;
                var12_16 = this.mSquareWidth * this.mDiameterFactor * 0.5f;
                var13_17 = (Cell)var11_15.get(var10_14 - 1);
                var7_10 = this.getCenterXForColumn(var13_17.column);
                var5_6 = this.getCenterYForRow(var13_17.row);
                var13_17 = this.mInvalidate;
                if (!(var7_10 < var3_3)) ** GOTO lbl101
                var14_18 = var7_10;
lbl61:
                // 2 sources

                while (var5_6 < var4_4) {
                    var15_19 = var4_4;
                    var4_4 = var5_6;
lbl64:
                    // 2 sources

                    while (true) {
                        var13_17.set((int)(var14_18 - var12_16), (int)(var4_4 - var12_16), (int)(var3_3 + var12_16), (int)(var15_19 + var12_16));
                        if (var7_10 < var8_12) {
                            var4_4 = var8_12;
                            var8_12 = var7_10;
                            var7_10 = var4_4;
                        }
                        var14_18 = var5_6;
                        var4_4 = var6_8;
                        if (var5_6 < var6_8) {
                            var4_4 = var5_6;
                            var14_18 = var6_8;
                        }
                        var13_17.union((int)(var8_12 - var12_16), (int)(var4_4 - var12_16), (int)(var7_10 + var12_16), (int)(var14_18 + var12_16));
                        if (var1_1 /* !! */  == null) ** GOTO lbl96
                        var7_10 = this.getCenterXForColumn(var1_1 /* !! */ .column);
                        var5_6 = this.getCenterYForRow(var1_1 /* !! */ .row);
                        if (var10_14 < 2) ** GOTO lbl109
                        var1_1 /* !! */  = (Cell)var11_15.get(var10_14 - 1 - (var10_14 - var9_13));
                        var14_18 = this.getCenterXForColumn(var1_1 /* !! */ .column);
                        var4_4 = this.getCenterYForRow(var1_1 /* !! */ .row);
                        var6_8 = var7_10;
                        var8_12 = var14_18;
                        if (var7_10 < var14_18) {
                            var6_8 = var14_18;
                            var8_12 = var7_10;
                        }
                        if (!(var5_6 < var4_4)) ** GOTO lbl106
                        var7_10 = var6_8;
                        var6_8 = var5_6;
                        var5_6 = var4_4;
lbl92:
                        // 3 sources

                        while (true) {
                            var14_18 = this.mSquareWidth / 2.0f;
                            var4_4 = this.mSquareHeight / 2.0f;
                            var13_17.set((int)(var8_12 - var14_18), (int)(var6_8 - var4_4), (int)(var7_10 + var14_18), (int)(var5_6 + var4_4));
lbl96:
                            // 2 sources

                            this.invalidate((Rect)var13_17);
lbl97:
                            // 3 sources

                            while (true) {
                                var2_2 = true;
                                ** GOTO lbl3
                                break;
                            }
                            break;
                        }
                        break;
                    }
                }
                ** GOTO lbl104
lbl101:
                // 1 sources

                var14_18 = var3_3;
                var3_3 = var7_10;
                ** GOTO lbl61
lbl104:
                // 1 sources

                var15_19 = var5_6;
                ** continue;
lbl106:
                // 1 sources

                var7_10 = var6_8;
                var6_8 = var4_4;
                ** GOTO lbl92
lbl109:
                // 1 sources

                var4_4 = var5_6;
                var8_12 = var7_10;
                var6_8 = var5_6;
                var5_6 = var4_4;
                ** continue;
lbl114:
                // 1 sources

                this.invalidate();
                ** continue;
            }
            case 3: 
        }
        this.resetPattern();
        if (this.mOnPatternListener != null) {
            this.mPatternInProgress = false;
            this.mOnPatternListener.onPatternCleared();
        }
        var2_2 = true;
        ** while (true)
    }

    public void setDisplayMode(LockPatternView$DisplayMode object) {
        this.mPatternDisplayMode = object;
        if (object == LockPatternView$DisplayMode.Animate) {
            if (this.mPattern.size() == 0) {
                throw new IllegalStateException("you must have a pattern to animate if you want to set the display mode to animate");
            }
            this.mAnimatingPeriodStart = SystemClock.elapsedRealtime();
            object = (Cell)this.mPattern.get(0);
            this.mInProgressX = this.getCenterXForColumn(((Cell)object).getColumn());
            this.mInProgressY = this.getCenterYForRow(((Cell)object).getRow());
            this.clearPatternDrawLookup();
        }
        this.invalidate();
    }

    public void setInStealthMode(boolean bl2) {
        this.mInStealthMode = bl2;
    }

    public void setOnPatternListener(OnPatternListener onPatternListener) {
        this.mOnPatternListener = onPatternListener;
    }

    public void setPattern(LockPatternView$DisplayMode lockPatternView$DisplayMode, List object) {
        this.mPattern.clear();
        this.mPattern.addAll(object);
        this.clearPatternDrawLookup();
        object = object.iterator();
        while (true) {
            if (!object.hasNext()) {
                this.setDisplayMode(lockPatternView$DisplayMode);
                return;
            }
            Cell cell = (Cell)object.next();
            this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        }
    }

    public void setTactileFeedbackEnabled(boolean bl2) {
        this.mTactileFeedbackEnabled = bl2;
    }
}

