/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

@Descriptor(tags={3})
public class ESDescriptor
extends BaseDescriptor {
    private static Logger log = Logger.getLogger(ESDescriptor.class.getName());
    int URLFlag;
    int URLLength = 0;
    String URLString;
    DecoderConfigDescriptor decoderConfigDescriptor;
    int dependsOnEsId;
    int esId;
    int oCREsId;
    int oCRstreamFlag;
    List<BaseDescriptor> otherDescriptors = new ArrayList<BaseDescriptor>();
    int remoteODFlag;
    SLConfigDescriptor slConfigDescriptor;
    int streamDependenceFlag;
    int streamPriority;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl2 = true;
        if (this == object) {
            return bl2;
        }
        if (object == null) return false;
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (ESDescriptor)object;
        if (this.URLFlag != ((ESDescriptor)object).URLFlag) {
            return false;
        }
        if (this.URLLength != ((ESDescriptor)object).URLLength) {
            return false;
        }
        if (this.dependsOnEsId != ((ESDescriptor)object).dependsOnEsId) {
            return false;
        }
        if (this.esId != ((ESDescriptor)object).esId) {
            return false;
        }
        if (this.oCREsId != ((ESDescriptor)object).oCREsId) {
            return false;
        }
        if (this.oCRstreamFlag != ((ESDescriptor)object).oCRstreamFlag) {
            return false;
        }
        if (this.remoteODFlag != ((ESDescriptor)object).remoteODFlag) {
            return false;
        }
        if (this.streamDependenceFlag != ((ESDescriptor)object).streamDependenceFlag) {
            return false;
        }
        if (this.streamPriority != ((ESDescriptor)object).streamPriority) {
            return false;
        }
        if (this.URLString != null) {
            if (!this.URLString.equals(((ESDescriptor)object).URLString)) {
                return false;
            }
        } else if (((ESDescriptor)object).URLString != null) return false;
        if (this.decoderConfigDescriptor != null) {
            if (!this.decoderConfigDescriptor.equals(((ESDescriptor)object).decoderConfigDescriptor)) {
                return false;
            }
        } else if (((ESDescriptor)object).decoderConfigDescriptor != null) return false;
        if (this.otherDescriptors != null) {
            if (!this.otherDescriptors.equals(((ESDescriptor)object).otherDescriptors)) {
                return false;
            }
        } else if (((ESDescriptor)object).otherDescriptors != null) return false;
        if (this.slConfigDescriptor != null) {
            if (this.slConfigDescriptor.equals(((ESDescriptor)object).slConfigDescriptor)) return bl2;
            return false;
        }
        if (((ESDescriptor)object).slConfigDescriptor == null) return bl2;
        return false;
    }

    public DecoderConfigDescriptor getDecoderConfigDescriptor() {
        return this.decoderConfigDescriptor;
    }

    public int getDependsOnEsId() {
        return this.dependsOnEsId;
    }

    public int getEsId() {
        return this.esId;
    }

    public List<BaseDescriptor> getOtherDescriptors() {
        return this.otherDescriptors;
    }

    public int getRemoteODFlag() {
        return this.remoteODFlag;
    }

    public SLConfigDescriptor getSlConfigDescriptor() {
        return this.slConfigDescriptor;
    }

    public int getStreamDependenceFlag() {
        return this.streamDependenceFlag;
    }

    public int getStreamPriority() {
        return this.streamPriority;
    }

    public int getURLFlag() {
        return this.URLFlag;
    }

    public int getURLLength() {
        return this.URLLength;
    }

    public String getURLString() {
        return this.URLString;
    }

    public int getoCREsId() {
        return this.oCREsId;
    }

    public int getoCRstreamFlag() {
        return this.oCRstreamFlag;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n2 = 0;
        int n3 = this.esId;
        int n4 = this.streamDependenceFlag;
        int n5 = this.URLFlag;
        int n6 = this.oCRstreamFlag;
        int n7 = this.streamPriority;
        int n8 = this.URLLength;
        int n9 = this.URLString != null ? this.URLString.hashCode() : 0;
        int n10 = this.remoteODFlag;
        int n11 = this.dependsOnEsId;
        int n12 = this.oCREsId;
        int n13 = this.decoderConfigDescriptor != null ? this.decoderConfigDescriptor.hashCode() : 0;
        int n14 = this.slConfigDescriptor != null ? this.slConfigDescriptor.hashCode() : 0;
        if (this.otherDescriptors != null) {
            n2 = this.otherDescriptors.hashCode();
        }
        return (n14 + (n13 + ((((n9 + (((((n3 * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31) * 31 + n10) * 31 + n11) * 31 + n12) * 31) * 31) * 31 + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parseDetail(ByteBuffer byteBuffer) throws IOException {
        Integer n2;
        Object object;
        Object object2;
        long l2;
        Object object3;
        int n3 = 0;
        this.esId = IsoTypeReader.readUInt16((ByteBuffer)byteBuffer);
        int n4 = IsoTypeReader.readUInt8((ByteBuffer)byteBuffer);
        this.streamDependenceFlag = n4 >>> 7;
        this.URLFlag = n4 >>> 6 & 1;
        this.oCRstreamFlag = n4 >>> 5 & 1;
        this.streamPriority = n4 & 0x1F;
        if (this.streamDependenceFlag == 1) {
            this.dependsOnEsId = IsoTypeReader.readUInt16((ByteBuffer)byteBuffer);
        }
        if (this.URLFlag == 1) {
            this.URLLength = IsoTypeReader.readUInt8((ByteBuffer)byteBuffer);
            this.URLString = IsoTypeReader.readString((ByteBuffer)byteBuffer, (int)this.URLLength);
        }
        if (this.oCRstreamFlag == 1) {
            this.oCREsId = IsoTypeReader.readUInt16((ByteBuffer)byteBuffer);
        }
        int n5 = this.getSizeBytes();
        n4 = this.streamDependenceFlag == 1 ? 2 : 0;
        int n6 = this.URLFlag == 1 ? this.URLLength + 1 : 0;
        if (this.oCRstreamFlag == 1) {
            n3 = 2;
        }
        n4 = n6 + (n5 + 1 + 2 + 1 + n4) + n3;
        n6 = byteBuffer.position();
        if (this.getSize() > n4 + 2) {
            object3 = ObjectDescriptorFactory.createFrom((int)-1, (ByteBuffer)byteBuffer);
            l2 = byteBuffer.position() - n6;
            object2 = log;
            object = new StringBuilder().append(object3).append(" - ESDescriptor1 read: ").append(l2).append(", size: ");
            n2 = object3 != null ? Integer.valueOf(((BaseDescriptor)object3).getSize()) : null;
            ((Logger)object2).finer(((StringBuilder)object).append(n2).toString());
            if (object3 != null) {
                n3 = ((BaseDescriptor)object3).getSize();
                byteBuffer.position(n6 + n3);
                n6 = n3 + n4;
            } else {
                n6 = (int)((long)n4 + l2);
            }
            n4 = n6;
            if (object3 instanceof DecoderConfigDescriptor) {
                this.decoderConfigDescriptor = (DecoderConfigDescriptor)object3;
                n4 = n6;
            }
        }
        n3 = byteBuffer.position();
        if (this.getSize() > n4 + 2) {
            object2 = ObjectDescriptorFactory.createFrom((int)-1, (ByteBuffer)byteBuffer);
            l2 = byteBuffer.position() - n3;
            object3 = log;
            object = new StringBuilder().append(object2).append(" - ESDescriptor2 read: ").append(l2).append(", size: ");
            n2 = object2 != null ? Integer.valueOf(((BaseDescriptor)object2).getSize()) : null;
            ((Logger)object3).finer(((StringBuilder)object).append(n2).toString());
            if (object2 != null) {
                n6 = ((BaseDescriptor)object2).getSize();
                byteBuffer.position(n3 + n6);
                n6 = n4 + n6;
            } else {
                n6 = (int)((long)n4 + l2);
            }
            n4 = n6;
            if (object2 instanceof SLConfigDescriptor) {
                this.slConfigDescriptor = (SLConfigDescriptor)object2;
                n4 = n6;
            }
        } else {
            log.warning("SLConfigDescriptor is missing!");
        }
        while (this.getSize() - n4 > 2) {
            n6 = byteBuffer.position();
            object = ObjectDescriptorFactory.createFrom((int)-1, (ByteBuffer)byteBuffer);
            l2 = byteBuffer.position() - n6;
            object2 = log;
            object3 = new StringBuilder().append(object).append(" - ESDescriptor3 read: ").append(l2).append(", size: ");
            n2 = object != null ? Integer.valueOf(((BaseDescriptor)object).getSize()) : null;
            ((Logger)object2).finer(((StringBuilder)object3).append(n2).toString());
            if (object != null) {
                n3 = ((BaseDescriptor)object).getSize();
                byteBuffer.position(n6 + n3);
                n4 += n3;
            } else {
                n4 = (int)(l2 + (long)n4);
            }
            this.otherDescriptors.add((BaseDescriptor)object);
        }
        return;
    }

    public ByteBuffer serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.serializedSize());
        IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)3);
        IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)(this.serializedSize() - 2));
        IsoTypeWriter.writeUInt16((ByteBuffer)byteBuffer, (int)this.esId);
        IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)(this.streamDependenceFlag << 7 | this.URLFlag << 6 | this.oCRstreamFlag << 5 | this.streamPriority & 0x1F));
        if (this.streamDependenceFlag > 0) {
            IsoTypeWriter.writeUInt16((ByteBuffer)byteBuffer, (int)this.dependsOnEsId);
        }
        if (this.URLFlag > 0) {
            IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)this.URLLength);
            IsoTypeWriter.writeUtf8String((ByteBuffer)byteBuffer, (String)this.URLString);
        }
        if (this.oCRstreamFlag > 0) {
            IsoTypeWriter.writeUInt16((ByteBuffer)byteBuffer, (int)this.oCREsId);
        }
        ByteBuffer byteBuffer2 = this.decoderConfigDescriptor.serialize();
        ByteBuffer byteBuffer3 = this.slConfigDescriptor.serialize();
        byteBuffer.put(byteBuffer2.array());
        byteBuffer.put(byteBuffer3.array());
        return byteBuffer;
    }

    public int serializedSize() {
        int n2 = 5;
        if (this.streamDependenceFlag > 0) {
            n2 = 7;
        }
        int n3 = n2;
        if (this.URLFlag > 0) {
            n3 = n2 + (this.URLLength + 1);
        }
        n2 = n3;
        if (this.oCRstreamFlag > 0) {
            n2 = n3 + 2;
        }
        return n2 + this.decoderConfigDescriptor.serializedSize() + this.slConfigDescriptor.serializedSize();
    }

    public void setDecoderConfigDescriptor(DecoderConfigDescriptor decoderConfigDescriptor) {
        this.decoderConfigDescriptor = decoderConfigDescriptor;
    }

    public void setDependsOnEsId(int n2) {
        this.dependsOnEsId = n2;
    }

    public void setEsId(int n2) {
        this.esId = n2;
    }

    public void setRemoteODFlag(int n2) {
        this.remoteODFlag = n2;
    }

    public void setSlConfigDescriptor(SLConfigDescriptor sLConfigDescriptor) {
        this.slConfigDescriptor = sLConfigDescriptor;
    }

    public void setStreamDependenceFlag(int n2) {
        this.streamDependenceFlag = n2;
    }

    public void setStreamPriority(int n2) {
        this.streamPriority = n2;
    }

    public void setURLFlag(int n2) {
        this.URLFlag = n2;
    }

    public void setURLLength(int n2) {
        this.URLLength = n2;
    }

    public void setURLString(String string2) {
        this.URLString = string2;
    }

    public void setoCREsId(int n2) {
        this.oCREsId = n2;
    }

    public void setoCRstreamFlag(int n2) {
        this.oCRstreamFlag = n2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ESDescriptor");
        stringBuilder.append("{esId=").append(this.esId);
        stringBuilder.append(", streamDependenceFlag=").append(this.streamDependenceFlag);
        stringBuilder.append(", URLFlag=").append(this.URLFlag);
        stringBuilder.append(", oCRstreamFlag=").append(this.oCRstreamFlag);
        stringBuilder.append(", streamPriority=").append(this.streamPriority);
        stringBuilder.append(", URLLength=").append(this.URLLength);
        stringBuilder.append(", URLString='").append(this.URLString).append('\'');
        stringBuilder.append(", remoteODFlag=").append(this.remoteODFlag);
        stringBuilder.append(", dependsOnEsId=").append(this.dependsOnEsId);
        stringBuilder.append(", oCREsId=").append(this.oCREsId);
        stringBuilder.append(", decoderConfigDescriptor=").append(this.decoderConfigDescriptor);
        stringBuilder.append(", slConfigDescriptor=").append(this.slConfigDescriptor);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

