/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.PropertyBoxParserImpl;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.MovieBox;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.FileDataSourceImpl;
import com.googlecode.mp4parser.annotations.DoNotParseDetail;
import com.googlecode.mp4parser.util.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;

@DoNotParseDetail
public class IsoFile
extends BasicContainer
implements Closeable {
    private static Logger LOG = Logger.getLogger(IsoFile.class);

    public IsoFile(DataSource dataSource) throws IOException {
        this.parseContainer(dataSource, dataSource.size(), (BoxParser)new PropertyBoxParserImpl(new String[0]));
    }

    public IsoFile(DataSource dataSource, BoxParser boxParser) throws IOException {
        this.dataSource = dataSource;
        this.boxParser = boxParser;
    }

    public IsoFile(String string2) throws IOException {
        this((DataSource)new FileDataSourceImpl(new File(string2)));
    }

    public static String bytesToFourCC(byte[] object) {
        byte[] byArray = new byte[4];
        if (object != null) {
            System.arraycopy(object, 0, byArray, 0, Math.min(((byte[])object).length, 4));
        }
        try {
            object = new String(byArray, "ISO-8859-1");
            return object;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Required character encoding is missing", unsupportedEncodingException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] fourCCtoBytes(String string2) {
        byte[] byArray = new byte[4];
        if (string2 == null) return byArray;
        int n2 = 0;
        while (n2 < Math.min(4, string2.length())) {
            byArray[n2] = (byte)string2.charAt(n2);
            ++n2;
        }
        return byArray;
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        this.writeContainer(writableByteChannel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MovieBox getMovieBox() {
        Box box;
        Iterator iterator = this.getBoxes().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!((box = (Box)iterator.next()) instanceof MovieBox));
        return (MovieBox)box;
    }

    public long getSize() {
        return this.getContainerSize();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IsoFile[").append(this.dataSource.toString()).append("]");
        return stringBuilder.toString();
    }
}

