/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.parse.message;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.common.gmacs.R;
import com.common.gmacs.msg.ChannelMsgParser;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.msg.data.IMAudioMsg;
import com.common.gmacs.msg.data.IMCallMsg;
import com.common.gmacs.msg.data.IMGifMsg;
import com.common.gmacs.msg.data.IMImageMsg;
import com.common.gmacs.msg.data.IMLocationMsg;
import com.common.gmacs.msg.data.IMReqFriendMsg;
import com.common.gmacs.msg.data.IMTextMsg;
import com.common.gmacs.msg.data.IMTipMsg;
import com.common.gmacs.parse.message.Message;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.StringUtil;
import com.wuba.wchat.api.Define;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageDetail {
    private String mContentType;
    public boolean mIsSelfSendMsg;
    public Message mMessage;
    private IMMessage mMsgContent;
    public long mMsgUpdateTime;
    private int playStatus;
    private int readStatus;
    private String refer;
    private int sendStatus;

    public MessageDetail(Message message) {
        this.mMessage = message;
        if (this.mMessage != null) {
            this.mMessage.mMsgDetail = this;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IMMessage parseExceptionContent() {
        IMTipMsg iMTipMsg = new IMTipMsg();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"tip");
            jSONObject.put("text", (Object)GmacsEnvi.appContext.getString(R.string.message_type_cannot_be_supported));
            iMTipMsg.parse(jSONObject);
            return iMTipMsg;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return iMTipMsg;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyMsgContent(MessageDetail messageDetail) {
        if (messageDetail == null) {
            return;
        }
        this.mIsSelfSendMsg = messageDetail.mIsSelfSendMsg;
        this.mMsgUpdateTime = messageDetail.mMsgUpdateTime;
        this.mMsgContent = messageDetail.mMsgContent;
        this.mContentType = messageDetail.mContentType;
        this.sendStatus = messageDetail.sendStatus;
        this.readStatus = messageDetail.readStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyRefer(MessageDetail messageDetail) {
        if (messageDetail == null) {
            return;
        }
        this.refer = messageDetail.refer;
    }

    public int getMsgPlayStatus() {
        return this.playStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpannableStringBuilder getPlainTextSpannableStringBuilder(Context context) {
        if (this.mMsgContent == null) return null;
        return this.mMsgContent.getPlainTextSpannableStringBuilder(context);
    }

    public int getReadStatus() {
        return this.readStatus;
    }

    public String getRefer() {
        return this.refer;
    }

    public int getSendStatus() {
        return this.sendStatus;
    }

    public IMMessage getmMsgContent() {
        return this.mMsgContent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMsgSendFailed() {
        if (this.sendStatus != Define.SendStatus.MSG_SEND_FAILED.getValue()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMsgSendSuccess() {
        if (this.sendStatus != 3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMsgSending() {
        boolean bl2 = true;
        if (this.sendStatus != 1) return false;
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isShowSenderName() {
        if (this.mMsgContent == null) return false;
        return this.mMsgContent.isShowSenderName();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseFromMsg(Define.Msg msg, boolean bl2) {
        if (msg == null) {
            return;
        }
        this.mMsgUpdateTime = msg.getUpdateTime();
        this.sendStatus = msg.getSendStatus().getValue();
        this.readStatus = msg.getReadStatus().getValue();
        this.playStatus = msg.getPlayStatus().getValue();
        this.mContentType = msg.getContentType();
        this.mIsSelfSendMsg = bl2;
        if (!bl2) return;
        this.readStatus = 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMMessage parseMsgContent(Define.Msg object) {
        JSONObject jSONObject;
        block26: {
            block25: {
                String string2;
                block24: {
                    string2 = object.getContent();
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        try {
                            jSONObject = new JSONObject(string2);
                            break block24;
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                    jSONObject = null;
                }
                if (jSONObject == null || TextUtils.isEmpty((CharSequence)(string2 = jSONObject.optString("type"))) || !string2.equals(object.getContentType())) break block25;
                string2 = object.getContentType();
                int n2 = -1;
                switch (string2.hashCode()) {
                    case 3556653: {
                        if (!string2.equals("text")) break;
                        n2 = 0;
                        break;
                    }
                    case 100313435: {
                        if (!string2.equals("image")) break;
                        n2 = 1;
                        break;
                    }
                    case 93166550: {
                        if (!string2.equals("audio")) break;
                        n2 = 2;
                        break;
                    }
                    case 1901043637: {
                        if (!string2.equals("location")) break;
                        n2 = 3;
                        break;
                    }
                    case 114843: {
                        if (!string2.equals("tip")) break;
                        n2 = 4;
                        break;
                    }
                    case 102340: {
                        if (!string2.equals("gif")) break;
                        n2 = 5;
                        break;
                    }
                    case 3045982: {
                        if (!string2.equals("call")) break;
                        n2 = 6;
                        break;
                    }
                    case 2014249311: {
                        if (!string2.equals("req_friend")) break;
                        n2 = 7;
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        if (ChannelMsgParser.getInstance().getImMessageParser() == null) break;
                        object = ChannelMsgParser.getInstance().getImMessageParser().parseImMessage(object.getContentType());
                        break block26;
                    }
                    case 0: {
                        object = new IMTextMsg();
                        break block26;
                    }
                    case 1: {
                        object = new IMImageMsg();
                        break block26;
                    }
                    case 2: {
                        object = new IMAudioMsg();
                        break block26;
                    }
                    case 3: {
                        object = new IMLocationMsg();
                        break block26;
                    }
                    case 4: {
                        object = new IMTipMsg();
                        break block26;
                    }
                    case 5: {
                        object = new IMGifMsg();
                        break block26;
                    }
                    case 6: {
                        object = new IMCallMsg();
                        break block26;
                    }
                    case 7: {
                        object = new IMReqFriendMsg();
                        break block26;
                    }
                }
            }
            object = null;
        }
        if (object == null) {
            return this.parseExceptionContent();
        }
        ((IMMessage)object).setParentMsg(this);
        ((IMMessage)object).parse(jSONObject);
        return object;
    }

    public void parseRefer(Define.Msg msg) {
        this.refer = msg.getRefer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putIntoMsg(Define.Msg msg) {
        if (msg == null) {
            return;
        }
        msg.content_type = this.mContentType;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)this.mContentType);
        }
        catch (JSONException jSONException) {}
        if (this.mMsgContent != null) {
            this.mMsgContent.putInfoToJson(jSONObject);
        }
        msg.content = jSONObject.toString();
        msg.read_status = Define.ReadStatus.valueOf((int)this.readStatus);
        msg.send_status = Define.SendStatus.valueOf((int)this.sendStatus);
        msg.play_status = Define.PlayStatus.valueOf((int)this.playStatus);
        msg.update_time = this.mMsgUpdateTime;
        msg.refer = StringUtil.replaceNull(this.refer);
    }

    public void setMessage(Message message) {
        this.mMessage = message;
    }

    public void setMsgContent(IMMessage iMMessage) {
        this.mMsgContent = iMMessage;
        if (this.mMsgContent != null) {
            this.mContentType = iMMessage.mType;
            this.mMsgContent.parentMsg = this;
        }
    }

    public void setMsgPlayStatus(int n2) {
        this.playStatus = n2;
    }

    public void setMsgReadStatus(int n2) {
        this.readStatus = n2;
    }

    public void setMsgSendStatus(int n2) {
        this.sendStatus = n2;
    }

    public void setRefer(String string2) {
        this.refer = string2;
    }

    public String toString() {
        return "MessageDetail{mMsgUpdateTime=" + this.mMsgUpdateTime + ", mMsgContent=" + this.mMsgContent + ", mContentType=" + this.mContentType + ", sendStatus=" + this.sendStatus + ", readStatus=" + this.readStatus + ", playStatus=" + this.playStatus + ", mIsSelfSendMsg=" + this.mIsSelfSendMsg + ", refer=" + this.refer + "}";
    }
}

