/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.msg.data;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import com.common.gmacs.R;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.utils.GmacsEnvi;
import org.json.JSONException;
import org.json.JSONObject;

public class IMCallMsg
extends IMMessage {
    public static final int BUSY = 4;
    public static final int CALL_TYPE_AUDIO = 0;
    public static final int CALL_TYPE_VIDEO = 1;
    public static final int CANCELED = 0;
    public static final int FAILED = 5;
    public static final int HANG_UP = 3;
    public static final int REFUSED = 1;
    public static final int TIME_OUT = 2;
    public int callType;
    public int durationInSeconds;
    public String extra;
    public int finalState;
    public SpannableStringBuilder style;

    public IMCallMsg() {
        super("call");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getPlainText() {
        if (this.finalState == 5) {
            return "[\u547c\u53eb\u5931\u8d25]";
        }
        switch (this.callType) {
            default: {
                return "";
            }
            case 0: {
                return "[\u8bed\u97f3\u901a\u8bdd]";
            }
            case 1: 
        }
        return "[\u89c6\u9891\u901a\u8bdd]";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SpannableStringBuilder getPlainTextSpannableStringBuilder(Context context) {
        if (this.style == null) {
            this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
            context = !this.parentMsg.mIsSelfSendMsg && this.parentMsg.getReadStatus() == 0 ? new ForegroundColorSpan(context.getResources().getColor(R.color.red)) : new ForegroundColorSpan(context.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)context, 0, 6, 34);
        }
        return this.style;
    }

    @Override
    public boolean isShowSenderName() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parse(JSONObject jSONObject) {
        this.finalState = jSONObject.optInt("final_state");
        this.callType = jSONObject.optInt("call_type");
        this.durationInSeconds = jSONObject.optInt("duration_in_seconds");
        this.extra = jSONObject.optString("extra");
        if (this.style == null) {
            this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
            jSONObject = !this.parentMsg.mIsSelfSendMsg && this.parentMsg.getMsgPlayStatus() == 0 ? new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.red)) : new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)jSONObject, 0, 6, 34);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void putInfoToJson(JSONObject jSONObject) {
        if (jSONObject == null) return;
        try {
            jSONObject.put("final_state", this.finalState);
            jSONObject.put("call_type", this.callType);
            jSONObject.put("duration_in_seconds", this.durationInSeconds);
            jSONObject.put("extra", (Object)this.extra);
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }
}

